/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.core;

import java.io.IOException;
import org.tmatesoft.hg.core.HgAbstractCommand;
import org.tmatesoft.hg.core.HgBadArgumentException;
import org.tmatesoft.hg.core.HgException;
import org.tmatesoft.hg.core.HgLibraryFailureException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.COWTransaction;
import org.tmatesoft.hg.internal.CommitFacility;
import org.tmatesoft.hg.internal.CompleteRepoLock;
import org.tmatesoft.hg.internal.FileContentSupplier;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.internal.Transaction;
import org.tmatesoft.hg.internal.WorkingCopyContent;
import org.tmatesoft.hg.repo.HgChangelog;
import org.tmatesoft.hg.repo.HgDataFile;
import org.tmatesoft.hg.repo.HgInternals;
import org.tmatesoft.hg.repo.HgInvalidControlFileException;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.repo.HgStatusCollector;
import org.tmatesoft.hg.repo.HgWorkingCopyStatusCollector;
import org.tmatesoft.hg.util.CancelledException;
import org.tmatesoft.hg.util.Outcome;
import org.tmatesoft.hg.util.Pair;
import org.tmatesoft.hg.util.Path;

public class HgCommitCommand
extends HgAbstractCommand<HgCommitCommand> {
    private final HgRepository repo;
    private String message;
    private String user;
    private Nodeid newRevision;

    public HgCommitCommand(HgRepository hgRepo) {
        this.repo = hgRepo;
    }

    public HgCommitCommand message(String msg) {
        this.message = msg;
        return this;
    }

    public HgCommitCommand user(String userName) {
        this.user = userName;
        return this;
    }

    public boolean isMergeCommit() throws HgException {
        try {
            int[] parents = new int[2];
            this.detectParentFromDirstate(parents);
            return parents[0] != -1 && parents[1] != -1;
        }
        catch (HgRuntimeException ex) {
            throw new HgLibraryFailureException(ex);
        }
    }

    public Outcome execute() throws HgException, IOException, CancelledException {
        if (this.message == null) {
            throw new HgBadArgumentException("Shall supply commit message", null);
        }
        CompleteRepoLock repoLock = new CompleteRepoLock(this.repo);
        repoLock.acquire();
        try {
            HgDataFile df;
            int[] parentRevs = new int[2];
            this.detectParentFromDirstate(parentRevs);
            if (parentRevs[0] != -1 && parentRevs[1] != -1) {
                throw new HgBadArgumentException("Sorry, I'm not yet smart enough to perform merge commits", null);
            }
            HgWorkingCopyStatusCollector sc = new HgWorkingCopyStatusCollector(this.repo);
            HgStatusCollector.Record status = sc.status(-2);
            if (status.getModified().size() == 0 && status.getAdded().size() == 0 && status.getRemoved().size() == 0) {
                this.newRevision = Nodeid.NULL;
                Outcome outcome = new Outcome(Outcome.Kind.Failure, "nothing to add");
                return outcome;
            }
            CommitFacility cf = new CommitFacility(Internals.getInstance(this.repo), parentRevs[0], parentRevs[1]);
            for (Path m : status.getModified()) {
                df = this.repo.getFileNode(m);
                cf.add(df, new WorkingCopyContent(df));
            }
            for (Path a : status.getAdded()) {
                df = this.repo.getFileNode(a);
                cf.add(df, new FileContentSupplier(this.repo, a));
            }
            for (Path r : status.getRemoved()) {
                df = this.repo.getFileNode(r);
                cf.forget(df);
            }
            cf.branch(this.detectBranch());
            cf.user(this.detectUser());
            COWTransaction.Factory trFactory = new COWTransaction.Factory();
            Transaction tr = trFactory.create(this.repo);
            try {
                this.newRevision = cf.commit(this.message, tr);
                tr.commit();
            }
            catch (RuntimeException ex) {
                tr.rollback();
                throw ex;
            }
            catch (HgException ex) {
                tr.rollback();
                throw ex;
            }
            Outcome outcome = new Outcome(Outcome.Kind.Success, "Commit ok");
            return outcome;
        }
        catch (HgRuntimeException ex) {
            throw new HgLibraryFailureException(ex);
        }
        finally {
            repoLock.release();
        }
    }

    public Nodeid getCommittedRevision() {
        if (this.newRevision == null) {
            throw new IllegalStateException("Call #execute() first!");
        }
        return this.newRevision;
    }

    private String detectBranch() throws HgInvalidControlFileException {
        return this.repo.getWorkingCopyBranchName();
    }

    private String detectUser() {
        if (this.user != null) {
            return this.user;
        }
        return new HgInternals(this.repo).getNextCommitUsername();
    }

    private void detectParentFromDirstate(int[] parents) throws HgRuntimeException {
        Pair<Nodeid, Nodeid> pn = this.repo.getWorkingCopyParents();
        HgChangelog clog = this.repo.getChangelog();
        parents[0] = pn.first().isNull() ? -1 : clog.getRevisionIndex(pn.first());
        parents[1] = pn.second().isNull() ? -1 : clog.getRevisionIndex(pn.second());
    }
}

