/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.core;

import java.util.Calendar;
import java.util.Formatter;
import java.util.Locale;
import java.util.TimeZone;

public final class HgDate
implements Comparable<HgDate>,
Cloneable {
    private final long time;
    private final TimeZone tzone;

    public HgDate(long millis, int timezone) {
        TimeZone tz;
        this.time = millis;
        int tz_hours = -timezone / 3600;
        int tz_mins = timezone % 3600;
        String customId = String.format("GMT%+02d:%02d", tz_hours, tz_mins);
        this.tzone = tz = TimeZone.getTimeZone(customId);
    }

    public long getRawTime() {
        return this.time;
    }

    public TimeZone getTimeZone() {
        return this.tzone;
    }

    public String toString() {
        return this.toString(Locale.US);
    }

    public String toString(Locale l) {
        Calendar c = Calendar.getInstance(this.getTimeZone());
        c.setTimeInMillis(this.getRawTime());
        Formatter f = new Formatter(new StringBuilder(), l);
        f.format("%ta %<tb %<td %<tH:%<tM:%<tS %<tY %<tz", c);
        return f.out().toString();
    }

    @Override
    public int compareTo(HgDate o) {
        return (int)(this.time - o.time);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HgDate)) {
            return false;
        }
        HgDate other = (HgDate)obj;
        return this.compareTo(other) == 0;
    }

    public int hashCode() {
        return (int)this.time ^ (int)(this.time >> 32);
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.toString());
        }
    }
}

