/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.core;

import org.tmatesoft.hg.core.HgAbstractCommand;
import org.tmatesoft.hg.core.HgBadArgumentException;
import org.tmatesoft.hg.core.HgBlameInspector;
import org.tmatesoft.hg.core.HgCallbackTargetException;
import org.tmatesoft.hg.core.HgException;
import org.tmatesoft.hg.core.HgIterateDirection;
import org.tmatesoft.hg.core.HgLibraryFailureException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.BlameHelper;
import org.tmatesoft.hg.internal.CsetParamKeeper;
import org.tmatesoft.hg.internal.FileHistory;
import org.tmatesoft.hg.internal.FileRevisionHistoryChunk;
import org.tmatesoft.hg.repo.HgDataFile;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.CancelSupport;
import org.tmatesoft.hg.util.CancelledException;
import org.tmatesoft.hg.util.Path;
import org.tmatesoft.hg.util.ProgressSupport;

public class HgDiffCommand
extends HgAbstractCommand<HgDiffCommand> {
    private final HgRepository repo;
    private HgDataFile df;
    private final CsetParamKeeper clogRevIndexStart;
    private final CsetParamKeeper clogRevIndexEnd;
    private HgIterateDirection iterateDirection = HgIterateDirection.NewToOld;

    public HgDiffCommand(HgRepository hgRepo) {
        this.repo = hgRepo;
        this.clogRevIndexStart = new CsetParamKeeper(hgRepo);
        this.clogRevIndexEnd = new CsetParamKeeper(hgRepo);
    }

    public HgDiffCommand file(Path file) {
        this.df = this.repo.getFileNode(file);
        return this;
    }

    public HgDiffCommand file(HgDataFile file) {
        this.df = file;
        return this;
    }

    public HgDiffCommand range(int changelogRevIndexStart, int changelogRevIndexEnd) throws HgBadArgumentException {
        this.clogRevIndexStart.set(changelogRevIndexStart);
        this.clogRevIndexEnd.set(changelogRevIndexEnd);
        return this;
    }

    public HgDiffCommand range(Nodeid cset1, Nodeid cset2) throws HgBadArgumentException {
        this.clogRevIndexStart.set(cset1);
        this.clogRevIndexEnd.set(cset2);
        return this;
    }

    public HgDiffCommand changeset(int changelogRevIndex) throws HgBadArgumentException {
        this.clogRevIndexStart.set(0);
        this.clogRevIndexEnd.set(changelogRevIndex);
        return this;
    }

    public HgDiffCommand changeset(Nodeid nid) throws HgBadArgumentException {
        this.clogRevIndexStart.set(0);
        this.clogRevIndexEnd.set(nid);
        return this;
    }

    public HgDiffCommand order(HgIterateDirection order) {
        this.iterateDirection = order;
        return this;
    }

    public void executeDiff(HgBlameInspector insp) throws HgCallbackTargetException, CancelledException, HgException {
        this.checkFile();
        ProgressSupport progress = this.getProgressSupport(insp);
        progress.start(2);
        try {
            try {
                int startRevIndex = this.clogRevIndexStart.get(0);
                int endRevIndex = this.clogRevIndexEnd.get(-3);
                CancelSupport cancel = this.getCancelSupport(insp, true);
                int fileRevIndex1 = HgDiffCommand.fileRevIndex(this.df, startRevIndex);
                int fileRevIndex2 = HgDiffCommand.fileRevIndex(this.df, endRevIndex);
                BlameHelper bh = new BlameHelper(insp);
                bh.prepare(this.df, startRevIndex, endRevIndex);
                progress.worked(1);
                cancel.checkCancelled();
                bh.diff(fileRevIndex1, startRevIndex, fileRevIndex2, endRevIndex);
                progress.worked(1);
                cancel.checkCancelled();
            }
            catch (HgRuntimeException ex) {
                throw new HgLibraryFailureException(ex);
            }
        }
        finally {
            progress.done();
        }
    }

    public void executeAnnotate(HgBlameInspector insp) throws HgCallbackTargetException, CancelledException, HgException {
        this.checkFile();
        ProgressSupport progress = null;
        try {
            if (!this.df.exists()) {
                return;
            }
            try {
                CancelSupport cancel = this.getCancelSupport(insp, true);
                BlameHelper bh = new BlameHelper(insp);
                int startRevIndex = this.clogRevIndexStart.get(0);
                int endRevIndex = this.clogRevIndexEnd.get(-3);
                FileHistory fileHistory = bh.prepare(this.df, startRevIndex, endRevIndex);
                cancel.checkCancelled();
                int totalWork = 0;
                for (FileRevisionHistoryChunk fhc : fileHistory.iterate(this.iterateDirection)) {
                    totalWork += fhc.revisionCount();
                }
                progress = this.getProgressSupport(insp);
                progress.start(totalWork + 1);
                progress.worked(1);
                int[] fileClogParentRevs = new int[2];
                int[] fileParentRevs = new int[2];
                for (FileRevisionHistoryChunk fhc : fileHistory.iterate(this.iterateDirection)) {
                    int[] nArray = fhc.fileRevisions(this.iterateDirection);
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int fri = nArray[n2];
                        int clogRevIndex = fhc.changeset(fri);
                        assert (clogRevIndex >= startRevIndex);
                        assert (clogRevIndex <= endRevIndex);
                        fhc.fillFileParents(fri, fileParentRevs);
                        fhc.fillCsetParents(fri, fileClogParentRevs);
                        bh.annotateChange(fri, clogRevIndex, fileParentRevs, fileClogParentRevs);
                        progress.worked(1);
                        cancel.checkCancelled();
                        ++n2;
                    }
                }
            }
            catch (HgRuntimeException ex) {
                throw new HgLibraryFailureException(ex);
            }
        }
        finally {
            if (progress != null) {
                progress.done();
            }
        }
    }

    public void executeParentsAnnotate(HgBlameInspector insp) throws HgCallbackTargetException, CancelledException, HgException {
        this.checkFile();
        ProgressSupport progress = this.getProgressSupport(insp);
        progress.start(2);
        try {
            try {
                CancelSupport cancel = this.getCancelSupport(insp, true);
                int changelogRevisionIndex = this.clogRevIndexEnd.get();
                int fileRevIndex = HgDiffCommand.fileRevIndex(this.df, changelogRevisionIndex);
                int[] fileRevParents = new int[2];
                this.df.parents(fileRevIndex, fileRevParents, null, null);
                if (changelogRevisionIndex == -3) {
                    changelogRevisionIndex = this.df.getChangesetRevisionIndex(fileRevIndex);
                }
                int[] fileClogParentRevs = new int[]{fileRevParents[0] == -1 ? -1 : this.df.getChangesetRevisionIndex(fileRevParents[0]), fileRevParents[1] == -1 ? -1 : this.df.getChangesetRevisionIndex(fileRevParents[1])};
                BlameHelper bh = new BlameHelper(insp);
                int clogIndexStart = fileClogParentRevs[0] == -1 ? (fileClogParentRevs[1] == -1 ? 0 : fileClogParentRevs[1]) : fileClogParentRevs[0];
                bh.prepare(this.df, clogIndexStart, changelogRevisionIndex);
                progress.worked(1);
                cancel.checkCancelled();
                bh.annotateChange(fileRevIndex, changelogRevisionIndex, fileRevParents, fileClogParentRevs);
                progress.worked(1);
                cancel.checkCancelled();
            }
            catch (HgRuntimeException ex) {
                throw new HgLibraryFailureException(ex);
            }
        }
        finally {
            progress.done();
        }
    }

    private void checkFile() {
        if (this.df == null) {
            throw new IllegalArgumentException("File is not set");
        }
    }

    private static int fileRevIndex(HgDataFile df, int csetRevIndex) throws HgRuntimeException {
        Nodeid fileRev = df.getRepo().getManifest().getFileRevision(csetRevIndex, df.getPath());
        return df.getRevisionIndex(fileRev);
    }
}

