/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.core;

import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.repo.HgDataFile;
import org.tmatesoft.hg.repo.HgManifest;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.ByteChannel;
import org.tmatesoft.hg.util.CancelledException;
import org.tmatesoft.hg.util.Pair;
import org.tmatesoft.hg.util.Path;

public final class HgFileRevision {
    private final HgRepository repo;
    private final Nodeid revision;
    private final Path path;
    private Path origin;
    private Boolean isCopy = null;
    private Pair<Nodeid, Nodeid> parents;
    private HgManifest.Flags flags;

    public HgFileRevision(HgRepository hgRepo, Nodeid rev, HgManifest.Flags manifestEntryFlags, Path p) {
        if (hgRepo == null || rev == null || p == null) {
            throw new IllegalArgumentException();
        }
        this.repo = hgRepo;
        this.revision = rev;
        this.flags = manifestEntryFlags;
        this.path = p;
    }

    HgFileRevision(HgRepository hgRepo, Nodeid rev, HgManifest.Flags flags, Path p, Path orig) {
        this(hgRepo, rev, flags, p);
        this.isCopy = orig == null;
        this.origin = orig;
    }

    HgFileRevision(HgDataFile fileNode, Nodeid fileRevision, Path origin) {
        this(fileNode.getRepo(), fileRevision, null, fileNode.getPath(), origin);
    }

    public Path getPath() {
        return this.path;
    }

    public Nodeid getRevision() {
        return this.revision;
    }

    public HgManifest.Flags getFileFlags() throws HgRuntimeException {
        if (this.flags == null) {
            HgDataFile df = this.repo.getFileNode(this.path);
            int revIdx = df.getRevisionIndex(this.revision);
            this.flags = df.getFlags(revIdx);
        }
        return this.flags;
    }

    public boolean wasCopied() throws HgRuntimeException {
        if (this.isCopy == null) {
            this.checkCopy();
        }
        return this.isCopy;
    }

    public Path getOriginIfCopy() throws HgRuntimeException {
        if (this.wasCopied()) {
            return this.origin;
        }
        return null;
    }

    public Pair<Nodeid, Nodeid> getParents() throws HgRuntimeException {
        if (this.parents == null) {
            HgDataFile fn = this.repo.getFileNode(this.path);
            int revisionIndex = fn.getRevisionIndex(this.revision);
            int[] pr = new int[2];
            byte[] p1 = new byte[20];
            byte[] p2 = new byte[20];
            fn.parents(revisionIndex, pr, p1, p2);
            this.parents = new Pair<Nodeid, Nodeid>(Nodeid.fromBinary(p1, 0), Nodeid.fromBinary(p2, 0));
        }
        return this.parents;
    }

    public void putContentTo(ByteChannel sink) throws HgRuntimeException, CancelledException {
        HgDataFile fn = this.repo.getFileNode(this.path);
        int revisionIndex = fn.getRevisionIndex(this.revision);
        fn.contentWithFilters(revisionIndex, sink);
    }

    public String toString() {
        return String.format("HgFileRevision(%s, %s)", this.getPath().toString(), this.revision.shortNotation());
    }

    private void checkCopy() throws HgRuntimeException {
        int revIdx;
        HgDataFile df = this.repo.getFileNode(this.path);
        if (df.isCopy(revIdx = df.getRevisionIndex(this.revision))) {
            this.isCopy = Boolean.TRUE;
            this.origin = df.getCopySource(revIdx).getPath();
            return;
        }
        this.isCopy = Boolean.FALSE;
    }
}

