/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.tmatesoft.hg.core.ChangesetTransformer;
import org.tmatesoft.hg.core.HgAbstractCommand;
import org.tmatesoft.hg.core.HgCallbackTargetException;
import org.tmatesoft.hg.core.HgChangesetHandler;
import org.tmatesoft.hg.core.HgException;
import org.tmatesoft.hg.core.HgLibraryFailureException;
import org.tmatesoft.hg.core.HgRemoteConnectionException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.internal.RepositoryComparator;
import org.tmatesoft.hg.repo.HgBundle;
import org.tmatesoft.hg.repo.HgChangelog;
import org.tmatesoft.hg.repo.HgParentChildMap;
import org.tmatesoft.hg.repo.HgRemoteRepository;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.CancelledException;
import org.tmatesoft.hg.util.ProgressSupport;

public class HgIncomingCommand
extends HgAbstractCommand<HgIncomingCommand> {
    private final HgRepository localRepo;
    private HgRemoteRepository remoteRepo;
    private boolean includeSubrepo;
    private RepositoryComparator comparator;
    private List<RepositoryComparator.BranchChain> missingBranches;
    private HgParentChildMap<HgChangelog> parentHelper;
    private Set<String> branches;

    public HgIncomingCommand(HgRepository hgRepo) {
        this.localRepo = hgRepo;
    }

    public HgIncomingCommand against(HgRemoteRepository hgRemote) {
        this.remoteRepo = hgRemote;
        this.comparator = null;
        this.missingBranches = null;
        return this;
    }

    public HgIncomingCommand branch(String branch) {
        if (branch == null) {
            throw new IllegalArgumentException();
        }
        if (this.branches == null) {
            this.branches = new TreeSet<String>();
        }
        this.branches.add(branch);
        return this;
    }

    public HgIncomingCommand subrepo(boolean include) {
        this.includeSubrepo = include;
        throw Internals.notImplemented();
    }

    public List<Nodeid> executeLite() throws HgException, CancelledException {
        try {
            LinkedHashSet<Nodeid> result = new LinkedHashSet<Nodeid>();
            RepositoryComparator repoCompare = this.getComparator();
            for (RepositoryComparator.BranchChain bc : this.getMissingBranches()) {
                List<Nodeid> missing = repoCompare.visitBranches(bc);
                HashSet<Nodeid> common = new HashSet<Nodeid>();
                repoCompare.collectKnownRoots(bc, common);
                Iterator<Nodeid> it = missing.iterator();
                while (it.hasNext() && common.contains(it.next())) {
                    it.remove();
                }
                result.addAll(missing);
            }
            ArrayList<Nodeid> rv = new ArrayList<Nodeid>(result);
            return rv;
        }
        catch (HgRuntimeException ex) {
            throw new HgLibraryFailureException(ex);
        }
    }

    public void executeFull(HgChangesetHandler handler) throws HgCallbackTargetException, HgException, CancelledException {
        if (handler == null) {
            throw new IllegalArgumentException("Delegate can't be null");
        }
        ProgressSupport ps = this.getProgressSupport(handler);
        try {
            try {
                List<Nodeid> common = this.getCommon();
                HgBundle changegroup = this.remoteRepo.getChanges(common);
                final ChangesetTransformer transformer = new ChangesetTransformer(this.localRepo, handler, this.getParentHelper(), ps, this.getCancelSupport(handler, true));
                transformer.limitBranches(this.branches);
                changegroup.changes(this.localRepo, new HgChangelog.Inspector(){
                    private int localIndex;
                    private final HgParentChildMap<HgChangelog> parentHelper;
                    {
                        this.parentHelper = HgIncomingCommand.this.getParentHelper();
                        this.localIndex = HgIncomingCommand.this.localRepo.getChangelog().getRevisionCount();
                    }

                    @Override
                    public void next(int revisionNumber, Nodeid nodeid, HgChangelog.RawChangeset cset) throws HgRuntimeException {
                        if (this.parentHelper.knownNode(nodeid)) {
                            return;
                        }
                        transformer.next(this.localIndex++, nodeid, cset);
                    }
                });
                transformer.checkFailure();
            }
            catch (HgRuntimeException ex) {
                throw new HgLibraryFailureException(ex);
            }
        }
        finally {
            ps.done();
        }
    }

    private RepositoryComparator getComparator() throws CancelledException, HgRuntimeException {
        if (this.remoteRepo == null) {
            throw new IllegalArgumentException("Shall specify remote repository to compare against", null);
        }
        if (this.comparator == null) {
            this.comparator = new RepositoryComparator(this.getParentHelper(), this.remoteRepo);
        }
        return this.comparator;
    }

    private HgParentChildMap<HgChangelog> getParentHelper() throws HgRuntimeException {
        if (this.parentHelper == null) {
            this.parentHelper = new HgParentChildMap<HgChangelog>(this.localRepo.getChangelog());
            this.parentHelper.init();
        }
        return this.parentHelper;
    }

    private List<RepositoryComparator.BranchChain> getMissingBranches() throws HgRemoteConnectionException, CancelledException, HgRuntimeException {
        if (this.missingBranches == null) {
            this.missingBranches = this.getComparator().calculateMissingBranches();
        }
        return this.missingBranches;
    }

    private List<Nodeid> getCommon() throws HgRemoteConnectionException, CancelledException, HgRuntimeException {
        LinkedHashSet<Nodeid> common = new LinkedHashSet<Nodeid>();
        RepositoryComparator repoCompare = this.getComparator();
        for (RepositoryComparator.BranchChain bc : this.getMissingBranches()) {
            repoCompare.collectKnownRoots(bc, common);
        }
        return new LinkedList<Nodeid>(common);
    }
}

