/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.core;

import java.io.File;
import org.tmatesoft.hg.core.HgAbstractCommand;
import org.tmatesoft.hg.core.HgException;
import org.tmatesoft.hg.core.HgRepositoryNotFoundException;
import org.tmatesoft.hg.internal.RepoInitializer;
import org.tmatesoft.hg.repo.HgLookup;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.util.CancelledException;

public class HgInitCommand
extends HgAbstractCommand<HgInitCommand> {
    private static final int V1_DEFAULT = 0x40000007;
    private final HgLookup hgLookup;
    private File location;
    private int requiresFlags;

    public HgInitCommand() {
        this(null);
    }

    public HgInitCommand(HgLookup lookupEnv) {
        this.hgLookup = lookupEnv;
        this.requiresFlags = 0x40000007;
    }

    public HgInitCommand location(File repoLoc) {
        this.location = repoLoc;
        return this;
    }

    public HgInitCommand revlogV0() {
        this.requiresFlags = Integer.MIN_VALUE;
        return this;
    }

    public HgInitCommand revlogV1() {
        this.requiresFlags = 0x40000007;
        return this;
    }

    public HgInitCommand store(boolean enable) {
        return this.switchFlag(1, enable);
    }

    public HgInitCommand fncache(boolean enable) {
        return this.switchFlag(2, enable);
    }

    public HgInitCommand dotencode(boolean enable) {
        return this.switchFlag(4, enable);
    }

    public HgRepository execute() throws HgRepositoryNotFoundException, HgException, CancelledException {
        if (this.location == null) {
            throw new IllegalArgumentException();
        }
        File repoDir = ".hg".equals(this.location.getName()) ? this.location : new File(this.location, ".hg");
        new RepoInitializer().setRequires(this.requiresFlags).initEmptyRepository(repoDir);
        return this.getNewRepository();
    }

    public HgRepository getNewRepository() throws HgRepositoryNotFoundException {
        HgLookup l = this.hgLookup == null ? new HgLookup() : this.hgLookup;
        return l.detect(this.location);
    }

    private HgInitCommand switchFlag(int flag, boolean enable) {
        this.requiresFlags = enable ? (this.requiresFlags |= flag) : (this.requiresFlags &= ~flag);
        return this;
    }
}

