/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.tmatesoft.hg.core.ChangesetTransformer;
import org.tmatesoft.hg.core.HgAbstractCommand;
import org.tmatesoft.hg.core.HgBadArgumentException;
import org.tmatesoft.hg.core.HgCallbackTargetException;
import org.tmatesoft.hg.core.HgChangeset;
import org.tmatesoft.hg.core.HgChangesetHandler;
import org.tmatesoft.hg.core.HgChangesetTreeHandler;
import org.tmatesoft.hg.core.HgException;
import org.tmatesoft.hg.core.HgFileRenameHandlerMixin;
import org.tmatesoft.hg.core.HgFileRevision;
import org.tmatesoft.hg.core.HgIterateDirection;
import org.tmatesoft.hg.core.HgLibraryFailureException;
import org.tmatesoft.hg.core.HgPathNotFoundException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.AdapterPlug;
import org.tmatesoft.hg.internal.BatchRangeHelper;
import org.tmatesoft.hg.internal.CsetParamKeeper;
import org.tmatesoft.hg.internal.FileRenameHistory;
import org.tmatesoft.hg.internal.IntMap;
import org.tmatesoft.hg.internal.IntVector;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.internal.Lifecycle;
import org.tmatesoft.hg.internal.LifecycleProxy;
import org.tmatesoft.hg.internal.ReverseIterator;
import org.tmatesoft.hg.repo.HgChangelog;
import org.tmatesoft.hg.repo.HgDataFile;
import org.tmatesoft.hg.repo.HgInvalidStateException;
import org.tmatesoft.hg.repo.HgParentChildMap;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.repo.HgStatusCollector;
import org.tmatesoft.hg.repo.Revlog;
import org.tmatesoft.hg.util.Adaptable;
import org.tmatesoft.hg.util.CancelSupport;
import org.tmatesoft.hg.util.CancelledException;
import org.tmatesoft.hg.util.LogFacility;
import org.tmatesoft.hg.util.Pair;
import org.tmatesoft.hg.util.Path;
import org.tmatesoft.hg.util.ProgressSupport;

public class HgLogCommand
extends HgAbstractCommand<HgLogCommand> {
    private final HgRepository repo;
    private Set<String> users;
    private Set<String> branches;
    private int limit = 0;
    private int count = 0;
    private int startRev = 0;
    private int endRev = -3;
    private Calendar date;
    private Path file;
    private boolean followRenames;
    private boolean followAncestry;
    private HgIterateDirection iterateDirection = HgIterateDirection.OldToNew;
    private ChangesetTransformer csetTransform;
    private HgParentChildMap<HgChangelog> parentHelper;

    public HgLogCommand(HgRepository hgRepo) {
        this.repo = hgRepo;
    }

    public HgLogCommand user(String user) {
        if (user == null) {
            throw new IllegalArgumentException();
        }
        if (this.users == null) {
            this.users = new TreeSet<String>();
        }
        this.users.add(user.toLowerCase());
        return this;
    }

    public HgLogCommand branch(String branch) {
        if (branch == null) {
            throw new IllegalArgumentException();
        }
        if (this.branches == null) {
            this.branches = new TreeSet<String>();
        }
        this.branches.add(branch);
        return this;
    }

    public HgLogCommand date(Calendar date) {
        this.date = date;
        throw Internals.notImplemented();
    }

    public HgLogCommand limit(int num) {
        this.limit = num;
        return this;
    }

    public HgLogCommand range(int rev1, int rev2) {
        if (rev1 != -3 && rev2 != -3) {
            this.startRev = rev2 < rev1 ? rev2 : rev1;
            this.endRev = this.startRev == rev2 ? rev1 : rev2;
        } else if (rev1 == -3 && rev2 != -3) {
            this.startRev = rev2;
            this.endRev = rev1;
        } else {
            this.startRev = rev1;
            this.endRev = rev2;
        }
        return this;
    }

    public HgLogCommand range(Nodeid cset1, Nodeid cset2) throws HgBadArgumentException {
        CsetParamKeeper pk = new CsetParamKeeper(this.repo);
        int r1 = pk.set(cset1).get();
        int r2 = pk.set(cset2).get();
        return this.range(r1, r2);
    }

    public HgLogCommand changeset(int revisionIndex) throws HgBadArgumentException {
        int ri = new CsetParamKeeper(this.repo).set(revisionIndex).get();
        return this.range(ri, ri);
    }

    public HgLogCommand changeset(Nodeid nid) throws HgBadArgumentException {
        int csetRevIndex = new CsetParamKeeper(this.repo).set(nid).get();
        return this.range(csetRevIndex, csetRevIndex);
    }

    public HgLogCommand file(Path filePath, boolean followCopyRename) {
        return this.file(filePath, followCopyRename, false);
    }

    public HgLogCommand file(Path filePath, boolean followCopyRename, boolean followFileAncestry) {
        this.file = filePath;
        this.followRenames = followCopyRename;
        this.followAncestry = followFileAncestry;
        return this;
    }

    public HgLogCommand file(String file, boolean followCopyRename) {
        Path.Source ps = this.repo.getSessionContext().getPathFactory();
        return this.file(ps.path(this.repo.getToRepoPathHelper().rewrite(file)), followCopyRename);
    }

    public HgLogCommand file(String file, boolean followCopyRename, boolean followFileAncestry) {
        Path.Source ps = this.repo.getSessionContext().getPathFactory();
        return this.file(ps.path(this.repo.getToRepoPathHelper().rewrite(file)), followCopyRename, followFileAncestry);
    }

    public HgLogCommand order(HgIterateDirection order) {
        this.iterateDirection = order;
        return this;
    }

    public List<HgChangeset> execute() throws HgException {
        CollectHandler collector = new CollectHandler();
        try {
            this.execute(collector);
        }
        catch (HgCallbackTargetException ex) {
            HgInvalidStateException t = new HgInvalidStateException("Internal error");
            t.initCause(ex);
            throw t;
        }
        catch (CancelledException ex) {
            HgInvalidStateException t = new HgInvalidStateException("Internal error");
            t.initCause(ex);
            throw t;
        }
        return collector.getChanges();
    }

    public void execute(HgChangesetHandler handler) throws HgCallbackTargetException, HgException, CancelledException {
        block33: {
            if (handler == null) {
                throw new IllegalArgumentException();
            }
            if (this.csetTransform != null) {
                throw new ConcurrentModificationException();
            }
            ProgressSupport progressHelper = this.getProgressSupport(handler);
            try {
                if (this.repo.getChangelog().getRevisionCount() == 0) {
                    return;
                }
                try {
                    int lastCset;
                    int firstCset = this.startRev;
                    int n = lastCset = this.endRev == -3 ? this.repo.getChangelog().getLastRevision() : this.endRev;
                    if (lastCset < 0 || lastCset > this.repo.getChangelog().getLastRevision()) {
                        throw new HgBadArgumentException(String.format("Bad value %d for end revision", lastCset), null);
                    }
                    if (firstCset < 0 || firstCset > lastCset) {
                        throw new HgBadArgumentException(String.format("Bad value %d for start revision for range [%1$d..%d]", firstCset, lastCset), null);
                    }
                    this.count = 0;
                    HgParentChildMap<HgChangelog> pw = this.getParentHelper(this.file == null);
                    this.csetTransform = new ChangesetTransformer(this.repo, handler, pw, progressHelper, this.getCancelSupport(handler, true));
                    FilteringInspector filterInsp = new FilteringInspector();
                    filterInsp.changesets(firstCset, lastCset);
                    if (this.file == null) {
                        progressHelper.start(lastCset - firstCset + 1);
                        if (this.iterateDirection == HgIterateDirection.OldToNew) {
                            filterInsp.delegateTo(this.csetTransform);
                            this.repo.getChangelog().range(firstCset, lastCset, filterInsp);
                            this.csetTransform.checkFailure();
                        } else {
                            assert (this.iterateDirection == HgIterateDirection.NewToOld);
                            BatchRangeHelper brh = new BatchRangeHelper(firstCset, lastCset, 100, true);
                            BatchChangesetInspector batchInspector = new BatchChangesetInspector(Math.min(lastCset - firstCset + 1, 100));
                            filterInsp.delegateTo(batchInspector);
                            while (brh.hasNext()) {
                                brh.next();
                                this.repo.getChangelog().range(brh.start(), brh.end(), filterInsp);
                                for (BatchChangesetInspector.BatchRecord br : batchInspector.iterate(true)) {
                                    this.csetTransform.next(br.csetIndex, br.csetRevision, br.cset);
                                    this.csetTransform.checkFailure();
                                }
                                batchInspector.reset();
                            }
                        }
                        break block33;
                    }
                    filterInsp.delegateTo(this.csetTransform);
                    HgFileRenameHandlerMixin withCopyHandler = Adaptable.Factory.getAdapter(handler, HgFileRenameHandlerMixin.class, null);
                    FileRenameQueueBuilder frqBuilder = new FileRenameQueueBuilder();
                    List<QueueElement> fileRenames = frqBuilder.buildFileRenamesQueue(firstCset, lastCset);
                    progressHelper.start(fileRenames.size());
                    int nameIndex = 0;
                    int fileRenamesSize = fileRenames.size();
                    while (nameIndex < fileRenamesSize) {
                        QueueElement curRename = fileRenames.get(nameIndex);
                        HgDataFile fileNode = curRename.file();
                        if (this.followAncestry) {
                            TreeBuildInspector treeBuilder = new TreeBuildInspector(this.followAncestry);
                            treeBuilder.go(curRename);
                            int[] commitRevisions = HgLogCommand.narrowChangesetRange(treeBuilder.getCommitRevisions(), firstCset, lastCset);
                            if (this.iterateDirection == HgIterateDirection.OldToNew) {
                                this.repo.getChangelog().range(filterInsp, commitRevisions);
                                this.csetTransform.checkFailure();
                            } else {
                                assert (this.iterateDirection == HgIterateDirection.NewToOld);
                                int i = commitRevisions.length - 1;
                                while (i >= 0) {
                                    int csetWithFileChange = commitRevisions[i];
                                    this.repo.getChangelog().range(csetWithFileChange, csetWithFileChange, filterInsp);
                                    --i;
                                }
                            }
                        } else {
                            int fileStartRev = curRename.fileFrom();
                            int fileEndRev = curRename.file().getLastRevision();
                            if (this.iterateDirection == HgIterateDirection.OldToNew) {
                                fileNode.history(fileStartRev, fileEndRev, filterInsp);
                                this.csetTransform.checkFailure();
                            } else {
                                assert (this.iterateDirection == HgIterateDirection.NewToOld);
                                BatchRangeHelper brh = new BatchRangeHelper(fileStartRev, fileEndRev, 100, true);
                                BatchChangesetInspector batchInspector = new BatchChangesetInspector(Math.min(fileEndRev - fileStartRev + 1, 100));
                                filterInsp.delegateTo(batchInspector);
                                while (brh.hasNext()) {
                                    brh.next();
                                    fileNode.history(brh.start(), brh.end(), filterInsp);
                                    for (BatchChangesetInspector.BatchRecord br : batchInspector.iterate(true)) {
                                        this.csetTransform.next(br.csetIndex, br.csetRevision, br.cset);
                                        this.csetTransform.checkFailure();
                                    }
                                    batchInspector.reset();
                                }
                            }
                        }
                        if (withCopyHandler != null && nameIndex + 1 < fileRenamesSize) {
                            HgFileRevision dst;
                            HgFileRevision src;
                            QueueElement nextRename = fileRenames.get(nameIndex + 1);
                            if (this.iterateDirection == HgIterateDirection.OldToNew) {
                                src = curRename.last();
                                dst = nextRename.first(src);
                            } else {
                                assert (this.iterateDirection == HgIterateDirection.NewToOld);
                                src = nextRename.last();
                                dst = curRename.first(src);
                            }
                            withCopyHandler.copy(src, dst);
                        }
                        progressHelper.worked(1);
                        ++nameIndex;
                    }
                    frqBuilder.reportRenameIfNotInQueue(fileRenames, withCopyHandler);
                }
                catch (HgRuntimeException ex) {
                    throw new HgLibraryFailureException(ex);
                }
            }
            finally {
                this.csetTransform = null;
                progressHelper.done();
            }
        }
    }

    private static int[] narrowChangesetRange(int[] csetRange, int startCset, int endCset) {
        int lastInRange = csetRange[csetRange.length - 1];
        assert (csetRange.length < 2 || csetRange[0] < lastInRange);
        assert (startCset >= 0 && startCset <= endCset);
        if (csetRange[0] >= startCset && lastInRange <= endCset) {
            return csetRange;
        }
        if (csetRange[0] > endCset || lastInRange < startCset) {
            return new int[0];
        }
        int i = 0;
        while (i < csetRange.length && csetRange[i] < startCset) {
            ++i;
        }
        int j = csetRange.length - 1;
        while (j > i && csetRange[j] > endCset) {
            --j;
        }
        if (i == j) {
            return new int[0];
        }
        int[] rv = new int[j - i + 1];
        System.arraycopy(csetRange, i, rv, 0, rv.length);
        return rv;
    }

    public void execute(final HgChangesetTreeHandler handler) throws HgCallbackTargetException, HgException, CancelledException {
        int lastCset;
        if (handler == null) {
            throw new IllegalArgumentException();
        }
        if (this.csetTransform != null) {
            throw new ConcurrentModificationException();
        }
        if (this.file == null) {
            throw new IllegalArgumentException("History tree is supported for files only (at least now), please specify file");
        }
        int firstCset = this.startRev;
        int n = lastCset = this.endRev == -3 ? this.repo.getChangelog().getLastRevision() : this.endRev;
        if (lastCset < 0 || lastCset > this.repo.getChangelog().getLastRevision()) {
            throw new HgBadArgumentException(String.format("Bad value %d for end revision", lastCset), null);
        }
        if (firstCset < 0 || this.startRev > lastCset) {
            throw new HgBadArgumentException(String.format("Bad value %d for start revision for range [%1$d..%d]", this.startRev, lastCset), null);
        }
        ProgressSupport progressHelper = this.getProgressSupport(handler);
        final CancelSupport cancelHelper = this.getCancelSupport(handler, true);
        HgFileRenameHandlerMixin renameHandler = Adaptable.Factory.getAdapter(handler, HgFileRenameHandlerMixin.class, null);
        try {
            HandlerDispatcher dispatcher = new HandlerDispatcher(this){

                @Override
                protected void once(HistoryNode n) throws HgCallbackTargetException, CancelledException, HgRuntimeException {
                    handler.treeElement(this.ei.init(n, this.currentFileNode));
                    cancelHelper.checkCancelled();
                }
            };
            FileRenameQueueBuilder frqBuilder = new FileRenameQueueBuilder();
            List<QueueElement> fileRenamesQueue = frqBuilder.buildFileRenamesQueue(firstCset, lastCset);
            progressHelper.start(4 * fileRenamesQueue.size());
            int namesIndex = 0;
            int renamesQueueSize = fileRenamesQueue.size();
            while (namesIndex < renamesQueueSize) {
                QueueElement renameInfo = fileRenamesQueue.get(namesIndex);
                dispatcher.prepare(progressHelper, renameInfo);
                cancelHelper.checkCancelled();
                if (namesIndex > 0) {
                    dispatcher.connectWithLastJunctionPoint(renameInfo, fileRenamesQueue.get(namesIndex - 1));
                }
                if (namesIndex + 1 < renamesQueueSize) {
                    dispatcher.updateJunctionPoint(renameInfo, fileRenamesQueue.get(namesIndex + 1), renameHandler != null);
                } else {
                    dispatcher.clearJunctionPoint();
                }
                dispatcher.dispatchAllChanges();
                if (renameHandler != null && namesIndex + 1 < renamesQueueSize) {
                    dispatcher.reportRenames(renameHandler);
                }
                ++namesIndex;
            }
            frqBuilder.reportRenameIfNotInQueue(fileRenamesQueue, renameHandler);
        }
        catch (HgRuntimeException ex) {
            throw new HgLibraryFailureException(ex);
        }
        progressHelper.done();
    }

    private HgParentChildMap<HgChangelog> getParentHelper(boolean create) throws HgRuntimeException {
        if (this.parentHelper == null && create) {
            this.parentHelper = new HgParentChildMap<HgChangelog>(this.repo.getChangelog());
            this.parentHelper.init();
        }
        return this.parentHelper;
    }

    static /* synthetic */ Calendar access$11(HgLogCommand hgLogCommand) {
        return hgLogCommand.date;
    }

    private static class BatchChangesetInspector
    extends AdapterPlug
    implements HgChangelog.Inspector {
        private final ArrayList<BatchRecord> batch;

        public BatchChangesetInspector(int batchSizeHint) {
            this.batch = new ArrayList(batchSizeHint);
        }

        public BatchChangesetInspector reset() {
            this.batch.clear();
            return this;
        }

        @Override
        public void next(int revisionIndex, Nodeid nodeid, HgChangelog.RawChangeset cset) {
            this.batch.add(new BatchRecord(revisionIndex, nodeid, cset.clone()));
        }

        public Iterable<BatchRecord> iterate(boolean reverse) {
            return reverse ? ReverseIterator.reversed(this.batch) : this.batch;
        }

        private static class BatchRecord {
            public final int csetIndex;
            public final Nodeid csetRevision;
            public final HgChangelog.RawChangeset cset;

            public BatchRecord(int index, Nodeid nodeid, HgChangelog.RawChangeset changeset) {
                this.csetIndex = index;
                this.csetRevision = nodeid;
                this.cset = changeset;
            }
        }
    }

    public static class CollectHandler
    implements HgChangesetHandler {
        private final List<HgChangeset> result = new LinkedList<HgChangeset>();

        public List<HgChangeset> getChanges() {
            return Collections.unmodifiableList(this.result);
        }

        @Override
        public void cset(HgChangeset changeset) {
            this.result.add(changeset.clone());
        }
    }

    private class ElementImpl
    implements HgChangesetTreeHandler.TreeElement,
    HgChangelog.Inspector {
        private HistoryNode historyNode;
        private HgDataFile fileNode;
        private Pair<HgChangeset, HgChangeset> parents;
        private List<HgChangeset> children;
        private IntMap<HgChangeset> cachedChangesets;
        private ChangesetTransformer.Transformation transform;
        private Nodeid changesetRevision;
        private Pair<Nodeid, Nodeid> parentRevisions;
        private List<Nodeid> childRevisions;

        public ElementImpl(int total) {
            this.cachedChangesets = new IntMap(total);
        }

        ElementImpl init(HistoryNode n, HgDataFile df) {
            this.historyNode = n;
            this.fileNode = df;
            this.parents = null;
            this.children = null;
            this.changesetRevision = null;
            this.parentRevisions = null;
            this.childRevisions = null;
            return this;
        }

        @Override
        public Nodeid fileRevision() {
            return this.historyNode.fileRevision;
        }

        @Override
        public HgDataFile file() {
            return this.fileNode;
        }

        @Override
        public HgChangeset changeset() throws HgRuntimeException {
            return this.get(this.historyNode.changeset)[0];
        }

        @Override
        public Pair<HgChangeset, HgChangeset> parents() throws HgRuntimeException {
            if (this.parents != null) {
                return this.parents;
            }
            HistoryNode p = this.historyNode.parent1;
            int p1 = p != null ? p.changeset : -1;
            p = this.historyNode.parent2;
            int p2 = p != null ? p.changeset : -1;
            HgChangeset[] r = this.get(p1, p2);
            this.parents = new Pair<HgChangeset, HgChangeset>(r[0], r[1]);
            return this.parents;
        }

        @Override
        public Collection<HgChangeset> children() throws HgRuntimeException {
            if (this.children != null) {
                return this.children;
            }
            if (this.historyNode.children == null) {
                this.children = Collections.emptyList();
            } else {
                int[] childrentChangesetNumbers = new int[this.historyNode.children.size()];
                int j = 0;
                for (HistoryNode hn : this.historyNode.children) {
                    childrentChangesetNumbers[j++] = hn.changeset;
                }
                this.children = Arrays.asList(this.get(childrentChangesetNumbers));
            }
            return this.children;
        }

        void populate(HgChangeset cs) {
            this.cachedChangesets.put(cs.getRevisionIndex(), cs);
        }

        private HgChangeset[] get(int ... changelogRevisionIndex) throws HgRuntimeException {
            HgChangeset[] rv = new HgChangeset[changelogRevisionIndex.length];
            IntVector misses = new IntVector(changelogRevisionIndex.length, -1);
            int i = 0;
            while (i < changelogRevisionIndex.length) {
                if (changelogRevisionIndex[i] == -1) {
                    rv[i] = null;
                } else {
                    HgChangeset cached = this.cachedChangesets.get(changelogRevisionIndex[i]);
                    if (cached != null) {
                        rv[i] = cached;
                    } else {
                        misses.add(changelogRevisionIndex[i]);
                    }
                }
                ++i;
            }
            if (misses.size() > 0) {
                int[] changesets2read = misses.toArray();
                this.initTransform();
                HgLogCommand.this.repo.getChangelog().range(this, changesets2read);
                int[] nArray = changesets2read;
                int n = changesets2read.length;
                int n2 = 0;
                while (n2 < n) {
                    int changeset2read = nArray[n2];
                    HgChangeset cs = this.cachedChangesets.get(changeset2read);
                    if (cs == null) {
                        throw new HgInvalidStateException(String.format("Can't get changeset for revision %d", changeset2read));
                    }
                    boolean sanity = false;
                    int i2 = 0;
                    while (i2 < changelogRevisionIndex.length) {
                        if (changelogRevisionIndex[i2] == cs.getRevisionIndex()) {
                            rv[i2] = cs;
                            sanity = true;
                            break;
                        }
                        ++i2;
                    }
                    if (!sanity) {
                        HgLogCommand.this.repo.getSessionContext().getLog().dump(this.getClass(), LogFacility.Severity.Error, "Index of revision %d:%s doesn't match any of requested", cs.getRevisionIndex(), cs.getNodeid().shortNotation());
                    }
                    assert (sanity);
                    ++n2;
                }
            }
            return rv;
        }

        void initTransform() throws HgRuntimeException {
            if (this.transform == null) {
                this.transform = new ChangesetTransformer.Transformation(new HgStatusCollector(HgLogCommand.this.repo), HgLogCommand.this.getParentHelper(false));
            }
        }

        @Override
        public void next(int revisionNumber, Nodeid nodeid, HgChangelog.RawChangeset cset) {
            HgChangeset cs = this.transform.handle(revisionNumber, nodeid, cset);
            this.populate(cs.clone());
        }

        @Override
        public Nodeid changesetRevision() throws HgRuntimeException {
            if (this.changesetRevision == null) {
                this.changesetRevision = this.getRevision(this.historyNode.changeset);
            }
            return this.changesetRevision;
        }

        @Override
        public Pair<Nodeid, Nodeid> parentRevisions() throws HgRuntimeException {
            if (this.parentRevisions == null) {
                HistoryNode p = this.historyNode.parent1;
                Nodeid p1 = p != null ? this.getRevision(p.changeset) : Nodeid.NULL;
                p = this.historyNode.parent2;
                Nodeid p2 = p != null ? this.getRevision(p.changeset) : Nodeid.NULL;
                this.parentRevisions = new Pair<Nodeid, Nodeid>(p1, p2);
            }
            return this.parentRevisions;
        }

        @Override
        public Collection<Nodeid> childRevisions() throws HgRuntimeException {
            if (this.childRevisions != null) {
                return this.childRevisions;
            }
            if (this.historyNode.children == null) {
                this.childRevisions = Collections.emptyList();
            } else {
                ArrayList<Nodeid> rv = new ArrayList<Nodeid>(this.historyNode.children.size());
                for (HistoryNode hn : this.historyNode.children) {
                    rv.add(this.getRevision(hn.changeset));
                }
                this.childRevisions = Collections.unmodifiableList(rv);
            }
            return this.childRevisions;
        }

        private Nodeid getRevision(int changelogRevisionNumber) throws HgRuntimeException {
            HgChangeset cs = this.cachedChangesets.get(changelogRevisionNumber);
            if (cs != null) {
                return cs.getNodeid();
            }
            return HgLogCommand.this.repo.getChangelog().getRevision(changelogRevisionNumber);
        }
    }

    private class FileRenameQueueBuilder {
        private FileRenameQueueBuilder() {
        }

        public List<QueueElement> buildFileRenamesQueue(int csetStart, int csetEnd) throws HgPathNotFoundException, HgRuntimeException {
            Nodeid wdParentChangeset;
            LinkedList<QueueElement> rv = new LinkedList<QueueElement>();
            Nodeid startRev = null;
            HgDataFile fileNode = HgLogCommand.this.repo.getFileNode(HgLogCommand.this.file);
            if (!fileNode.exists()) {
                throw new HgPathNotFoundException(String.format("File %s not found in the repository", HgLogCommand.this.file), HgLogCommand.this.file);
            }
            if (HgLogCommand.this.followAncestry && !(wdParentChangeset = HgLogCommand.this.repo.getWorkingCopyParents().first()).isNull()) {
                int wdParentRevIndex = HgLogCommand.this.repo.getChangelog().getRevisionIndex(wdParentChangeset);
                startRev = HgLogCommand.this.repo.getManifest().getFileRevision(wdParentRevIndex, fileNode.getPath());
            }
            QueueElement p = new QueueElement(fileNode, startRev);
            if (!HgLogCommand.this.followRenames) {
                rv.add(p);
                return rv;
            }
            FileRenameHistory frh = new FileRenameHistory(csetStart, csetEnd);
            frh.build(fileNode, p.fileTo());
            for (FileRenameHistory.Chunk c : frh.iterate(HgLogCommand.this.iterateDirection)) {
                rv.add(new QueueElement(c.file(), c.firstFileRev(), c.lastFileRev()));
            }
            return rv;
        }

        public void reportRenameIfNotInQueue(List<QueueElement> queue, HgFileRenameHandlerMixin renameHandler) throws HgCallbackTargetException, HgRuntimeException {
            if (renameHandler != null && !HgLogCommand.this.followRenames) {
                assert (queue.size() == 1);
                QueueElement curRename = queue.get(0);
                if (curRename.file().isCopy(curRename.fileFrom())) {
                    HgFileRevision src = curRename.file().getCopySource(curRename.fileFrom());
                    HgFileRevision dst = curRename.first(src);
                    renameHandler.copy(src, dst);
                }
            }
        }
    }

    private class FilteringInspector
    extends AdapterPlug
    implements HgChangelog.Inspector,
    Adaptable {
        private int firstCset = Integer.MIN_VALUE;
        private int lastCset = Integer.MIN_VALUE;
        private HgChangelog.Inspector delegate;
        private LifecycleProxy lifecycleProxy;

        private FilteringInspector() {
        }

        public void changesets(int start, int end) {
            this.firstCset = start;
            this.lastCset = end;
        }

        public void delegateTo(HgChangelog.Inspector inspector) {
            this.delegate = inspector;
            if (this.lifecycleProxy == null) {
                this.lifecycleProxy = new LifecycleProxy(inspector);
                super.attachAdapter(Lifecycle.class, this.lifecycleProxy);
            } else {
                this.lifecycleProxy.init(inspector);
            }
        }

        @Override
        public void next(int revisionNumber, Nodeid nodeid, HgChangelog.RawChangeset cset) throws HgRuntimeException {
            if (HgLogCommand.this.limit > 0 && HgLogCommand.this.count >= HgLogCommand.this.limit) {
                return;
            }
            if (this.firstCset != Integer.MIN_VALUE && revisionNumber < this.firstCset) {
                return;
            }
            if (this.lastCset != Integer.MIN_VALUE && revisionNumber > this.lastCset) {
                return;
            }
            if (HgLogCommand.this.branches != null && !HgLogCommand.this.branches.contains(cset.branch())) {
                return;
            }
            if (HgLogCommand.this.users != null) {
                String csetUser = cset.user().toLowerCase();
                boolean found = false;
                for (String u : HgLogCommand.this.users) {
                    if (csetUser.indexOf(u) == -1) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return;
                }
            }
            this.delegate.next(revisionNumber, nodeid, cset);
            HgLogCommand hgLogCommand = HgLogCommand.this;
            hgLogCommand.count = hgLogCommand.count + 1;
            if (HgLogCommand.this.limit > 0 && HgLogCommand.this.count >= HgLogCommand.this.limit) {
                this.lifecycleProxy.stop();
            }
        }
    }

    private abstract class HandlerDispatcher {
        private final int CACHE_CSET_IN_ADVANCE_THRESHOLD = 100;
        private final TreeBuildInspector treeBuildInspector;
        private List<HistoryNode> changeHistory;
        protected ElementImpl ei;
        private ProgressSupport progress;
        protected HgDataFile currentFileNode;
        private HistoryNode junctionNode;
        private HgFileRevision copiedFrom;
        private HgFileRevision copiedTo;

        private HandlerDispatcher() {
            this.treeBuildInspector = new TreeBuildInspector(HgLogCommand.this.followAncestry);
            this.ei = null;
        }

        public void prepare(ProgressSupport parentProgress, QueueElement renameInfo) throws HgRuntimeException {
            this.changeHistory = this.treeBuildInspector.go(renameInfo);
            assert (this.changeHistory.size() > 0);
            parentProgress.worked(1);
            int historyNodeCount = this.changeHistory.size();
            if (this.ei == null) {
                this.ei = new ElementImpl(Math.max(100, historyNodeCount));
            }
            if (historyNodeCount < 100) {
                int[] commitRevisions = this.treeBuildInspector.getCommitRevisions();
                assert (commitRevisions.length == this.changeHistory.size());
                this.ei.initTransform();
                HgLogCommand.this.repo.getChangelog().range(this.ei, commitRevisions);
                parentProgress.worked(1);
                this.progress = new ProgressSupport.Sub(parentProgress, 2);
            } else {
                this.progress = new ProgressSupport.Sub(parentProgress, 3);
            }
            this.progress.start(historyNodeCount);
            this.switchTo(renameInfo.file());
        }

        public void updateJunctionPoint(QueueElement curRename, QueueElement nextRename, boolean needCopyFromTo) throws HgRuntimeException {
            this.copiedTo = null;
            this.copiedFrom = null;
            if (HgLogCommand.this.iterateDirection == HgIterateDirection.OldToNew) {
                HistoryNode junctionSrc = this.findJunctionPointInCurrentChunk(curRename.lastFileRev());
                HistoryNode junctionDestMock = this.treeBuildInspector.one(nextRename.file(), 0);
                junctionSrc.bindChild(junctionDestMock);
                this.junctionNode = new HistoryNode(junctionSrc.changeset, junctionSrc.fileRevision, null, null);
                if (needCopyFromTo) {
                    this.copiedFrom = new HgFileRevision(curRename.file(), this.junctionNode.fileRevision, null);
                    this.copiedTo = new HgFileRevision(nextRename.file(), junctionDestMock.fileRevision, this.copiedFrom.getPath());
                }
            } else {
                assert (HgLogCommand.this.iterateDirection == HgIterateDirection.NewToOld);
                HistoryNode junctionDest = this.changeHistory.get(0);
                HistoryNode junctionSrcMock = this.treeBuildInspector.one(nextRename.file(), nextRename.lastFileRev());
                junctionSrcMock.bindChild(junctionDest);
                this.junctionNode = new HistoryNode(junctionDest.changeset, junctionDest.fileRevision, null, null);
                if (needCopyFromTo) {
                    this.copiedFrom = new HgFileRevision(nextRename.file(), junctionSrcMock.fileRevision, null);
                    this.copiedTo = new HgFileRevision(curRename.file(), this.junctionNode.fileRevision, this.copiedFrom.getPath());
                }
            }
        }

        public void reportRenames(HgFileRenameHandlerMixin renameHandler) throws HgCallbackTargetException, HgRuntimeException {
            if (renameHandler != null) {
                assert (this.copiedFrom != null);
                assert (this.copiedTo != null);
                renameHandler.copy(this.copiedFrom, this.copiedTo);
            }
        }

        public void clearJunctionPoint() {
            this.junctionNode = null;
            this.copiedTo = null;
            this.copiedFrom = null;
        }

        public void connectWithLastJunctionPoint(QueueElement curRename, QueueElement prevRename) {
            assert (this.junctionNode != null);
            if (HgLogCommand.this.iterateDirection == HgIterateDirection.OldToNew) {
                HistoryNode junctionDest = this.changeHistory.get(0);
                this.junctionNode.bindChild(junctionDest);
            } else {
                assert (HgLogCommand.this.iterateDirection == HgIterateDirection.NewToOld);
                HistoryNode junctionSrc = this.findJunctionPointInCurrentChunk(curRename.lastFileRev());
                junctionSrc.bindChild(this.junctionNode);
            }
        }

        private HistoryNode findJunctionPointInCurrentChunk(Nodeid fileRevision) {
            if (HgLogCommand.this.followAncestry) {
                HistoryNode rv = this.changeHistory.get(this.changeHistory.size() - 1);
                assert (rv.fileRevision.equals(fileRevision));
                return rv;
            }
            for (HistoryNode n : this.changeHistory) {
                if (!n.fileRevision.equals(fileRevision)) continue;
                return n;
            }
            int csetStart = this.changeHistory.get((int)0).changeset;
            int csetEnd = this.changeHistory.get((int)(this.changeHistory.size() - 1)).changeset;
            throw new HgInvalidStateException(String.format("For change history (cset[%d..%d]) could not find node for file change %s", csetStart, csetEnd, fileRevision.shortNotation()));
        }

        protected abstract void once(HistoryNode var1) throws HgCallbackTargetException, CancelledException, HgRuntimeException;

        public void dispatchAllChanges() throws HgCallbackTargetException, CancelledException, HgRuntimeException {
            Iterator<HistoryNode> it;
            if (HgLogCommand.this.iterateDirection == HgIterateDirection.OldToNew) {
                it = this.changeHistory.listIterator();
            } else {
                assert (HgLogCommand.this.iterateDirection == HgIterateDirection.NewToOld);
                it = new ReverseIterator<HistoryNode>(this.changeHistory);
            }
            while (it.hasNext()) {
                HistoryNode n = it.next();
                this.once(n);
                this.progress.worked(1);
            }
            this.changeHistory = null;
        }

        public void switchTo(HgDataFile df) {
            this.currentFileNode = df;
        }
    }

    private static class HistoryNode {
        final int changeset;
        final Nodeid fileRevision;
        HistoryNode parent1;
        final HistoryNode parent2;
        List<HistoryNode> children;

        HistoryNode(int cs, Nodeid revision, HistoryNode p1, HistoryNode p2) {
            this.changeset = cs;
            this.fileRevision = revision;
            this.parent1 = p1;
            this.parent2 = p2;
            if (p1 != null) {
                p1.addChild(this);
            }
            if (p2 != null) {
                p2.addChild(this);
            }
        }

        private void addChild(HistoryNode child) {
            if (this.children == null) {
                this.children = new ArrayList<HistoryNode>(2);
            }
            this.children.add(child);
        }

        public void bindChild(HistoryNode child) {
            assert (child.parent1 == null && child.parent2 == null);
            child.parent1 = this;
            this.addChild(child);
        }

        public String toString() {
            return String.format("<cset:%d, parents: %s, %s>", this.changeset, this.parent1 == null ? "-" : String.valueOf(this.parent1.changeset), this.parent2 == null ? "-" : String.valueOf(this.parent2.changeset));
        }
    }

    private static class QueueElement {
        private final HgDataFile df;
        private final Nodeid lastRev;
        private final int firstRevIndex;
        private final int lastRevIndex;

        QueueElement(HgDataFile file, Nodeid fileLastRev) {
            this.df = file;
            this.lastRev = fileLastRev;
            this.firstRevIndex = 0;
            this.lastRevIndex = this.lastRev == null ? this.df.getLastRevision() : this.df.getRevisionIndex(this.lastRev);
        }

        QueueElement(HgDataFile file, int firstFileRev, int lastFileRev) {
            this.df = file;
            this.firstRevIndex = firstFileRev;
            this.lastRevIndex = lastFileRev;
            this.lastRev = null;
        }

        HgDataFile file() {
            return this.df;
        }

        int fileFrom() {
            return this.firstRevIndex;
        }

        int fileTo() {
            return this.lastRevIndex;
        }

        Nodeid lastFileRev() {
            return this.lastRev == null ? this.df.getRevision(this.fileTo()) : this.lastRev;
        }

        HgFileRevision last() {
            return new HgFileRevision(this.df, this.lastFileRev(), null);
        }

        HgFileRevision first(HgFileRevision from) {
            return new HgFileRevision(this.df, this.df.getRevision(0), from.getPath());
        }
    }

    private static class TreeBuildInspector
    implements Revlog.ParentInspector,
    Revlog.RevisionInspector {
        private final boolean followAncestry;
        private HistoryNode[] completeHistory;
        private int[] commitRevisions;
        private List<HistoryNode> resultHistory;

        TreeBuildInspector(boolean _followAncestry) {
            this.followAncestry = _followAncestry;
        }

        @Override
        public void next(int revisionNumber, Nodeid revision, int linkedRevision) {
            this.commitRevisions[revisionNumber] = linkedRevision;
        }

        @Override
        public void next(int revisionNumber, Nodeid revision, int parent1, int parent2, Nodeid nidParent1, Nodeid nidParent2) {
            HistoryNode p1 = null;
            HistoryNode p2 = null;
            if (parent1 != -1) {
                p1 = this.completeHistory[parent1];
            }
            if (parent2 != -1) {
                p2 = this.completeHistory[parent2];
            }
            this.completeHistory[revisionNumber] = new HistoryNode(this.commitRevisions[revisionNumber], revision, p1, p2);
        }

        HistoryNode one(HgDataFile fileNode, Nodeid fileRevision) throws HgRuntimeException {
            int fileRevIndexToVisit = fileNode.getRevisionIndex(fileRevision);
            return this.one(fileNode, fileRevIndexToVisit);
        }

        HistoryNode one(HgDataFile fileNode, int fileRevIndexToVisit) throws HgRuntimeException {
            this.resultHistory = null;
            if (fileRevIndexToVisit == -3) {
                fileRevIndexToVisit = fileNode.getLastRevision();
            }
            this.completeHistory = new HistoryNode[fileRevIndexToVisit + 1];
            this.commitRevisions = new int[this.completeHistory.length];
            fileNode.indexWalk(fileRevIndexToVisit, fileRevIndexToVisit, this);
            HistoryNode rv = this.completeHistory[fileRevIndexToVisit];
            this.commitRevisions = new int[]{this.commitRevisions[fileRevIndexToVisit]};
            this.completeHistory = null;
            this.resultHistory = Collections.singletonList(rv);
            return rv;
        }

        List<HistoryNode> go(QueueElement qe) throws HgRuntimeException {
            this.resultHistory = null;
            HgDataFile fileNode = qe.file();
            int fileLastRevIndexToVisit = this.followAncestry ? fileNode.getRevisionIndex(qe.lastFileRev()) : fileNode.getLastRevision();
            this.completeHistory = new HistoryNode[fileLastRevIndexToVisit + 1];
            this.commitRevisions = new int[this.completeHistory.length];
            fileNode.indexWalk(qe.fileFrom(), fileLastRevIndexToVisit, this);
            if (!this.followAncestry) {
                this.resultHistory = new ArrayList<HistoryNode>(fileLastRevIndexToVisit - qe.fileFrom() + 1);
                int i = qe.fileFrom();
                while (i <= fileLastRevIndexToVisit) {
                    this.resultHistory.add(this.completeHistory[i]);
                    ++i;
                }
                this.completeHistory = null;
                this.commitRevisions = null;
                return this.resultHistory;
            }
            LinkedList<HistoryNode> strippedHistoryList = new LinkedList<HistoryNode>();
            LinkedList<HistoryNode> queue = new LinkedList<HistoryNode>();
            queue.add(this.completeHistory[fileLastRevIndexToVisit]);
            do {
                HistoryNode withFileChange;
                if (strippedHistoryList.contains(withFileChange = (HistoryNode)queue.removeFirst())) continue;
                if (withFileChange.children != null) {
                    withFileChange.children.retainAll(strippedHistoryList);
                }
                strippedHistoryList.addFirst(withFileChange);
                if (withFileChange.parent1 != null) {
                    queue.addLast(withFileChange.parent1);
                }
                if (withFileChange.parent2 == null) continue;
                queue.addLast(withFileChange.parent2);
            } while (!queue.isEmpty());
            Collections.sort(strippedHistoryList, new Comparator<HistoryNode>(){

                @Override
                public int compare(HistoryNode o1, HistoryNode o2) {
                    return o1.changeset - o2.changeset;
                }
            });
            this.completeHistory = null;
            this.commitRevisions = null;
            this.resultHistory = strippedHistoryList;
            return this.resultHistory;
        }

        int[] getCommitRevisions() {
            if (this.commitRevisions == null) {
                this.commitRevisions = new int[this.resultHistory.size()];
                int i = 0;
                for (HistoryNode n : this.resultHistory) {
                    this.commitRevisions[i++] = n.changeset;
                }
            }
            return this.commitRevisions;
        }
    }
}

