/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.core;

import java.util.ConcurrentModificationException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.hg.core.HgAbstractCommand;
import org.tmatesoft.hg.core.HgBadArgumentException;
import org.tmatesoft.hg.core.HgCallbackTargetException;
import org.tmatesoft.hg.core.HgException;
import org.tmatesoft.hg.core.HgFileRevision;
import org.tmatesoft.hg.core.HgLibraryFailureException;
import org.tmatesoft.hg.core.HgManifestHandler;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.CsetParamKeeper;
import org.tmatesoft.hg.internal.PathPool;
import org.tmatesoft.hg.repo.HgManifest;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.CancelSupport;
import org.tmatesoft.hg.util.CancelledException;
import org.tmatesoft.hg.util.Path;
import org.tmatesoft.hg.util.PathRewrite;

public class HgManifestCommand
extends HgAbstractCommand<HgManifestCommand> {
    private final HgRepository repo;
    private Path.Matcher matcher;
    private int startRev = 0;
    private int endRev = -3;
    private HgManifestHandler visitor;
    private boolean needDirs = false;
    private final Mediator mediator = new Mediator();

    public HgManifestCommand(HgRepository hgRepo) {
        this.repo = hgRepo;
    }

    public HgManifestCommand range(int rev1, int rev2) {
        boolean badArgs = rev1 == Integer.MIN_VALUE || rev2 == Integer.MIN_VALUE || rev1 == -2 || rev2 == -2;
        badArgs |= rev2 != -3 && rev2 < rev1;
        if (badArgs |= rev1 == -3 && rev2 != -3) {
            throw new IllegalArgumentException(String.format("Bad range: [%d, %d]", rev1, rev2));
        }
        this.startRev = rev1;
        this.endRev = rev2;
        return this;
    }

    public HgManifestCommand range(Nodeid cset1, Nodeid cset2) throws HgBadArgumentException {
        CsetParamKeeper pk = new CsetParamKeeper(this.repo);
        int r1 = pk.set(cset1).get();
        int r2 = pk.set(cset2).get();
        return this.range(r1, r2);
    }

    public HgManifestCommand changeset(int csetRevisionIndex) {
        return this.range(csetRevisionIndex, csetRevisionIndex);
    }

    public HgManifestCommand changeset(Nodeid nid) throws HgBadArgumentException {
        int csetRevIndex = new CsetParamKeeper(this.repo).set(nid).get();
        return this.range(csetRevIndex, csetRevIndex);
    }

    public HgManifestCommand dirs(boolean include) {
        this.needDirs = include;
        return this;
    }

    public HgManifestCommand match(Path.Matcher pathMatcher) {
        this.matcher = pathMatcher;
        return this;
    }

    public void execute(HgManifestHandler handler) throws HgCallbackTargetException, HgException, CancelledException {
        if (handler == null) {
            throw new IllegalArgumentException();
        }
        if (this.visitor != null) {
            throw new ConcurrentModificationException();
        }
        try {
            try {
                this.visitor = handler;
                this.mediator.start(this.getCancelSupport(handler, true));
                this.repo.getManifest().walk(this.startRev, this.endRev, this.mediator);
                this.mediator.checkFailure();
            }
            catch (HgRuntimeException ex) {
                throw new HgLibraryFailureException(ex);
            }
        }
        finally {
            this.mediator.done();
            this.visitor = null;
        }
    }

    private class Mediator
    implements HgManifest.Inspector {
        private PathPool pathPool;
        private List<HgFileRevision> manifestContent;
        private Nodeid manifestNodeid;
        private Exception failure;
        private CancelSupport cancelHelper;

        private Mediator() {
        }

        public void start(CancelSupport cs) {
            assert (cs != null);
            this.pathPool = new PathPool(new PathRewrite.Empty());
            this.cancelHelper = cs;
        }

        public void done() {
            this.manifestContent = null;
            this.pathPool = null;
        }

        private void recordFailure(HgCallbackTargetException ex) {
            this.failure = ex;
        }

        private void recordCancel(CancelledException ex) {
            this.failure = ex;
        }

        public void checkFailure() throws HgCallbackTargetException, CancelledException {
            if (this.failure instanceof HgCallbackTargetException) {
                HgCallbackTargetException ex = (HgCallbackTargetException)this.failure;
                this.failure = null;
                throw ex;
            }
            if (this.failure instanceof CancelledException) {
                CancelledException ex = (CancelledException)this.failure;
                this.failure = null;
                throw ex;
            }
        }

        @Override
        public boolean begin(int manifestRevision, Nodeid nid, int changelogRevision) throws HgRuntimeException {
            if (HgManifestCommand.this.needDirs && this.manifestContent == null) {
                this.manifestContent = new LinkedList<HgFileRevision>();
            }
            try {
                this.manifestNodeid = nid;
                HgManifestCommand.this.visitor.begin(this.manifestNodeid);
                this.cancelHelper.checkCancelled();
                return true;
            }
            catch (HgCallbackTargetException ex) {
                this.recordFailure(ex);
                return false;
            }
            catch (CancelledException ex) {
                this.recordCancel(ex);
                return false;
            }
        }

        @Override
        public boolean end(int revision) throws HgRuntimeException {
            try {
                if (HgManifestCommand.this.needDirs) {
                    LinkedHashMap<Path, LinkedList<HgFileRevision>> breakDown = new LinkedHashMap<Path, LinkedList<HgFileRevision>>();
                    for (HgFileRevision fr : this.manifestContent) {
                        Path filePath = fr.getPath();
                        Path dirPath = this.pathPool.parent(filePath);
                        LinkedList<HgFileRevision> revs = (LinkedList<HgFileRevision>)breakDown.get(dirPath);
                        if (revs == null) {
                            revs = new LinkedList<HgFileRevision>();
                            breakDown.put(dirPath, revs);
                        }
                        revs.addLast(fr);
                    }
                    for (Path dir : breakDown.keySet()) {
                        HgManifestCommand.this.visitor.dir(dir);
                        this.cancelHelper.checkCancelled();
                        for (HgFileRevision fr : (LinkedList)breakDown.get(dir)) {
                            HgManifestCommand.this.visitor.file(fr);
                        }
                    }
                    this.manifestContent.clear();
                }
                HgManifestCommand.this.visitor.end(this.manifestNodeid);
                this.cancelHelper.checkCancelled();
                return true;
            }
            catch (HgCallbackTargetException ex) {
                this.recordFailure(ex);
                return false;
            }
            catch (CancelledException ex) {
                this.recordCancel(ex);
                return false;
            }
            finally {
                this.manifestNodeid = null;
            }
        }

        @Override
        public boolean next(Nodeid nid, Path fname, HgManifest.Flags flags) throws HgRuntimeException {
            if (HgManifestCommand.this.matcher != null && !HgManifestCommand.this.matcher.accept(fname)) {
                return true;
            }
            try {
                HgFileRevision fr = new HgFileRevision(HgManifestCommand.this.repo, nid, flags, fname);
                if (HgManifestCommand.this.needDirs) {
                    this.manifestContent.add(fr);
                } else {
                    HgManifestCommand.this.visitor.file(fr);
                }
                return true;
            }
            catch (HgCallbackTargetException ex) {
                this.recordFailure(ex);
                return false;
            }
        }
    }
}

