/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.core;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.tmatesoft.hg.core.ChangesetTransformer;
import org.tmatesoft.hg.core.HgAbstractCommand;
import org.tmatesoft.hg.core.HgCallbackTargetException;
import org.tmatesoft.hg.core.HgChangesetHandler;
import org.tmatesoft.hg.core.HgException;
import org.tmatesoft.hg.core.HgLibraryFailureException;
import org.tmatesoft.hg.core.HgRemoteConnectionException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.internal.PhasesHelper;
import org.tmatesoft.hg.internal.RepositoryComparator;
import org.tmatesoft.hg.internal.RevisionSet;
import org.tmatesoft.hg.repo.HgChangelog;
import org.tmatesoft.hg.repo.HgParentChildMap;
import org.tmatesoft.hg.repo.HgRemoteRepository;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.CancelSupport;
import org.tmatesoft.hg.util.CancelledException;
import org.tmatesoft.hg.util.ProgressSupport;

public class HgOutgoingCommand
extends HgAbstractCommand<HgOutgoingCommand> {
    private final HgRepository localRepo;
    private HgRemoteRepository remoteRepo;
    private boolean includeSubrepo;
    private RepositoryComparator comparator;
    private HgParentChildMap<HgChangelog> parentHelper;
    private Set<String> branches;

    public HgOutgoingCommand(HgRepository hgRepo) {
        this.localRepo = hgRepo;
    }

    public HgOutgoingCommand against(HgRemoteRepository hgRemote) {
        this.remoteRepo = hgRemote;
        this.comparator = null;
        return this;
    }

    public HgOutgoingCommand branch(String branch) {
        if (branch == null) {
            throw new IllegalArgumentException();
        }
        if (this.branches == null) {
            this.branches = new TreeSet<String>();
        }
        this.branches.add(branch);
        return this;
    }

    public HgOutgoingCommand subrepo(boolean include) {
        this.includeSubrepo = include;
        throw Internals.notImplemented();
    }

    public List<Nodeid> executeLite() throws HgRemoteConnectionException, HgException, CancelledException {
        ProgressSupport ps = this.getProgressSupport(null);
        try {
            List<Nodeid> list = this.getOutgoingRevisions(ps, this.getCancelSupport(null, true));
            return list;
        }
        catch (HgRuntimeException ex) {
            throw new HgLibraryFailureException(ex);
        }
        finally {
            ps.done();
        }
    }

    public void executeFull(HgChangesetHandler handler) throws HgCallbackTargetException, HgException, CancelledException {
        if (handler == null) {
            throw new IllegalArgumentException("Delegate can't be null");
        }
        ProgressSupport ps = this.getProgressSupport(handler);
        CancelSupport cs = this.getCancelSupport(handler, true);
        try {
            try {
                ps.start(200);
                ChangesetTransformer inspector = new ChangesetTransformer(this.localRepo, handler, this.getParentHelper(), new ProgressSupport.Sub(ps, 100), cs);
                inspector.limitBranches(this.branches);
                List<Nodeid> out = this.getOutgoingRevisions(new ProgressSupport.Sub(ps, 100), cs);
                int[] outRevIndex = new int[out.size()];
                int i = 0;
                for (Nodeid o : out) {
                    outRevIndex[i++] = this.localRepo.getChangelog().getRevisionIndex(o);
                }
                this.localRepo.getChangelog().range(inspector, outRevIndex);
                inspector.checkFailure();
            }
            catch (HgRuntimeException ex) {
                throw new HgLibraryFailureException(ex);
            }
        }
        finally {
            ps.done();
        }
    }

    private RepositoryComparator getComparator(ProgressSupport ps, CancelSupport cs) throws HgRemoteConnectionException, CancelledException, HgRuntimeException {
        if (this.remoteRepo == null) {
            throw new IllegalArgumentException("Shall specify remote repository to compare against");
        }
        if (this.comparator == null) {
            this.comparator = new RepositoryComparator(this.getParentHelper(), this.remoteRepo);
            this.comparator.compare(ps, cs);
        }
        return this.comparator;
    }

    private HgParentChildMap<HgChangelog> getParentHelper() throws HgRuntimeException {
        if (this.parentHelper == null) {
            this.parentHelper = new HgParentChildMap<HgChangelog>(this.localRepo.getChangelog());
            this.parentHelper.init();
        }
        return this.parentHelper;
    }

    private List<Nodeid> getOutgoingRevisions(ProgressSupport ps, CancelSupport cs) throws HgRemoteConnectionException, HgException, CancelledException {
        ps.start(10);
        RepositoryComparator c = this.getComparator(new ProgressSupport.Sub(ps, 5), cs);
        List<Nodeid> local = c.getLocalOnlyRevisions();
        ps.worked(3);
        PhasesHelper phaseHelper = new PhasesHelper(Internals.getInstance(this.localRepo));
        if (phaseHelper.isCapableOfPhases() && phaseHelper.withSecretRoots()) {
            local = new RevisionSet(local).subtract(phaseHelper.allSecret()).asList();
        }
        ps.worked(2);
        return local;
    }
}

