/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.core;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.tmatesoft.hg.core.HgAbstractCommand;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.core.HgLibraryFailureException;
import org.tmatesoft.hg.core.HgRemoteConnectionException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.AddRevInspector;
import org.tmatesoft.hg.internal.COWTransaction;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.internal.PhasesHelper;
import org.tmatesoft.hg.internal.RepositoryComparator;
import org.tmatesoft.hg.internal.RevisionSet;
import org.tmatesoft.hg.internal.Transaction;
import org.tmatesoft.hg.repo.HgBundle;
import org.tmatesoft.hg.repo.HgChangelog;
import org.tmatesoft.hg.repo.HgInternals;
import org.tmatesoft.hg.repo.HgParentChildMap;
import org.tmatesoft.hg.repo.HgRemoteRepository;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.CancelledException;
import org.tmatesoft.hg.util.ProgressSupport;

public class HgPullCommand
extends HgAbstractCommand<HgPullCommand> {
    private final HgRepository repo;
    private HgRemoteRepository remote;
    private RevisionSet added;

    public HgPullCommand(HgRepository hgRepo) {
        this.repo = hgRepo;
    }

    public HgPullCommand source(HgRemoteRepository hgRemote) {
        this.remote = hgRemote;
        return this;
    }

    public void execute() throws HgRemoteConnectionException, HgIOException, HgLibraryFailureException, CancelledException {
        ProgressSupport progress = this.getProgressSupport(null);
        try {
            try {
                PhasesHelper phaseHelper;
                AddRevInspector insp;
                progress.start(100);
                HgChangelog clog = this.repo.getChangelog();
                HgParentChildMap<HgChangelog> parentHelper = new HgParentChildMap<HgChangelog>(clog);
                parentHelper.init();
                RepositoryComparator comparator = new RepositoryComparator(parentHelper, this.remote);
                comparator.compare(new ProgressSupport.Sub(progress, 50), this.getCancelSupport(null, true));
                List<Nodeid> common = comparator.getCommon();
                HgBundle incoming = this.remote.getChanges(common);
                Internals implRepo = HgInternals.getImplementationRepo(this.repo);
                COWTransaction.Factory trFactory = new COWTransaction.Factory();
                Transaction tr = trFactory.create(this.repo);
                try {
                    insp = new AddRevInspector(implRepo, tr);
                    incoming.inspectAll(insp);
                    insp.done();
                    tr.commit();
                }
                catch (HgRuntimeException ex) {
                    tr.rollback();
                    throw ex;
                }
                catch (HgIOException ex) {
                    tr.rollback();
                    throw ex;
                }
                catch (RuntimeException ex) {
                    tr.rollback();
                    throw ex;
                }
                progress.worked(45);
                this.added = insp.addedChangesets();
                if (!this.added.isEmpty()) {
                    parentHelper.init();
                }
                if ((phaseHelper = new PhasesHelper(implRepo, parentHelper)).isCapableOfPhases()) {
                    RevisionSet rsCommon = new RevisionSet(common);
                    HgRemoteRepository.Phases remotePhases = this.remote.getPhases();
                    phaseHelper.synchronizeWithRemote(remotePhases, rsCommon.union(this.added));
                }
                progress.worked(5);
                incoming.unlink();
            }
            catch (HgRuntimeException ex) {
                throw new HgLibraryFailureException(ex);
            }
        }
        finally {
            progress.done();
        }
    }

    public Collection<Nodeid> getPulledRevisions() {
        return this.added == null ? Collections.emptyList() : this.added.asList();
    }
}

