/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.core;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.tmatesoft.hg.core.HgAbstractCommand;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.core.HgLibraryFailureException;
import org.tmatesoft.hg.core.HgRemoteConnectionException;
import org.tmatesoft.hg.core.HgRepositoryNotFoundException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.BundleGenerator;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.internal.PhasesHelper;
import org.tmatesoft.hg.internal.RepositoryComparator;
import org.tmatesoft.hg.internal.RevisionSet;
import org.tmatesoft.hg.repo.HgBookmarks;
import org.tmatesoft.hg.repo.HgBundle;
import org.tmatesoft.hg.repo.HgChangelog;
import org.tmatesoft.hg.repo.HgInternals;
import org.tmatesoft.hg.repo.HgInvalidStateException;
import org.tmatesoft.hg.repo.HgLookup;
import org.tmatesoft.hg.repo.HgParentChildMap;
import org.tmatesoft.hg.repo.HgPhase;
import org.tmatesoft.hg.repo.HgRemoteRepository;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.CancelledException;
import org.tmatesoft.hg.util.LogFacility;
import org.tmatesoft.hg.util.Outcome;
import org.tmatesoft.hg.util.Pair;
import org.tmatesoft.hg.util.ProgressSupport;

public class HgPushCommand
extends HgAbstractCommand<HgPushCommand> {
    private final HgRepository repo;
    private HgRemoteRepository remoteRepo;
    private RevisionSet outgoing;

    public HgPushCommand(HgRepository hgRepo) {
        this.repo = hgRepo;
    }

    public HgPushCommand destination(HgRemoteRepository hgRemote) {
        this.remoteRepo = hgRemote;
        return this;
    }

    public void execute() throws HgRemoteConnectionException, HgIOException, CancelledException, HgLibraryFailureException {
        ProgressSupport progress = this.getProgressSupport(null);
        try {
            try {
                HgRemoteRepository.Phases remotePhases;
                RevisionSet remoteDraftsLocalPublic;
                progress.start(100);
                HgChangelog clog = this.repo.getChangelog();
                HgParentChildMap<HgChangelog> parentHelper = new HgParentChildMap<HgChangelog>(clog);
                parentHelper.init();
                Internals implRepo = HgInternals.getImplementationRepo(this.repo);
                PhasesHelper phaseHelper = new PhasesHelper(implRepo, parentHelper);
                RepositoryComparator comparator = new RepositoryComparator(parentHelper, this.remoteRepo);
                comparator.compare(new ProgressSupport.Sub(progress, 50), this.getCancelSupport(null, true));
                List<Nodeid> l = comparator.getLocalOnlyRevisions();
                if (phaseHelper.isCapableOfPhases() && phaseHelper.withSecretRoots()) {
                    RevisionSet secret = phaseHelper.allSecret();
                    this.outgoing = new RevisionSet(l).subtract(secret);
                } else {
                    this.outgoing = new RevisionSet(l);
                }
                HgBundle b = null;
                if (!this.outgoing.isEmpty()) {
                    BundleGenerator bg = new BundleGenerator(implRepo);
                    File bundleFile = bg.create(this.outgoing.asList());
                    progress.worked(20);
                    b = new HgLookup(this.repo.getSessionContext()).loadBundle(bundleFile);
                    this.remoteRepo.unbundle(b, comparator.getRemoteHeads());
                }
                progress.worked(20);
                if (phaseHelper.isCapableOfPhases() && !(remoteDraftsLocalPublic = phaseHelper.synchronizeWithRemote(remotePhases = this.remoteRepo.getPhases(), this.outgoing)).isEmpty()) {
                    for (Nodeid n : remoteDraftsLocalPublic.heads(parentHelper)) {
                        try {
                            Outcome upo = this.remoteRepo.updatePhase(HgPhase.Draft, HgPhase.Public, n);
                            if (upo.isOk()) continue;
                            implRepo.getLog().dump(this.getClass(), LogFacility.Severity.Info, "Failed to update remote phase, reason: %s", upo.getMessage());
                        }
                        catch (HgRemoteConnectionException ex) {
                            implRepo.getLog().dump(this.getClass(), LogFacility.Severity.Error, ex, String.format("Failed to update phase of %s", n.shortNotation()));
                        }
                    }
                }
                progress.worked(5);
                HgBookmarks localBookmarks = this.repo.getBookmarks();
                if (!localBookmarks.getAllBookmarks().isEmpty()) {
                    for (Pair<String, Nodeid> bm : this.remoteRepo.getBookmarks()) {
                        Nodeid localRevision = localBookmarks.getRevision(bm.first());
                        if (localRevision == null || !parentHelper.knownNode(bm.second()) || !parentHelper.isChild(bm.second(), localRevision)) continue;
                        this.remoteRepo.updateBookmark(bm.first(), bm.second(), localRevision);
                    }
                }
                progress.worked(5);
                if (b != null) {
                    b.unlink();
                }
            }
            catch (IOException ex) {
                throw new HgIOException(ex.getMessage(), null);
            }
            catch (HgRepositoryNotFoundException ex) {
                HgInvalidStateException e = new HgInvalidStateException("Failed to load a just-created bundle");
                e.initCause(ex);
                throw new HgLibraryFailureException(e);
            }
            catch (HgRuntimeException ex) {
                throw new HgLibraryFailureException(ex);
            }
        }
        finally {
            progress.done();
        }
    }

    public Collection<Nodeid> getPushedRevisions() {
        return this.outgoing == null ? Collections.emptyList() : this.outgoing.asList();
    }
}

