/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.core;

import java.io.File;
import org.tmatesoft.hg.core.HgAddRemoveCommand;
import org.tmatesoft.hg.core.HgAnnotateCommand;
import org.tmatesoft.hg.core.HgCatCommand;
import org.tmatesoft.hg.core.HgCheckoutCommand;
import org.tmatesoft.hg.core.HgCloneCommand;
import org.tmatesoft.hg.core.HgCommitCommand;
import org.tmatesoft.hg.core.HgDiffCommand;
import org.tmatesoft.hg.core.HgIncomingCommand;
import org.tmatesoft.hg.core.HgInitCommand;
import org.tmatesoft.hg.core.HgLogCommand;
import org.tmatesoft.hg.core.HgManifestCommand;
import org.tmatesoft.hg.core.HgOutgoingCommand;
import org.tmatesoft.hg.core.HgPullCommand;
import org.tmatesoft.hg.core.HgPushCommand;
import org.tmatesoft.hg.core.HgRepositoryNotFoundException;
import org.tmatesoft.hg.core.HgRevertCommand;
import org.tmatesoft.hg.core.HgStatusCommand;
import org.tmatesoft.hg.core.HgUpdateConfigCommand;
import org.tmatesoft.hg.core.SessionContext;
import org.tmatesoft.hg.internal.BasicSessionContext;
import org.tmatesoft.hg.repo.HgLookup;
import org.tmatesoft.hg.repo.HgRepository;

public class HgRepoFacade
implements SessionContext.Source {
    private HgRepository repo;
    private final SessionContext context;

    public HgRepoFacade() {
        this(new BasicSessionContext(null));
    }

    public HgRepoFacade(SessionContext ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException();
        }
        this.context = ctx;
    }

    public boolean init(HgRepository hgRepo) {
        if (hgRepo == null) {
            throw new IllegalArgumentException();
        }
        this.repo = hgRepo;
        return !this.repo.isInvalid();
    }

    public boolean init() throws HgRepositoryNotFoundException {
        this.repo = new HgLookup(this.context).detectFromWorkingDir();
        return this.repo != null && !this.repo.isInvalid();
    }

    public boolean initFrom(File repoLocation) throws HgRepositoryNotFoundException {
        if (repoLocation == null) {
            throw new IllegalArgumentException();
        }
        this.repo = new HgLookup(this.context).detect(repoLocation);
        return this.repo != null && !this.repo.isInvalid();
    }

    public HgRepository getRepository() {
        if (this.repo == null) {
            throw new IllegalStateException("Call any of #init*() methods first first");
        }
        return this.repo;
    }

    @Override
    public SessionContext getSessionContext() {
        return this.context;
    }

    public HgInitCommand createInitCommand() {
        return new HgInitCommand(new HgLookup(this.context));
    }

    public HgLogCommand createLogCommand() {
        return new HgLogCommand(this.repo);
    }

    public HgStatusCommand createStatusCommand() {
        return new HgStatusCommand(this.repo);
    }

    public HgCatCommand createCatCommand() {
        return new HgCatCommand(this.repo);
    }

    public HgManifestCommand createManifestCommand() {
        return new HgManifestCommand(this.repo);
    }

    public HgOutgoingCommand createOutgoingCommand() {
        return new HgOutgoingCommand(this.repo);
    }

    public HgIncomingCommand createIncomingCommand() {
        return new HgIncomingCommand(this.repo);
    }

    public HgCloneCommand createCloneCommand() {
        return new HgCloneCommand();
    }

    public HgUpdateConfigCommand createUpdateRepositoryConfigCommand() {
        return HgUpdateConfigCommand.forRepository(this.repo);
    }

    public HgAddRemoveCommand createAddRemoveCommand() {
        return new HgAddRemoveCommand(this.repo);
    }

    public HgCheckoutCommand createCheckoutCommand() {
        return new HgCheckoutCommand(this.repo);
    }

    public HgRevertCommand createRevertCommand() {
        return new HgRevertCommand(this.repo);
    }

    public HgAnnotateCommand createAnnotateCommand() {
        return new HgAnnotateCommand(this.repo);
    }

    public HgCommitCommand createCommitCommand() {
        return new HgCommitCommand(this.repo);
    }

    public HgDiffCommand createDiffCommand() {
        return new HgDiffCommand(this.repo);
    }

    public HgPushCommand createPushCommand() {
        return new HgPushCommand(this.repo);
    }

    public HgPullCommand createPullCommand() {
        return new HgPullCommand(this.repo);
    }
}

