/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.core;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.tmatesoft.hg.core.HgAbstractCommand;
import org.tmatesoft.hg.core.HgBadArgumentException;
import org.tmatesoft.hg.core.HgCheckoutCommand;
import org.tmatesoft.hg.core.HgException;
import org.tmatesoft.hg.core.HgLibraryFailureException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.COWTransaction;
import org.tmatesoft.hg.internal.CsetParamKeeper;
import org.tmatesoft.hg.internal.DirstateBuilder;
import org.tmatesoft.hg.internal.DirstateReader;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.internal.Transaction;
import org.tmatesoft.hg.repo.HgManifest;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRepositoryLock;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.CancelSupport;
import org.tmatesoft.hg.util.CancelledException;
import org.tmatesoft.hg.util.Path;
import org.tmatesoft.hg.util.ProgressSupport;

public class HgRevertCommand
extends HgAbstractCommand<HgRevertCommand> {
    private final HgRepository repo;
    private final Set<Path> files = new LinkedHashSet<Path>();
    private CsetParamKeeper changesetToCheckout;
    private boolean keepOriginal = true;

    public HgRevertCommand(HgRepository hgRepo) {
        this.repo = hgRepo;
        this.changesetToCheckout = new CsetParamKeeper(hgRepo);
        this.changesetToCheckout.doSet(-2);
    }

    public HgRevertCommand file(Path ... paths) {
        this.files.addAll(Arrays.asList(paths));
        return this;
    }

    public HgRevertCommand changeset(int changesetRevIndex) throws HgBadArgumentException {
        this.changesetToCheckout.set(changesetRevIndex);
        return this;
    }

    public HgRevertCommand changeset(Nodeid revision) throws HgBadArgumentException {
        this.changesetToCheckout.set(revision);
        return this;
    }

    public void execute() throws HgException, CancelledException {
        HgRepositoryLock wdLock = this.repo.getWorkingDirLock();
        wdLock.acquire();
        try {
            try {
                ProgressSupport progress = this.getProgressSupport(null);
                CancelSupport cancellation = this.getCancelSupport(null, true);
                cancellation.checkCancelled();
                progress.start(this.files.size() + 2);
                int csetRevision = this.changesetToCheckout.get() == -2 ? this.repo.getChangelog().getRevisionIndex(this.repo.getWorkingCopyParents().first()) : this.changesetToCheckout.get();
                Internals implRepo = Internals.getInstance(this.repo);
                final DirstateBuilder dirstateBuilder = new DirstateBuilder(implRepo);
                dirstateBuilder.fillFrom(new DirstateReader(implRepo, new Path.SimpleSource()));
                progress.worked(1);
                cancellation.checkCancelled();
                final HgCheckoutCommand.CheckoutWorker worker = new HgCheckoutCommand.CheckoutWorker(implRepo);
                HgManifest.Inspector insp = new HgManifest.Inspector(){

                    @Override
                    public boolean next(Nodeid nid, Path fname, HgManifest.Flags flags) {
                        if (worker.next(nid, fname, flags)) {
                            dirstateBuilder.recordUncertain(fname);
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public boolean end(int manifestRevision) {
                        return false;
                    }

                    @Override
                    public boolean begin(int mainfestRevision, Nodeid nid, int changelogRevision) {
                        return true;
                    }
                };
                for (Path file : this.files) {
                    File f = new File(this.repo.getWorkingDir(), file.toString());
                    if (f.isFile()) {
                        if (this.keepOriginal) {
                            File copy = new File(f.getParentFile(), String.valueOf(f.getName()) + ".orig");
                            if (copy.exists()) {
                                copy.delete();
                            }
                            f.renameTo(copy);
                        } else {
                            f.delete();
                        }
                    }
                    this.repo.getManifest().walkFileRevisions(file, insp, csetRevision);
                    worker.checkFailed();
                    progress.worked(1);
                    cancellation.checkCancelled();
                }
                COWTransaction.Factory trFactory = new COWTransaction.Factory();
                Transaction tr = trFactory.create(this.repo);
                try {
                    dirstateBuilder.serialize(tr);
                    tr.commit();
                }
                catch (RuntimeException ex) {
                    tr.rollback();
                    throw ex;
                }
                catch (HgException ex) {
                    tr.rollback();
                    throw ex;
                }
                progress.worked(1);
                progress.done();
            }
            catch (HgRuntimeException ex) {
                throw new HgLibraryFailureException(ex);
            }
        }
        finally {
            wdLock.release();
        }
    }
}

