/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.core;

import java.io.File;
import java.util.Date;
import org.tmatesoft.hg.internal.ChangelogHelper;
import org.tmatesoft.hg.repo.HgChangelog;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.Path;

public class HgStatus {
    private final Kind kind;
    private final Path path;
    private final Path origin;
    private final ChangelogHelper logHelper;

    HgStatus(Kind kind, Path path, ChangelogHelper changelogHelper) {
        this(kind, path, null, changelogHelper);
    }

    HgStatus(Kind kind, Path path, Path copyOrigin, ChangelogHelper changelogHelper) {
        this.kind = kind;
        this.path = path;
        this.origin = copyOrigin;
        this.logHelper = changelogHelper;
    }

    public Kind getKind() {
        return this.kind;
    }

    public Path getPath() {
        return this.path;
    }

    public Path getOriginalPath() {
        return this.origin;
    }

    public boolean isCopy() {
        return this.origin != null;
    }

    public String getModificationAuthor() throws HgRuntimeException {
        HgChangelog.RawChangeset cset = this.logHelper.findLatestChangeWith(this.path);
        if (cset == null) {
            if (this.kind == Kind.Modified || this.kind == Kind.Added || this.kind == Kind.Removed) {
                return this.logHelper.getNextCommitUsername();
            }
        } else {
            return cset.user();
        }
        return null;
    }

    public Date getModificationDate() throws HgRuntimeException {
        HgChangelog.RawChangeset cset = this.logHelper.findLatestChangeWith(this.path);
        if (cset == null) {
            File localFile = new File(this.logHelper.getRepo().getWorkingDir(), this.path.toString());
            if (localFile.canRead()) {
                return new Date(localFile.lastModified());
            }
            return new Date();
        }
        return cset.date();
    }

    public static enum Kind {
        Modified,
        Added,
        Removed,
        Missing,
        Unknown,
        Clean,
        Ignored;

    }
}

