/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.core;

import java.io.IOException;
import java.util.ConcurrentModificationException;
import org.tmatesoft.hg.core.HgAbstractCommand;
import org.tmatesoft.hg.core.HgBadArgumentException;
import org.tmatesoft.hg.core.HgCallbackTargetException;
import org.tmatesoft.hg.core.HgException;
import org.tmatesoft.hg.core.HgLibraryFailureException;
import org.tmatesoft.hg.core.HgStatus;
import org.tmatesoft.hg.core.HgStatusHandler;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.AdapterPlug;
import org.tmatesoft.hg.internal.ChangelogHelper;
import org.tmatesoft.hg.internal.CsetParamKeeper;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.repo.HgInternals;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.repo.HgStatusCollector;
import org.tmatesoft.hg.repo.HgStatusInspector;
import org.tmatesoft.hg.repo.HgWorkingCopyStatusCollector;
import org.tmatesoft.hg.util.Adaptable;
import org.tmatesoft.hg.util.CancelSupport;
import org.tmatesoft.hg.util.CancelledException;
import org.tmatesoft.hg.util.Outcome;
import org.tmatesoft.hg.util.Path;

public class HgStatusCommand
extends HgAbstractCommand<HgStatusCommand> {
    private final HgRepository repo;
    private int startRevision = -3;
    private int endRevision = -2;
    private Path.Matcher scope;
    private final Mediator mediator = new Mediator();

    public HgStatusCommand(HgRepository hgRepo) {
        this.repo = hgRepo;
        this.defaults();
    }

    public HgStatusCommand defaults() {
        Mediator m = this.mediator;
        m.needMissing = true;
        m.needUnknown = true;
        m.needRemoved = true;
        m.needAdded = true;
        m.needModified = true;
        m.needIgnored = false;
        m.needClean = false;
        return this;
    }

    public HgStatusCommand all() {
        Mediator m = this.mediator;
        m.needMissing = true;
        m.needUnknown = true;
        m.needRemoved = true;
        m.needAdded = true;
        m.needModified = true;
        m.needIgnored = true;
        m.needClean = true;
        return this;
    }

    public HgStatusCommand modified(boolean include) {
        this.mediator.needModified = include;
        return this;
    }

    public HgStatusCommand added(boolean include) {
        this.mediator.needAdded = include;
        return this;
    }

    public HgStatusCommand removed(boolean include) {
        this.mediator.needRemoved = include;
        return this;
    }

    public HgStatusCommand deleted(boolean include) {
        this.mediator.needMissing = include;
        return this;
    }

    public HgStatusCommand unknown(boolean include) {
        this.mediator.needUnknown = include;
        return this;
    }

    public HgStatusCommand clean(boolean include) {
        this.mediator.needClean = include;
        return this;
    }

    public HgStatusCommand ignored(boolean include) {
        this.mediator.needIgnored = include;
        return this;
    }

    public HgStatusCommand base(int changesetRevisionIndex) {
        if (changesetRevisionIndex == -2 || HgInternals.wrongRevisionIndex(changesetRevisionIndex)) {
            throw new IllegalArgumentException(String.valueOf(changesetRevisionIndex));
        }
        if (changesetRevisionIndex == Integer.MIN_VALUE) {
            changesetRevisionIndex = -3;
        }
        this.startRevision = changesetRevisionIndex;
        return this;
    }

    public HgStatusCommand base(Nodeid changeset) throws HgBadArgumentException {
        int ri = new CsetParamKeeper(this.repo).set(changeset).get();
        return this.base(ri);
    }

    public HgStatusCommand revision(int changesetRevisionIndex) {
        if (changesetRevisionIndex == Integer.MIN_VALUE) {
            changesetRevisionIndex = -2;
        }
        if (HgInternals.wrongRevisionIndex(changesetRevisionIndex)) {
            throw new IllegalArgumentException(String.valueOf(changesetRevisionIndex));
        }
        this.endRevision = changesetRevisionIndex;
        return this;
    }

    public HgStatusCommand revision(Nodeid changeset) throws HgBadArgumentException {
        int ri = new CsetParamKeeper(this.repo).set(changeset).get();
        return this.revision(ri);
    }

    public HgStatusCommand change(int changesetIndex) {
        this.base(Integer.MIN_VALUE);
        return this.revision(changesetIndex);
    }

    public HgStatusCommand change(Nodeid changeset) throws HgBadArgumentException {
        this.base(Integer.MIN_VALUE);
        return this.revision(changeset);
    }

    public HgStatusCommand match(Path.Matcher scopeMatcher) {
        this.scope = scopeMatcher;
        return this;
    }

    public HgStatusCommand subrepo(boolean visit) {
        throw Internals.notImplemented();
    }

    public void execute(HgStatusHandler statusHandler) throws HgCallbackTargetException, HgException, IOException, CancelledException {
        if (statusHandler == null) {
            throw new IllegalArgumentException();
        }
        if (this.mediator.busy()) {
            throw new ConcurrentModificationException();
        }
        HgStatusCollector sc = new HgStatusCollector(this.repo);
        try {
            try {
                this.mediator.start(statusHandler, this.getCancelSupport(statusHandler, true), new ChangelogHelper(this.repo, this.startRevision));
                if (this.endRevision == -2) {
                    HgWorkingCopyStatusCollector wcsc = this.scope != null ? HgWorkingCopyStatusCollector.create(this.repo, this.scope) : new HgWorkingCopyStatusCollector(this.repo);
                    wcsc.setBaseRevisionCollector(sc);
                    wcsc.walk(this.startRevision, this.mediator);
                } else {
                    sc.setScope(this.scope);
                    if (this.startRevision == -3) {
                        sc.change(this.endRevision, this.mediator);
                    } else {
                        sc.walk(this.startRevision, this.endRevision, this.mediator);
                    }
                }
                this.mediator.checkFailure();
            }
            catch (HgRuntimeException ex) {
                throw new HgLibraryFailureException(ex);
            }
        }
        finally {
            this.mediator.done();
        }
    }

    private class Mediator
    extends AdapterPlug
    implements HgStatusInspector,
    Adaptable {
        boolean needModified;
        boolean needAdded;
        boolean needRemoved;
        boolean needUnknown;
        boolean needMissing;
        boolean needClean;
        boolean needIgnored;
        HgStatusHandler handler;
        private ChangelogHelper logHelper;
        private HgCallbackTargetException failure;

        Mediator() {
        }

        public void start(HgStatusHandler h, CancelSupport hcs, ChangelogHelper changelogHelper) {
            this.handler = h;
            super.attachAdapter(CancelSupport.class, hcs);
            this.logHelper = changelogHelper;
        }

        public void done() {
            this.handler = null;
            super.detachAdapter(CancelSupport.class);
            this.logHelper = null;
            this.failure = null;
        }

        public boolean busy() {
            return this.handler != null;
        }

        public void checkFailure() throws HgCallbackTargetException {
            if (this.failure != null) {
                HgCallbackTargetException toThrow = this.failure;
                this.failure = null;
                throw toThrow;
            }
        }

        private void dispatch(HgStatus s) {
            try {
                this.handler.status(s);
            }
            catch (HgCallbackTargetException ex) {
                this.failure = ex;
            }
        }

        @Override
        public void modified(Path fname) {
            if (this.needModified) {
                this.dispatch(new HgStatus(HgStatus.Kind.Modified, fname, this.logHelper));
            }
        }

        @Override
        public void added(Path fname) {
            if (this.needAdded) {
                this.dispatch(new HgStatus(HgStatus.Kind.Added, fname, this.logHelper));
            }
        }

        @Override
        public void removed(Path fname) {
            if (this.needRemoved) {
                this.dispatch(new HgStatus(HgStatus.Kind.Removed, fname, this.logHelper));
            }
        }

        @Override
        public void copied(Path fnameOrigin, Path fnameAdded) {
            this.dispatch(new HgStatus(HgStatus.Kind.Added, fnameAdded, fnameOrigin, this.logHelper));
        }

        @Override
        public void missing(Path fname) {
            if (this.needMissing) {
                this.dispatch(new HgStatus(HgStatus.Kind.Missing, fname, this.logHelper));
            }
        }

        @Override
        public void unknown(Path fname) {
            if (this.needUnknown) {
                this.dispatch(new HgStatus(HgStatus.Kind.Unknown, fname, this.logHelper));
            }
        }

        @Override
        public void clean(Path fname) {
            if (this.needClean) {
                this.dispatch(new HgStatus(HgStatus.Kind.Clean, fname, this.logHelper));
            }
        }

        @Override
        public void ignored(Path fname) {
            if (this.needIgnored) {
                this.dispatch(new HgStatus(HgStatus.Kind.Ignored, fname, this.logHelper));
            }
        }

        @Override
        public void invalid(Path fname, Exception err) {
            try {
                this.handler.error(fname, new Outcome(Outcome.Kind.Failure, "Failed to get file status", err));
            }
            catch (HgCallbackTargetException ex) {
                this.failure = ex;
            }
        }
    }
}

