/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.tmatesoft.hg.core.HgAbstractCommand;
import org.tmatesoft.hg.core.HgBadArgumentException;
import org.tmatesoft.hg.core.HgException;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.core.HgMissingConfigElementException;
import org.tmatesoft.hg.core.SessionContext;
import org.tmatesoft.hg.internal.ConfigFile;
import org.tmatesoft.hg.internal.ConfigFileParser;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.repo.HgInternals;
import org.tmatesoft.hg.repo.HgInvalidStateException;
import org.tmatesoft.hg.repo.HgRepository;

public final class HgUpdateConfigCommand
extends HgAbstractCommand<HgUpdateConfigCommand> {
    private final SessionContext sessionCtx;
    private final File configFile;
    private final List<Operation> changes = new LinkedList<Operation>();
    private boolean ignoreMissingKeys = false;

    private HgUpdateConfigCommand(SessionContext sessionContext, File configurationFile) {
        this.sessionCtx = sessionContext;
        this.configFile = configurationFile;
    }

    public static HgUpdateConfigCommand forRepository(HgRepository hgRepo) {
        return new HgUpdateConfigCommand(hgRepo.getSessionContext(), HgInternals.getImplementationRepo(hgRepo).getFileFromRepoDir("hgrc"));
    }

    public static HgUpdateConfigCommand forUser(SessionContext ctx) {
        return new HgUpdateConfigCommand(ctx, Internals.getUserConfigurationFileToWrite(ctx));
    }

    public static HgUpdateConfigCommand forInstallation(SessionContext ctx) {
        return new HgUpdateConfigCommand(ctx, Internals.getInstallationConfigurationFileToWrite(ctx));
    }

    public HgUpdateConfigCommand remove(String section, String key) throws IllegalArgumentException {
        HgUpdateConfigCommand.checkSection(section);
        HgUpdateConfigCommand.checkKey(key);
        this.changes.add(Operation.deleteEntry(section, key));
        return this;
    }

    public HgUpdateConfigCommand remove(String section, String key, String value) throws IllegalArgumentException {
        HgUpdateConfigCommand.checkSection(section);
        HgUpdateConfigCommand.checkKey(key);
        this.changes.add(Operation.deleteValue(section, key, value));
        return this;
    }

    public HgUpdateConfigCommand put(String section, String key, String value) throws IllegalArgumentException {
        HgUpdateConfigCommand.checkSection(section);
        HgUpdateConfigCommand.checkKey(key);
        this.changes.add(Operation.setValue(section, key, value));
        return this;
    }

    public HgUpdateConfigCommand add(String section, String key, String value) throws IllegalArgumentException {
        HgUpdateConfigCommand.checkSection(section);
        HgUpdateConfigCommand.checkKey(key);
        this.changes.add(Operation.addValue(section, key, value));
        return this;
    }

    public HgUpdateConfigCommand ignoreMissing(boolean ignoreMissing) {
        this.ignoreMissingKeys = ignoreMissing;
        return this;
    }

    public void execute() throws HgMissingConfigElementException, HgIOException, HgException {
        try {
            ConfigFile cfgRead = new ConfigFile(this.sessionCtx);
            cfgRead.addLocation(this.configFile);
            ConfigFileParser cfgWrite = new ConfigFileParser();
            FileInputStream fis = new FileInputStream(this.configFile);
            cfgWrite.parse(fis);
            fis.close();
            block8: for (Operation op : this.changes) {
                if (!this.ignoreMissingKeys && !cfgRead.hasSection(op.section)) {
                    throw new HgMissingConfigElementException("Bad section name", op.section, op.key);
                }
                Map<String, String> sect = cfgRead.getSection(op.section);
                if (!this.ignoreMissingKeys && !sect.containsKey(op.key)) {
                    throw new HgMissingConfigElementException("Bad key name", op.section, op.key);
                }
                String oldValue = sect.get(op.key);
                if (oldValue == null) {
                    oldValue = "";
                }
                switch (op.kind) {
                    case AddValue: {
                        String separator = ", ";
                        String newValue = String.valueOf(oldValue) + separator + op.value;
                        if (sect.containsKey(op.key)) {
                            cfgWrite.change(op.section, op.key, newValue);
                            break;
                        }
                        cfgWrite.add(op.section, op.key, newValue);
                        break;
                    }
                    case DelValue: {
                        if (!(this.ignoreMissingKeys || oldValue.length() != 0 && oldValue.contains(op.value))) {
                            throw new HgMissingConfigElementException(String.format("Bad value '%s' to delete from '%s'", op.value, oldValue), op.section, op.key);
                        }
                        int start = oldValue.indexOf(op.value);
                        if (start == -1) continue block8;
                        int commaPos = -1;
                        int i = start - 1;
                        while (i >= 0) {
                            if (oldValue.charAt(i) == ',') {
                                commaPos = i;
                                break;
                            }
                            --i;
                        }
                        i = start + op.value.length();
                        while (commaPos == -1 && i < oldValue.length()) {
                            if (oldValue.charAt(i) == ',') {
                                commaPos = i;
                                break;
                            }
                            ++i;
                        }
                        String newValue = commaPos >= 0 ? (commaPos < start ? String.valueOf(oldValue.substring(0, commaPos)) + oldValue.substring(start + op.value.length()) : String.valueOf(oldValue.substring(0, start)) + oldValue.substring(commaPos + 1)) : String.valueOf(oldValue.substring(0, start)) + oldValue.substring(start + op.value.length());
                        cfgWrite.change(op.section, op.key, newValue);
                        break;
                    }
                    case SetValue: {
                        if (sect.containsKey(op.key)) {
                            cfgWrite.change(op.section, op.key, op.value);
                            break;
                        }
                        cfgWrite.add(op.section, op.key, op.value);
                        break;
                    }
                    case DelEntry: {
                        cfgWrite.delete(op.section, op.key);
                        break;
                    }
                    default: {
                        throw new HgInvalidStateException(String.format("Unknown change %s", new Object[]{op.kind}));
                    }
                }
            }
            FileOutputStream fos = new FileOutputStream(this.configFile);
            cfgWrite.update(fos);
            fos.close();
        }
        catch (IOException ex) {
            String m = String.format("Failed to update configuration file %s", this.configFile);
            throw new HgBadArgumentException(m, ex);
        }
    }

    private static void checkSection(String section) throws IllegalArgumentException {
        if (section == null || section.trim().length() == 0) {
            throw new IllegalArgumentException(String.format("Section name can't be empty: %s", section));
        }
    }

    private static void checkKey(String key) throws IllegalArgumentException {
        if (key == null || key.trim().length() == 0) {
            throw new IllegalArgumentException(String.format("Entry key can't be empty: %s", key));
        }
    }

    private static class Operation {
        public final OpKind kind;
        public final String section;
        public final String key;
        public final String value;

        private Operation(OpKind t, String s, String k, String v) {
            this.kind = t;
            this.section = s;
            this.key = k;
            this.value = v;
        }

        public static Operation deleteEntry(String section, String key) throws IllegalArgumentException {
            return new Operation(OpKind.DelEntry, section, key, null);
        }

        public static Operation deleteValue(String section, String key, String value) throws IllegalArgumentException {
            if (value == null || value.trim().length() == 0) {
                throw new IllegalArgumentException(String.format("Can't remove empty value '%s'", value));
            }
            return new Operation(OpKind.DelValue, section, key, value);
        }

        public static Operation addValue(String section, String key, String value) throws IllegalArgumentException {
            if (value == null || value.trim().length() == 0) {
                throw new IllegalArgumentException(String.format("Can't add empty value '%s'", value));
            }
            return new Operation(OpKind.AddValue, section, key, value);
        }

        public static Operation setValue(String section, String key, String value) throws IllegalArgumentException {
            return new Operation(OpKind.SetValue, section, key, value);
        }

        private static enum OpKind {
            AddValue,
            SetValue,
            DelValue,
            DelEntry;

        }
    }
}

