/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.core;

import java.util.Arrays;
import org.tmatesoft.hg.core.HgBadNodeidFormatException;
import org.tmatesoft.hg.internal.DigestHelper;

public final class Nodeid
implements Comparable<Nodeid> {
    public static final int SIZE = 20;
    public static final int SIZE_ASCII = 40;
    public static final Nodeid NULL = new Nodeid(new byte[20], false);
    private final byte[] binaryData;

    public Nodeid(byte[] binaryRepresentation, boolean shallClone) {
        if (binaryRepresentation == null || binaryRepresentation.length != 20) {
            throw new HgBadNodeidFormatException(String.format("Bad value: %s", String.valueOf(binaryRepresentation)));
        }
        this.binaryData = shallClone ? (byte[])binaryRepresentation.clone() : binaryRepresentation;
    }

    public int hashCode() {
        return Nodeid.hashCode(this.binaryData);
    }

    public static int hashCode(byte[] binaryNodeid) {
        assert (binaryNodeid.length == 20);
        byte[] b = binaryNodeid;
        return b[0] << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Nodeid) {
            return this.equalsTo(((Nodeid)o).binaryData);
        }
        return false;
    }

    public boolean equalsTo(byte[] buf) {
        return Arrays.equals(this.binaryData, buf);
    }

    @Override
    public int compareTo(Nodeid o) {
        if (this == o) {
            return 0;
        }
        int i = 0;
        while (i < 20) {
            if (this.binaryData[i] != o.binaryData[i]) {
                return this.binaryData[i] < o.binaryData[i] ? -1 : 1;
            }
            ++i;
        }
        return 0;
    }

    public String toString() {
        return DigestHelper.toHexString(this.binaryData, 0, this.binaryData.length);
    }

    public String shortNotation() {
        return DigestHelper.toHexString(this.binaryData, 0, 6);
    }

    public boolean isNull() {
        if (this == NULL) {
            return true;
        }
        int i = 0;
        while (i < 20) {
            if (this.binaryData[i] != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public byte[] toByteArray() {
        return (byte[])this.binaryData.clone();
    }

    public static Nodeid fromBinary(byte[] binaryRepresentation, int offset) {
        if (binaryRepresentation == null || binaryRepresentation.length - offset < 20) {
            throw new HgBadNodeidFormatException(String.format("Bad value: %s", String.valueOf(binaryRepresentation)));
        }
        int i = 0;
        while (i < 20 && binaryRepresentation[offset + i] == 0) {
            ++i;
        }
        if (i == 20) {
            return NULL;
        }
        if (offset == 0 && binaryRepresentation.length == 20) {
            return new Nodeid(binaryRepresentation, true);
        }
        byte[] b = new byte[20];
        System.arraycopy(binaryRepresentation, offset, b, 0, 20);
        return new Nodeid(b, false);
    }

    public static Nodeid fromAscii(String asciiRepresentation) throws HgBadNodeidFormatException {
        if (asciiRepresentation.length() != 40) {
            throw new HgBadNodeidFormatException(String.format("Bad value: %s", asciiRepresentation));
        }
        return Nodeid.fromAscii(asciiRepresentation.toCharArray(), 0, 40);
    }

    public static Nodeid fromAscii(byte[] asciiRepresentation, int offset, int length) throws HgBadNodeidFormatException {
        if (length != 40) {
            throw new HgBadNodeidFormatException(String.format("Expected %d hex characters for nodeid, not %d", 40, length));
        }
        try {
            byte[] data = new byte[20];
            boolean zeroBytes = DigestHelper.ascii2bin(asciiRepresentation, offset, length, data);
            if (zeroBytes) {
                return NULL;
            }
            return new Nodeid(data, false);
        }
        catch (HgBadNodeidFormatException ex) {
            throw ex;
        }
        catch (IllegalArgumentException ex) {
            throw new HgBadNodeidFormatException(ex.getMessage());
        }
    }

    public static Nodeid fromAscii(char[] asciiRepresentation, int offset, int length) {
        byte[] b = new byte[length];
        int i = 0;
        while (i < b.length) {
            b[i] = (byte)asciiRepresentation[offset + i];
            ++i;
        }
        return Nodeid.fromAscii(b, 0, b.length);
    }
}

