/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.util.HashMap;
import java.util.Set;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.FNCacheFile;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.internal.RevisionSet;
import org.tmatesoft.hg.internal.RevlogStream;
import org.tmatesoft.hg.internal.RevlogStreamWriter;
import org.tmatesoft.hg.internal.Transaction;
import org.tmatesoft.hg.repo.HgBundle;
import org.tmatesoft.hg.repo.HgDataFile;
import org.tmatesoft.hg.repo.HgInvalidControlFileException;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.Pair;

public final class AddRevInspector
implements HgBundle.Inspector {
    private final Internals repo;
    private final Transaction tr;
    private final FNCacheFile.Mediator fncache;
    private Set<Nodeid> added;
    private RevlogStreamWriter revlog;
    private RevMap clogRevs;
    private RevMap revlogRevs;
    private HgDataFile fileNode;
    private boolean newFile = false;

    public AddRevInspector(Internals implRepo, Transaction transaction) {
        this.repo = implRepo;
        this.tr = transaction;
        this.fncache = new FNCacheFile.Mediator(implRepo, transaction);
    }

    @Override
    public void changelogStart() throws HgRuntimeException {
        RevlogStream rs = this.repo.getImplAccess().getChangelogStream();
        this.revlog = new RevlogStreamWriter(this.repo, rs, this.tr);
        this.revlogRevs = this.clogRevs = new RevMap(rs);
    }

    @Override
    public void changelogEnd() throws HgRuntimeException {
        this.revlog = null;
        this.revlogRevs = null;
        this.added = this.clogRevs.added();
    }

    @Override
    public void manifestStart() throws HgRuntimeException {
        RevlogStream rs = this.repo.getImplAccess().getManifestStream();
        this.revlog = new RevlogStreamWriter(this.repo, rs, this.tr);
        this.revlogRevs = new RevMap(rs);
    }

    @Override
    public void manifestEnd() throws HgRuntimeException {
        this.revlog = null;
        this.revlogRevs = null;
    }

    @Override
    public void fileStart(String name) throws HgRuntimeException {
        this.fileNode = this.repo.getRepo().getFileNode(name);
        this.newFile = !this.fileNode.exists();
        RevlogStream rs = this.repo.getImplAccess().getStream(this.fileNode);
        this.revlog = new RevlogStreamWriter(this.repo, rs, this.tr);
        this.revlogRevs = new RevMap(rs);
    }

    @Override
    public void fileEnd(String name) throws HgRuntimeException {
        if (this.newFile) {
            this.fncache.registerNew(this.fileNode.getPath(), this.revlog.getRevlogStream());
        }
        this.revlog = null;
        this.revlogRevs = null;
    }

    @Override
    public boolean element(HgBundle.GroupElement ge) throws HgRuntimeException {
        assert (this.clogRevs != null);
        assert (this.revlogRevs != null);
        if (this.revlog.getRevlogStream().findRevisionIndex(ge.node()) != Integer.MIN_VALUE) {
            return true;
        }
        try {
            Pair<Integer, Nodeid> newRev = this.revlog.addPatchRevision(ge, this.clogRevs, this.revlogRevs);
            this.revlogRevs.update(newRev.first(), newRev.second());
            return true;
        }
        catch (HgIOException ex) {
            throw new HgInvalidControlFileException(ex, true);
        }
    }

    public RevisionSet addedChangesets() {
        return new RevisionSet(this.added);
    }

    public void done() throws HgIOException {
        this.fncache.complete();
    }

    private static class RevMap
    implements RevlogStreamWriter.RevisionToIndexMap {
        private final RevlogStream revlog;
        private HashMap<Nodeid, Integer> added = new HashMap();

        public RevMap(RevlogStream revlogStream) {
            this.revlog = revlogStream;
        }

        @Override
        public int revisionIndex(Nodeid revision) {
            Integer a = this.added.get(revision);
            if (a != null) {
                return a;
            }
            int f = this.revlog.findRevisionIndex(revision);
            return f == Integer.MIN_VALUE ? -1 : f;
        }

        public void update(Integer revIndex, Nodeid rev) {
            this.added.put(rev, revIndex);
        }

        Set<Nodeid> added() {
            return this.added.keySet();
        }
    }
}

