/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.util.Arrays;

public final class ArrayHelper<T extends Comparable<T>> {
    private int[] reverse;
    private final T[] data;
    private T[] sorted;

    public ArrayHelper(T[] _data) {
        assert (_data != null);
        this.data = _data;
    }

    public void sort(T[] sortDest, boolean sortDestIsEmpty, boolean keepSorted) {
        if (sortDest != null) {
            assert (sortDest.length >= this.data.length);
            if (sortDestIsEmpty) {
                System.arraycopy(this.data, 0, sortDest, 0, this.data.length);
            }
            this.sorted = sortDest;
        } else {
            this.sorted = (Comparable[])this.data.clone();
        }
        this.reverse = new int[this.data.length];
        int i = 0;
        while (i < this.reverse.length) {
            this.reverse[i] = i;
            ++i;
        }
        this.sort1(0, this.data.length);
        if (!keepSorted) {
            this.sorted = null;
        }
    }

    public int[] getReverseIndexes() {
        return this.reverse;
    }

    public int getReverseIndex(int sortedIndex) {
        return this.reverse[sortedIndex];
    }

    public T get(int index) {
        return this.data[index];
    }

    public T[] getData() {
        return this.data;
    }

    public int binarySearchSorted(T value) {
        if (this.sorted != null) {
            int x = Arrays.binarySearch(this.sorted, value);
            return x >= this.data.length ? -(this.data.length - 1) : x;
        }
        return this.binarySearchWithReverse(0, this.data.length, value);
    }

    public int binarySearch(T value, int defaultValue) {
        int x = this.binarySearchSorted(value);
        if (x < 0) {
            return defaultValue;
        }
        return this.reverse[x];
    }

    private void sort1(int off, int len) {
        int c;
        int a;
        Comparable<Object>[] x = this.comparableSorted();
        if (len < 7) {
            int i = off;
            while (i < len + off) {
                int j = i;
                while (j > off && x[j - 1].compareTo(x[j]) > 0) {
                    this.swap(j, j - 1);
                    --j;
                }
                ++i;
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = this.med3(l, l + s, l + 2 * s);
                m = this.med3(m - s, m, m + s);
                n = this.med3(n - 2 * s, n - s, n);
            }
            m = this.med3(l, m, n);
        }
        Comparable<Object> v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b].compareTo(v) <= 0) {
                if (x[b] == v) {
                    this.swap(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c].compareTo(v) >= 0) {
                if (x[c] == v) {
                    this.swap(c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.swap(b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        this.vecswap(off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vecswap(b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.sort1(off, s);
        }
        if ((s = d - c) > 1) {
            this.sort1(n - s, s);
        }
    }

    private void vecswap(int a, int b, int n) {
        int i = 0;
        while (i < n) {
            this.swap(a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private int med3(int a, int b, int c) {
        Comparable<Object>[] x = this.comparableSorted();
        return x[a].compareTo(x[b]) < 0 ? (x[b].compareTo(x[c]) < 0 ? b : (x[a].compareTo(x[c]) < 0 ? c : a)) : (x[b].compareTo(x[c]) > 0 ? b : (x[a].compareTo(x[c]) > 0 ? c : a));
    }

    private Comparable<Object>[] comparableSorted() {
        T[] oo;
        T[] x = oo = this.sorted;
        return x;
    }

    private void swap(int a, int b) {
        T[] x = this.sorted;
        T t = x[a];
        x[a] = x[b];
        x[b] = t;
        int z1 = this.reverse[a];
        int z2 = this.reverse[b];
        this.reverse[b] = z1;
        this.reverse[a] = z2;
    }

    private int binarySearchWithReverse(int fromIndex, int toIndex, T key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            T midVal = this.data[this.reverse[mid]];
            int cmp = midVal.compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }
}

