/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.util.Collections;
import java.util.Map;
import org.tmatesoft.hg.core.SessionContext;
import org.tmatesoft.hg.internal.PropertyMarshal;
import org.tmatesoft.hg.internal.StreamLogFacility;
import org.tmatesoft.hg.util.LogFacility;

public class BasicSessionContext
extends SessionContext
implements SessionContext.Source {
    private LogFacility logFacility;
    private final Map<String, Object> properties;

    public BasicSessionContext(LogFacility log) {
        this(null, log);
    }

    public BasicSessionContext(Map<String, ?> propertyOverrides, LogFacility log) {
        this.logFacility = log;
        this.properties = propertyOverrides == null ? Collections.emptyMap() : propertyOverrides;
    }

    @Override
    public LogFacility getLog() {
        if (this.logFacility == null) {
            PropertyMarshal pm = new PropertyMarshal(this);
            boolean needDebug = pm.getBoolean("hg4j.consolelog.debug", false);
            boolean needInfo = pm.getBoolean("hg4j.consolelog.info", false);
            boolean needTime = pm.getBoolean("hg4j.consolelog.tstamp", true);
            LogFacility.Severity l = needDebug ? LogFacility.Severity.Debug : (needInfo ? LogFacility.Severity.Info : LogFacility.Severity.Warn);
            this.logFacility = new StreamLogFacility(l, needTime, System.out);
        }
        return this.logFacility;
    }

    @Override
    public Object getConfigurationProperty(String name, Object defaultValue) {
        Object value = this.properties.get(name);
        if (value != null) {
            return value;
        }
        value = System.getProperty(name);
        return value == null ? defaultValue : value;
    }

    @Override
    public SessionContext getSessionContext() {
        return this;
    }
}

