/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.util.Arrays;
import java.util.NoSuchElementException;

public class BatchRangeHelper {
    private final int rangeCount;
    private final int rangeDelta;
    private final int nextValueDelta;
    private final int firstBoundary;
    private final int lastBoundary;
    private int rangeIndex;
    private int rangeValue;
    private int rangeStart;
    private int rangeEnd;

    public BatchRangeHelper(int start, int end, int batchSize, boolean reverse) {
        this(start, end, batchSize, batchSize / 5, reverse);
    }

    public BatchRangeHelper(int start, int end, int batchSize, int batchSizeTolerance, boolean reverse) {
        assert (end >= start);
        assert (start >= 0);
        assert (batchSize > 0);
        assert (batchSizeTolerance >= 0);
        int totalElements = end - start + 1;
        int batchRangeCount = totalElements / batchSize;
        if (batchRangeCount == 0 || batchRangeCount * batchSize + batchSizeTolerance < totalElements) {
            ++batchRangeCount;
        }
        this.rangeCount = batchRangeCount;
        this.rangeDelta = batchSize - 1;
        this.nextValueDelta = reverse ? -batchSize : batchSize;
        this.firstBoundary = reverse ? end - this.rangeDelta : start;
        this.lastBoundary = reverse ? start : end;
        this.reset();
    }

    public boolean hasNext() {
        return this.rangeIndex < this.rangeCount;
    }

    public void next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.rangeStart = this.rangeValue;
        this.rangeEnd = this.rangeValue + this.rangeDelta;
        this.rangeValue += this.nextValueDelta;
        if (++this.rangeIndex >= this.rangeCount) {
            if (this.nextValueDelta < 0) {
                this.rangeStart = this.lastBoundary;
            } else {
                this.rangeEnd = this.lastBoundary;
            }
        }
    }

    public int start() {
        return this.rangeStart;
    }

    public int end() {
        return this.rangeEnd;
    }

    public BatchRangeHelper reset() {
        this.rangeValue = this.firstBoundary;
        this.rangeIndex = 0;
        return this;
    }

    public int[] toArray() {
        int[] rv = new int[this.rangeCount * 2];
        this.reset();
        int i = 0;
        while (this.hasNext()) {
            this.next();
            rv[i++] = this.start();
            rv[i++] = this.end();
        }
        this.reset();
        return rv;
    }

    public static void main(String[] args) {
        System.out.println("With remainder within tolerance");
        System.out.println(Arrays.toString(new BatchRangeHelper(0, 102, 10, 4, false).toArray()));
        System.out.println(Arrays.toString(new BatchRangeHelper(0, 102, 10, 4, true).toArray()));
        System.out.println("With remainder out of tolerance");
        System.out.println(Arrays.toString(new BatchRangeHelper(0, 102, 10, 2, false).toArray()));
        System.out.println(Arrays.toString(new BatchRangeHelper(0, 102, 10, 2, true).toArray()));
        System.out.println("Range smaller than batch");
        System.out.println(Arrays.toString(new BatchRangeHelper(1, 9, 10, false).toArray()));
        System.out.println(Arrays.toString(new BatchRangeHelper(1, 9, 10, true).toArray()));
        System.out.println("Range smaller than batch and smaller than tolerance");
        System.out.println(Arrays.toString(new BatchRangeHelper(1, 9, 10, 20, false).toArray()));
        System.out.println(Arrays.toString(new BatchRangeHelper(1, 9, 10, 20, true).toArray()));
        System.out.println("Zero tolerance");
        System.out.println(Arrays.toString(new BatchRangeHelper(0, 100, 10, 0, false).toArray()));
        System.out.println(Arrays.toString(new BatchRangeHelper(0, 100, 10, 0, true).toArray()));
        System.out.println("Right to boundary");
        System.out.println(Arrays.toString(new BatchRangeHelper(1, 100, 10, false).toArray()));
        System.out.println(Arrays.toString(new BatchRangeHelper(1, 100, 10, true).toArray()));
    }
}

