/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.tmatesoft.hg.core.HgBlameInspector;
import org.tmatesoft.hg.core.HgCallbackTargetException;
import org.tmatesoft.hg.core.HgIterateDirection;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.ByteArrayChannel;
import org.tmatesoft.hg.internal.DiffHelper;
import org.tmatesoft.hg.internal.FileHistory;
import org.tmatesoft.hg.internal.FileRevisionHistoryChunk;
import org.tmatesoft.hg.internal.IntSliceSeq;
import org.tmatesoft.hg.internal.IntTuple;
import org.tmatesoft.hg.internal.IntVector;
import org.tmatesoft.hg.internal.RangePairSeq;
import org.tmatesoft.hg.internal.diff.DiffRangeMap;
import org.tmatesoft.hg.repo.HgChangelog;
import org.tmatesoft.hg.repo.HgDataFile;
import org.tmatesoft.hg.repo.HgInvalidStateException;
import org.tmatesoft.hg.repo.HgParentChildMap;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRevisionMap;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.Adaptable;
import org.tmatesoft.hg.util.CancelledException;
import org.tmatesoft.hg.util.Pair;

public class BlameHelper {
    private final HgBlameInspector insp;
    private FileLinesCache linesCache;
    private HgParentChildMap<HgChangelog> clogMap;
    private static final boolean useNewStrategy = Boolean.TRUE;

    public BlameHelper(HgBlameInspector inspector) {
        this.insp = inspector;
    }

    public FileHistory prepare(HgDataFile df, int clogRevIndexStart, int clogRevIndexEnd) throws HgRuntimeException {
        assert (clogRevIndexStart <= clogRevIndexEnd);
        FileHistory fileHistory = new FileHistory(df, clogRevIndexStart, clogRevIndexEnd);
        fileHistory.build();
        int cacheHint = 5;
        for (FileRevisionHistoryChunk c : fileHistory.iterate(HgIterateDirection.OldToNew)) {
            if (c.revisionCount() <= cacheHint) continue;
            cacheHint = c.revisionCount();
        }
        this.linesCache = new FileLinesCache(cacheHint);
        for (FileRevisionHistoryChunk fhc : fileHistory.iterate(HgIterateDirection.OldToNew)) {
            this.linesCache.useFileUpTo(fhc.getFile(), fhc.getEndChangeset());
        }
        return fileHistory;
    }

    public void diff(int fileRevIndex1, int clogRevIndex1, int fileRevIndex2, int clogRevIndex2) throws HgCallbackTargetException, HgRuntimeException {
        HgDataFile targetFile = this.linesCache.getFile(clogRevIndex2);
        DiffHelper.LineSequence c1 = this.linesCache.lines(clogRevIndex1, fileRevIndex1);
        DiffHelper.LineSequence c2 = this.linesCache.lines(clogRevIndex2, fileRevIndex2);
        DiffHelper<DiffHelper.LineSequence> pg = new DiffHelper<DiffHelper.LineSequence>();
        pg.init(c1, c2);
        BlameBlockInspector bbi = new BlameBlockInspector(targetFile, fileRevIndex2, this.insp, clogRevIndex1, clogRevIndex2);
        pg.findMatchingBlocks(bbi);
        bbi.checkErrors();
    }

    public void annotateChange(int fileRevIndex, int csetRevIndex, int[] fileParentRevs, int[] fileParentClogRevs) throws HgCallbackTargetException, HgRuntimeException {
        HgDataFile targetFile = this.linesCache.getFile(csetRevIndex);
        DiffHelper.LineSequence fileRevLines = this.linesCache.lines(csetRevIndex, fileRevIndex);
        if (fileParentClogRevs[0] != -1 && fileParentClogRevs[1] != -1) {
            int p1ClogIndex = fileParentClogRevs[0];
            int p2ClogIndex = fileParentClogRevs[1];
            DiffHelper.LineSequence p1Lines = this.linesCache.lines(p1ClogIndex, fileParentRevs[0]);
            DiffHelper.LineSequence p2Lines = this.linesCache.lines(p2ClogIndex, fileParentRevs[1]);
            MergeResolutionStrategy mergeResolver = this.createMergeStrategy(fileRevLines, p1Lines, p2Lines, csetRevIndex, fileParentClogRevs);
            DiffHelper<DiffHelper.LineSequence> pg = new DiffHelper<DiffHelper.LineSequence>();
            pg.init(p1Lines, fileRevLines);
            BlameBlockInspector bbi = new BlameBlockInspector(targetFile, fileRevIndex, this.insp, p1ClogIndex, csetRevIndex);
            bbi.setMergeParent2(mergeResolver, p2ClogIndex);
            pg.findMatchingBlocks(bbi);
            bbi.checkErrors();
        } else if (fileParentClogRevs[0] == fileParentClogRevs[1]) {
            assert (fileParentClogRevs[0] == -1);
            BlameBlockInspector bbi = new BlameBlockInspector(targetFile, fileRevIndex, this.insp, -1, csetRevIndex);
            bbi.begin(DiffHelper.LineSequence.newlines(new byte[0]), fileRevLines);
            bbi.match(0, fileRevLines.chunkCount() - 1, 0);
            bbi.end();
            bbi.checkErrors();
        } else {
            int soleParentIndex;
            int n = soleParentIndex = fileParentClogRevs[0] == -1 ? 1 : 0;
            assert (fileParentClogRevs[soleParentIndex] != -1);
            DiffHelper.LineSequence parentLines = this.linesCache.lines(fileParentClogRevs[soleParentIndex], fileParentRevs[soleParentIndex]);
            DiffHelper<DiffHelper.LineSequence> pg = new DiffHelper<DiffHelper.LineSequence>();
            pg.init(parentLines, fileRevLines);
            BlameBlockInspector bbi = new BlameBlockInspector(targetFile, fileRevIndex, this.insp, fileParentClogRevs[soleParentIndex], csetRevIndex);
            pg.findMatchingBlocks(bbi);
            bbi.checkErrors();
        }
    }

    private MergeResolutionStrategy createMergeStrategy(DiffHelper.LineSequence fileRevLines, DiffHelper.LineSequence p1Lines, DiffHelper.LineSequence p2Lines, int csetRevIndex, int[] fileParentClogRevs) {
        DiffHelper<DiffHelper.LineSequence> pg = new DiffHelper<DiffHelper.LineSequence>();
        if (useNewStrategy) {
            final ArrayList<RangePairSeq> allMatches = new ArrayList<RangePairSeq>();
            pg.init(p2Lines, fileRevLines);
            pg.findAllMatchAlternatives(new DiffHelper.MatchInspector<DiffHelper.LineSequence>(){
                private RangePairSeq matches;

                @Override
                public void begin(DiffHelper.LineSequence s1, DiffHelper.LineSequence s2) {
                    this.matches = new RangePairSeq();
                }

                @Override
                public void match(int startSeq1, int startSeq2, int matchLength) {
                    this.matches.add(startSeq1, startSeq2, matchLength);
                }

                @Override
                public void end() {
                    if (this.matches.size() > 0) {
                        allMatches.add(this.matches);
                    }
                }
            });
            DiffHelper.LineSequence baseLines = this.getBaseRevisionLines(csetRevIndex, fileParentClogRevs);
            pg.init(p1Lines, baseLines);
            DiffRangeMap p1ToBase = new DiffRangeMap().fill(pg);
            pg.init(baseLines, p2Lines);
            DiffRangeMap baseToP2 = new DiffRangeMap().fill(pg);
            return new MergeStrategy2(allMatches, p1ToBase, baseToP2);
        }
        pg.init(p2Lines, fileRevLines);
        EqualBlocksCollector p2MergeCommon = new EqualBlocksCollector();
        pg.findMatchingBlocks(p2MergeCommon);
        return new MergeStrategy1(p2MergeCommon.matches);
    }

    private DiffHelper.LineSequence getBaseRevisionLines(int clogRevIndex, int[] fileParentClogRevs) {
        assert (fileParentClogRevs[0] >= 0);
        assert (fileParentClogRevs[1] >= 0);
        HgDataFile targetFile = this.linesCache.getFile(clogRevIndex);
        HgRepository repo = targetFile.getRepo();
        if (this.clogMap == null) {
            this.clogMap = new HgParentChildMap<HgChangelog>(repo.getChangelog());
            this.clogMap.init();
        }
        HgRevisionMap<HgChangelog> m = this.clogMap.getRevisionMap();
        Nodeid ancestor = this.clogMap.ancestor(m.revision(fileParentClogRevs[0]), m.revision(fileParentClogRevs[1]));
        int ancestorRevIndex = m.revisionIndex(ancestor);
        Nodeid fr = repo.getManifest().getFileRevision(ancestorRevIndex, targetFile.getPath());
        if (fr == null) {
            return DiffHelper.LineSequence.newlines(new byte[0]);
        }
        return this.linesCache.lines(ancestorRevIndex, targetFile.getRevisionIndex(fr));
    }

    public static void main(String[] args) {
        EqualBlocksCollector bc = new EqualBlocksCollector();
        bc.match(-1, 5, 3);
        bc.match(-1, 10, 2);
        bc.match(-1, 15, 3);
        bc.match(-1, 20, 3);
        IntVector r = new IntVector();
        bc.intersectWithTarget(7, 10, r);
        int i = 0;
        while (i < r.size()) {
            System.out.printf("[%d..%d) ", r.get(i), r.get(i) + r.get(i + 1));
            i += 2;
        }
        System.out.println();
        MergeStrategy1 ms = new MergeStrategy1(bc.matches);
        IntSliceSeq mr = ms.doCombine(0, 16, 508, 514);
        for (IntTuple t : mr) {
            System.out.printf("%d:[%d..%d)  ", t.at(0), t.at(1), t.at(1) + t.at(2));
        }
        System.out.println();
        System.out.println();
        DiffRangeMap m1 = new DiffRangeMap();
        m1.match(0, 0, 1);
        m1.match(7, 3, 0);
        DiffRangeMap m2 = new DiffRangeMap();
        m2.match(0, 0, 1);
        m2.match(3, 3, 0);
        RangePairSeq eq1 = new RangePairSeq();
        eq1.add(0, 0, 3);
        RangePairSeq eq2 = new RangePairSeq();
        eq2.add(0, 4, 3);
        MergeStrategy2 ms2 = new MergeStrategy2(Arrays.asList(eq1, eq2), m1, m2);
        mr = ms2.combineAndMarkRangesWithSource(5, 7, 5, 7, 33, 44);
        for (IntTuple t : mr) {
            System.out.printf("%d:[%d..%d)  ", t.at(0), t.at(1), t.at(1) + t.at(2));
        }
    }

    private static class AnnotateRev
    implements HgBlameInspector.RevisionDescriptor {
        public ContentBlock origin;
        public ContentBlock target;
        public int originCset;
        public int targetCset;
        public int mergeCset;
        public int fileRevIndex;
        public HgDataFile df;

        private AnnotateRev() {
        }

        public void set(HgDataFile file, int fileRev) {
            this.df = file;
            this.fileRevIndex = fileRev;
        }

        public void set(ContentBlock o, ContentBlock t) {
            this.origin = o;
            this.target = t;
        }

        public void set(int o, int t, int m) {
            this.originCset = o;
            this.targetCset = t;
            this.mergeCset = m;
        }

        @Override
        public HgBlameInspector.BlockData origin() {
            return this.origin;
        }

        @Override
        public HgBlameInspector.BlockData target() {
            return this.target;
        }

        @Override
        public int originChangesetIndex() {
            return this.originCset;
        }

        @Override
        public int targetChangesetIndex() {
            return this.targetCset;
        }

        @Override
        public boolean isMerge() {
            return this.mergeCset != -1;
        }

        @Override
        public int mergeChangesetIndex() {
            return this.mergeCset;
        }

        @Override
        public int fileRevisionIndex() {
            return this.fileRevIndex;
        }

        @Override
        public HgDataFile file() {
            return this.df;
        }

        public String toString() {
            if (this.isMerge()) {
                return String.format("[%d,%d->%d]", this.originCset, this.mergeCset, this.targetCset);
            }
            return String.format("[%d->%d]", this.originCset, this.targetCset);
        }
    }

    private static class BlameBlockInspector
    extends DiffHelper.DeltaInspector<DiffHelper.LineSequence> {
        private final HgBlameInspector insp;
        private final int csetOrigin;
        private final int csetTarget;
        private MergeResolutionStrategy p2MergeCommon;
        private int csetMergeParent;
        private final AnnotateRev annotatedRevision;
        private HgCallbackTargetException error;

        public BlameBlockInspector(HgDataFile df, int fileRevIndex, HgBlameInspector inspector, int originCset, int targetCset) {
            assert (inspector != null);
            this.insp = inspector;
            this.annotatedRevision = new AnnotateRev();
            this.annotatedRevision.set(df, fileRevIndex);
            this.csetOrigin = originCset;
            this.csetTarget = targetCset;
        }

        public void setMergeParent2(MergeResolutionStrategy p2MergeStrategy, int parentCset2) {
            this.p2MergeCommon = p2MergeStrategy;
            this.csetMergeParent = parentCset2;
        }

        @Override
        public void begin(DiffHelper.LineSequence s1, DiffHelper.LineSequence s2) {
            super.begin(s1, s2);
            if (this.shallStop()) {
                return;
            }
            ContentBlock originContent = new ContentBlock(s1);
            ContentBlock targetContent = new ContentBlock(s2);
            this.annotatedRevision.set(originContent, targetContent);
            this.annotatedRevision.set(this.csetOrigin, this.csetTarget, this.p2MergeCommon != null ? this.csetMergeParent : -1);
            HgBlameInspector.RevisionDescriptor.Recipient curious = Adaptable.Factory.getAdapter(this.insp, HgBlameInspector.RevisionDescriptor.Recipient.class, null);
            if (curious != null) {
                try {
                    curious.start(this.annotatedRevision);
                }
                catch (HgCallbackTargetException ex) {
                    this.error = ex;
                }
            }
        }

        @Override
        public void end() {
            super.end();
            if (this.shallStop()) {
                return;
            }
            HgBlameInspector.RevisionDescriptor.Recipient curious = Adaptable.Factory.getAdapter(this.insp, HgBlameInspector.RevisionDescriptor.Recipient.class, null);
            if (curious != null) {
                try {
                    curious.done(this.annotatedRevision);
                }
                catch (HgCallbackTargetException ex) {
                    this.error = ex;
                }
            }
            this.p2MergeCommon = null;
        }

        @Override
        protected void changed(int s1From, int s1To, int s2From, int s2To) {
            if (this.shallStop()) {
                return;
            }
            try {
                if (this.p2MergeCommon != null) {
                    IntSliceSeq mergeRanges = this.p2MergeCommon.combineAndMarkRangesWithSource(s1From, s1To, s2From, s2To, this.csetOrigin, this.csetMergeParent);
                    int s1TotalLines = s1To - s1From;
                    int s1ConsumedLines = 0;
                    int s1Start = s1From;
                    Iterator<IntTuple> it = mergeRanges.iterator();
                    while (it.hasNext()) {
                        int s1LinesToBorrow;
                        IntTuple mergeRange = it.next();
                        int rangeOrigin = mergeRange.at(0);
                        int rangeStart = mergeRange.at(1);
                        int rangeLen = mergeRange.at(2);
                        boolean lastRange = it.hasNext();
                        int s1LinesLeft = s1TotalLines - s1ConsumedLines;
                        int n = s1LinesToBorrow = lastRange ? s1LinesLeft : Math.min(s1LinesLeft, rangeLen);
                        if (rangeOrigin != this.csetMergeParent && s1LinesToBorrow > 0) {
                            ChangeBlockImpl block = this.getChangeBlock(s1Start, s1LinesToBorrow, rangeStart, rangeLen);
                            block.setOriginAndTarget(rangeOrigin, this.csetTarget);
                            this.insp.changed(block);
                            s1ConsumedLines += s1LinesToBorrow;
                            s1Start += s1LinesToBorrow;
                            continue;
                        }
                        int blockInsPoint = rangeOrigin != this.csetMergeParent ? s1Start : this.p2MergeCommon.getLineInP2(rangeStart);
                        ChangeBlockImpl block = this.getAddBlock(rangeStart, rangeLen, blockInsPoint);
                        block.setOriginAndTarget(rangeOrigin, this.csetTarget);
                        this.insp.added(block);
                    }
                    if (s1ConsumedLines != s1TotalLines) {
                        assert (s1ConsumedLines < s1TotalLines) : String.format("Expected to process %d lines, but actually was %d", s1TotalLines, s1ConsumedLines);
                        int s2DeletePoint = s2From + s1ConsumedLines;
                        ChangeBlockImpl block = new ChangeBlockImpl(this.annotatedRevision.origin, null, s1Start, s1To - s1Start, -1, -1, -1, s2DeletePoint);
                        block.setOriginAndTarget(this.csetOrigin, this.csetTarget);
                        this.insp.deleted(block);
                    }
                } else {
                    ChangeBlockImpl block = this.getChangeBlock(s1From, s1To - s1From, s2From, s2To - s2From);
                    block.setOriginAndTarget(this.csetOrigin, this.csetTarget);
                    this.insp.changed(block);
                }
            }
            catch (HgCallbackTargetException ex) {
                this.error = ex;
            }
        }

        @Override
        protected void added(int s1InsertPoint, int s2From, int s2To) {
            if (this.shallStop()) {
                return;
            }
            try {
                if (this.p2MergeCommon != null) {
                    IntSliceSeq mergeRanges = this.p2MergeCommon.combineAndMarkRangesWithSource(s1InsertPoint, s2From, s2To, this.csetOrigin, this.csetMergeParent);
                    int insPoint = s1InsertPoint;
                    for (IntTuple mergeRange : mergeRanges) {
                        int rangeOrigin = mergeRange.at(0);
                        int rangeStart = mergeRange.at(1);
                        int rangeLen = mergeRange.at(2);
                        ChangeBlockImpl block = this.getAddBlock(rangeStart, rangeLen, insPoint);
                        block.setOriginAndTarget(rangeOrigin, this.csetTarget);
                        this.insp.added(block);
                        insPoint += rangeLen;
                    }
                } else {
                    ChangeBlockImpl block = this.getAddBlock(s2From, s2To - s2From, s1InsertPoint);
                    block.setOriginAndTarget(this.csetOrigin, this.csetTarget);
                    this.insp.added(block);
                }
            }
            catch (HgCallbackTargetException ex) {
                this.error = ex;
            }
        }

        @Override
        protected void deleted(int s2DeletePoint, int s1From, int s1To) {
            if (this.shallStop()) {
                return;
            }
            try {
                ChangeBlockImpl block = new ChangeBlockImpl(this.annotatedRevision.origin, null, s1From, s1To - s1From, -1, -1, -1, s2DeletePoint);
                block.setOriginAndTarget(this.csetOrigin, this.csetTarget);
                this.insp.deleted(block);
            }
            catch (HgCallbackTargetException ex) {
                this.error = ex;
            }
        }

        @Override
        protected void unchanged(int s1From, int s2From, int length) {
            if (this.shallStop()) {
                return;
            }
            try {
                EqualBlockImpl block = new EqualBlockImpl(s1From, s2From, length, this.annotatedRevision.target);
                block.setOriginAndTarget(this.csetOrigin, this.csetTarget);
                this.insp.same(block);
            }
            catch (HgCallbackTargetException ex) {
                this.error = ex;
            }
        }

        void checkErrors() throws HgCallbackTargetException {
            if (this.error != null) {
                throw this.error;
            }
        }

        private boolean shallStop() {
            return this.error != null;
        }

        private ChangeBlockImpl getAddBlock(int start, int len, int insPoint) {
            return new ChangeBlockImpl(null, this.annotatedRevision.target, -1, -1, start, len, insPoint, -1);
        }

        private ChangeBlockImpl getChangeBlock(int start1, int len1, int start2, int len2) {
            return new ChangeBlockImpl(this.annotatedRevision.origin, this.annotatedRevision.target, start1, len1, start2, len2, start1, start2);
        }
    }

    private static class BlockImpl
    implements HgBlameInspector.Block {
        private int originCset;
        private int targetCset;

        private BlockImpl() {
        }

        void setOriginAndTarget(int originChangesetIndex, int targetChangesetIndex) {
            this.originCset = originChangesetIndex;
            this.targetCset = targetChangesetIndex;
        }

        @Override
        public int originChangesetIndex() {
            return this.originCset;
        }

        @Override
        public int targetChangesetIndex() {
            return this.targetCset;
        }
    }

    private static class ChangeBlockImpl
    extends BlockImpl
    implements HgBlameInspector.ChangeBlock {
        private final ContentBlock oldContent;
        private final ContentBlock newContent;
        private final int s1Start;
        private final int s1Len;
        private final int s2Start;
        private final int s2Len;
        private final int s1InsertPoint;
        private final int s2DeletePoint;
        private FilterBlock addedBlock;
        private FilterBlock removedBlock;

        public ChangeBlockImpl(ContentBlock c1, ContentBlock c2, int s1Start, int s1Len, int s2Start, int s2Len, int s1InsertPoint, int s2DeletePoint) {
            this.oldContent = c1;
            this.newContent = c2;
            this.s1Start = s1Start;
            this.s1Len = s1Len;
            this.s2Start = s2Start;
            this.s2Len = s2Len;
            this.s1InsertPoint = s1InsertPoint;
            this.s2DeletePoint = s2DeletePoint;
        }

        @Override
        public int insertedAt() {
            return this.s1InsertPoint;
        }

        @Override
        public int firstAddedLine() {
            return this.s2Start;
        }

        @Override
        public int totalAddedLines() {
            return this.s2Len;
        }

        @Override
        public HgBlameInspector.BlockData addedLines() {
            if (this.addedBlock == null) {
                this.addedBlock = new FilterBlock(this.newContent, this.firstAddedLine(), this.totalAddedLines());
            }
            return this.addedBlock;
        }

        @Override
        public int removedAt() {
            return this.s2DeletePoint;
        }

        @Override
        public int firstRemovedLine() {
            return this.s1Start;
        }

        @Override
        public int totalRemovedLines() {
            return this.s1Len;
        }

        @Override
        public HgBlameInspector.BlockData removedLines() {
            if (this.removedBlock == null) {
                this.removedBlock = new FilterBlock(this.oldContent, this.firstRemovedLine(), this.totalRemovedLines());
            }
            return this.removedBlock;
        }

        public String toString() {
            if (this.s2DeletePoint == -1) {
                return String.format("@@ -%d,0 +%d,%d @@", this.insertedAt(), this.firstAddedLine(), this.totalAddedLines());
            }
            if (this.s1InsertPoint == -1) {
                return String.format("@@ -%d,%d +%d,0 @@", this.firstRemovedLine(), this.totalRemovedLines(), this.removedAt());
            }
            return String.format("@@ -%d,%d +%d,%d @@", this.firstRemovedLine(), this.totalRemovedLines(), this.firstAddedLine(), this.totalAddedLines());
        }
    }

    private static class ContentBlock
    implements HgBlameInspector.BlockData {
        private final DiffHelper.LineSequence seq;

        public ContentBlock(DiffHelper.LineSequence sequence) {
            this.seq = sequence;
        }

        @Override
        public HgBlameInspector.BlockData elementAt(int index) {
            return new SingleLine(this.seq.chunk(index));
        }

        @Override
        public int elementCount() {
            return this.seq.chunkCount() - 1;
        }

        @Override
        public byte[] asArray() {
            return this.seq.data(0, this.seq.chunkCount() - 1);
        }
    }

    private static class EqualBlockImpl
    extends BlockImpl
    implements HgBlameInspector.EqualBlock {
        private final int start1;
        private final int start2;
        private final int length;
        private final ContentBlock fullContent;
        private FilterBlock myContent;

        EqualBlockImpl(int blockStartSeq1, int blockStartSeq2, int blockLength, ContentBlock targetContent) {
            this.start1 = blockStartSeq1;
            this.start2 = blockStartSeq2;
            this.length = blockLength;
            this.fullContent = targetContent;
        }

        @Override
        public int originStart() {
            return this.start1;
        }

        @Override
        public int targetStart() {
            return this.start2;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public HgBlameInspector.BlockData content() {
            if (this.myContent == null) {
                this.myContent = new FilterBlock(this.fullContent, this.start2, this.length);
            }
            return this.myContent;
        }

        public String toString() {
            return String.format("@@ [%d..%d) == [%d..%d) @@", this.start1, this.start1 + this.length, this.start2, this.start2 + this.length);
        }
    }

    private static class EqualBlocksCollector
    implements DiffHelper.MatchInspector<DiffHelper.LineSequence> {
        private final RangePairSeq matches = new RangePairSeq();

        private EqualBlocksCollector() {
        }

        @Override
        public void begin(DiffHelper.LineSequence s1, DiffHelper.LineSequence s2) {
        }

        @Override
        public void match(int startSeq1, int startSeq2, int matchLength) {
            this.matches.add(startSeq1, startSeq2, matchLength);
        }

        @Override
        public void end() {
        }

        public void intersectWithTarget(int start, int length, IntVector result) {
            int s = start;
            int l = start;
            int x = start + length;
            while (l < x) {
                if (!this.matches.includesTargetLine(l)) {
                    if (l - s > 0) {
                        result.add(s);
                        result.add(l - s);
                    }
                    s = l + 1;
                }
                ++l;
            }
            if (s < start + length) {
                result.add(s);
                result.add(start + length - s);
            }
        }
    }

    private static class FileLinesCache {
        private final LinkedList<Pair<Integer, DiffHelper.LineSequence>> lruCache;
        private final int limit;
        private final LinkedList<Pair<Integer, HgDataFile>> files;

        public FileLinesCache(int lruLimit) {
            this.limit = lruLimit;
            this.lruCache = new LinkedList();
            this.files = new LinkedList();
        }

        public void useFileUpTo(HgDataFile df, int clogRevIndex) {
            Pair<Integer, HgDataFile> newEntry = new Pair<Integer, HgDataFile>(clogRevIndex, df);
            ListIterator<Pair<Integer, HgDataFile>> it = this.files.listIterator();
            while (it.hasNext()) {
                Pair e = (Pair)it.next();
                if ((Integer)e.first() == clogRevIndex) {
                    assert (((HgDataFile)e.second()).getPath().equals(df.getPath()));
                    return;
                }
                if ((Integer)e.first() <= clogRevIndex) continue;
                it.previous();
                it.add(newEntry);
                return;
            }
            this.files.add(newEntry);
        }

        public HgDataFile getFile(int clogRevIndex) {
            for (Pair pair : this.files) {
                if ((Integer)pair.first() < clogRevIndex) continue;
                return (HgDataFile)pair.second();
            }
            throw new HgInvalidStateException(String.format("Got %d file-changelog mappings, but no luck for revision %d.", this.files.size(), clogRevIndex));
        }

        public DiffHelper.LineSequence lines(int clogRevIndex, int fileRevIndex) throws HgRuntimeException {
            Pair<Integer, DiffHelper.LineSequence> cached = this.checkCache(clogRevIndex);
            if (cached != null) {
                return cached.second();
            }
            HgDataFile df = this.getFile(clogRevIndex);
            try {
                ByteArrayChannel c = new ByteArrayChannel();
                df.content(fileRevIndex, c);
                DiffHelper.LineSequence rv = DiffHelper.LineSequence.newlines(c.toArray());
                this.lruCache.addFirst(new Pair<Integer, DiffHelper.LineSequence>(clogRevIndex, rv));
                if (this.lruCache.size() > this.limit) {
                    this.lruCache.removeLast();
                }
                return rv;
            }
            catch (CancelledException ex) {
                HgInvalidStateException ise = new HgInvalidStateException("ByteArrayChannel never throws CancelledException");
                ise.initCause(ex);
                throw ise;
            }
        }

        private Pair<Integer, DiffHelper.LineSequence> checkCache(int fileRevIndex) {
            Pair rv = null;
            ListIterator it = this.lruCache.listIterator();
            while (it.hasNext()) {
                Pair p = (Pair)it.next();
                if ((Integer)p.first() != fileRevIndex) continue;
                rv = p;
                it.remove();
                break;
            }
            if (rv != null) {
                this.lruCache.addFirst(rv);
            }
            return rv;
        }
    }

    private static class FilterBlock
    implements HgBlameInspector.BlockData {
        private final ContentBlock contentBlock;
        private final int from;
        private final int length;

        public FilterBlock(ContentBlock bd, int startFrom, int len) {
            assert (bd != null);
            assert (startFrom + len < bd.seq.chunkCount());
            this.contentBlock = bd;
            this.from = startFrom;
            this.length = len;
        }

        @Override
        public HgBlameInspector.BlockData elementAt(int index) {
            if (index < 0 || index >= this.length) {
                throw new IllegalArgumentException(String.format("Expected value from [0..%d), got %d", this.length, index));
            }
            return this.contentBlock.elementAt(this.from + index);
        }

        @Override
        public int elementCount() {
            return this.length;
        }

        @Override
        public byte[] asArray() {
            return this.contentBlock.seq.data(this.from, this.from + this.length);
        }
    }

    static interface MergeResolutionStrategy {
        public IntSliceSeq combineAndMarkRangesWithSource(int var1, int var2, int var3, int var4, int var5, int var6);

        public IntSliceSeq combineAndMarkRangesWithSource(int var1, int var2, int var3, int var4, int var5);

        public int getLineInP2(int var1);
    }

    private static class MergeStrategy1
    implements MergeResolutionStrategy {
        private final RangePairSeq matches;
        private final IntSliceSeq mergeRanges;

        public MergeStrategy1(RangePairSeq p2EqualToM) {
            this.matches = p2EqualToM;
            this.mergeRanges = new IntSliceSeq(3, 10, 10);
        }

        private IntSliceSeq doCombine(int start, int length, int markerSource, int markerTarget) {
            this.mergeRanges.clear();
            assert (this.mergeRanges.sliceSize() == 3);
            int sourceStart = start;
            int targetStart = start;
            int sourceEnd = start + length;
            int l = sourceStart;
            while (l < sourceEnd) {
                if (this.matches.includesTargetLine(l)) {
                    if (sourceStart < l) {
                        this.mergeRanges.add(markerSource, sourceStart, l - sourceStart);
                    }
                    sourceStart = l + 1;
                } else {
                    if (targetStart < l) {
                        this.mergeRanges.add(markerTarget, targetStart, l - targetStart);
                    }
                    targetStart = l + 1;
                }
                ++l;
            }
            if (sourceStart < sourceEnd) {
                assert (targetStart == sourceEnd);
                this.mergeRanges.add(markerSource, sourceStart, sourceEnd - sourceStart);
            } else if (targetStart < sourceEnd) {
                assert (sourceStart == sourceEnd);
                this.mergeRanges.add(markerTarget, targetStart, sourceEnd - targetStart);
            }
            return this.mergeRanges;
        }

        @Override
        public int getLineInP2(int mergeLine) {
            return this.matches.reverseMapLine(mergeLine);
        }

        @Override
        public IntSliceSeq combineAndMarkRangesWithSource(int start1, int end1, int start2, int end2, int source1, int source2) {
            return this.doCombine(start2, end2 - start2, source1, source2);
        }

        @Override
        public IntSliceSeq combineAndMarkRangesWithSource(int insPoint, int start, int end, int source1, int source2) {
            return this.doCombine(start, end - start, source1, source2);
        }
    }

    private static class MergeStrategy2
    implements MergeResolutionStrategy {
        private final List<RangePairSeq> matches;
        private final IntSliceSeq mergeRanges;
        private final DiffRangeMap p1ToBase;
        private final DiffRangeMap baseToP2;

        public MergeStrategy2(List<RangePairSeq> p2EqualToM, DiffRangeMap p1ToBaseRanges, DiffRangeMap baseToP2Ranges) {
            this.matches = p2EqualToM;
            this.p1ToBase = p1ToBaseRanges;
            this.baseToP2 = baseToP2Ranges;
            this.mergeRanges = new IntSliceSeq(3, 10, 10);
        }

        @Override
        public IntSliceSeq combineAndMarkRangesWithSource(int insPoint, int start, int end, int source1, int source2) {
            return this.combineAndMarkRangesWithSource(insPoint, insPoint, start, end, source1, source2);
        }

        @Override
        public IntSliceSeq combineAndMarkRangesWithSource(int start1, int end1, int start2, int end2, int source1, int source2) {
            this.mergeRanges.clear();
            IntSliceSeq mergedLines = new IntSliceSeq(2, end2 - start2, 0);
            int i = start2;
            while (i < end2) {
                mergedLines.add(source1, 0);
                ++i;
            }
            for (DiffRangeMap.RangePair p1_b : this.p1ToBase.findInSource(start1, end1)) {
                for (DiffRangeMap.RangePair b_p2 : this.baseToP2.findInSource(p1_b.start2(), p1_b.end2())) {
                    int p2Line = b_p2.start2();
                    while (p2Line < b_p2.end2()) {
                        for (RangePairSeq eq : this.matches) {
                            int mergeLine;
                            if (!eq.includesOriginLine(p2Line) || (mergeLine = eq.mapLineIndex(p2Line)) < start2 || mergeLine >= end2) continue;
                            mergedLines.set(mergeLine - start2, source2, p2Line);
                        }
                        ++p2Line;
                    }
                }
            }
            int lineCount = 0;
            int start = start2;
            int lastSeenSource = source1;
            for (IntTuple t : mergedLines) {
                if (t.at(0) == lastSeenSource) {
                    ++lineCount;
                    continue;
                }
                if (lineCount > 0) {
                    this.mergeRanges.add(lastSeenSource, start, lineCount);
                    start += lineCount;
                }
                lineCount = 1;
                lastSeenSource = t.at(0);
            }
            if (lineCount > 0) {
                this.mergeRanges.add(lastSeenSource, start, lineCount);
            }
            return this.mergeRanges;
        }

        @Override
        public int getLineInP2(int mergeLine) {
            for (RangePairSeq eq : this.matches) {
                if (!eq.includesTargetLine(mergeLine)) continue;
                return eq.reverseMapLine(mergeLine);
            }
            return -1;
        }
    }

    private static class SingleLine
    implements HgBlameInspector.BlockData {
        private final DiffHelper.LineSequence.ByteChain line;

        public SingleLine(DiffHelper.LineSequence.ByteChain lineContent) {
            this.line = lineContent;
        }

        @Override
        public HgBlameInspector.BlockData elementAt(int index) {
            assert (false);
            return null;
        }

        @Override
        public int elementCount() {
            return 0;
        }

        @Override
        public byte[] asArray() {
            return this.line.data();
        }
    }
}

