/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.DataAccess;
import org.tmatesoft.hg.internal.DataSerializer;
import org.tmatesoft.hg.internal.EncodingHelper;
import org.tmatesoft.hg.internal.GeneratePatchInspector;
import org.tmatesoft.hg.internal.IntMap;
import org.tmatesoft.hg.internal.IntVector;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.internal.Patch;
import org.tmatesoft.hg.internal.RevlogStream;
import org.tmatesoft.hg.repo.HgChangelog;
import org.tmatesoft.hg.repo.HgDataFile;
import org.tmatesoft.hg.repo.HgInvalidControlFileException;
import org.tmatesoft.hg.repo.HgManifest;
import org.tmatesoft.hg.repo.HgRuntimeException;

public class BundleGenerator {
    private final Internals repo;

    public BundleGenerator(Internals hgRepo) {
        this.repo = hgRepo;
    }

    public File create(List<Nodeid> changesets) throws HgIOException, IOException {
        HgChangelog clog = this.repo.getRepo().getChangelog();
        final HgManifest manifest = this.repo.getRepo().getManifest();
        IntVector clogRevsVector = new IntVector(changesets.size(), 0);
        for (Nodeid n : changesets) {
            clogRevsVector.add(clog.getRevisionIndex(n));
        }
        clogRevsVector.sort(true);
        final int[] clogRevs = clogRevsVector.toArray();
        final IntMap<Nodeid> clogMap = new IntMap<Nodeid>(changesets.size());
        final IntVector manifestRevs = new IntVector(changesets.size(), 0);
        final ArrayList<HgDataFile> files = new ArrayList<HgDataFile>();
        clog.range(new HgChangelog.Inspector(){
            private Set<String> seenFiles = new HashSet<String>();

            @Override
            public void next(int revisionIndex, Nodeid nodeid, HgChangelog.RawChangeset cset) throws HgRuntimeException {
                clogMap.put(revisionIndex, nodeid);
                manifestRevs.add(manifest.getRevisionIndex(cset.manifest()));
                for (String f : cset.files()) {
                    if (this.seenFiles.contains(f)) continue;
                    this.seenFiles.add(f);
                    HgDataFile df = BundleGenerator.this.repo.getRepo().getFileNode(f);
                    files.add(df);
                }
            }
        }, clogRevs);
        manifestRevs.sort(true);
        File bundleFile = File.createTempFile("hg4j-", ".bundle");
        if (clogRevs.length == 0) {
            return bundleFile;
        }
        FileOutputStream osBundle = new FileOutputStream(bundleFile);
        DataSerializer.OutputStreamSerializer outRaw = new DataSerializer.OutputStreamSerializer(osBundle);
        outRaw.write("HG10UN".getBytes(), 0, 6);
        RevlogStream clogStream = this.repo.getImplAccess().getChangelogStream();
        new ChunkGenerator(outRaw, clogMap).iterate(clogStream, clogRevs);
        outRaw.writeInt(0);
        RevlogStream manifestStream = this.repo.getImplAccess().getManifestStream();
        new ChunkGenerator(outRaw, clogMap).iterate(manifestStream, manifestRevs.toArray(true));
        outRaw.writeInt(0);
        EncodingHelper fnEncoder = this.repo.buildFileNameEncodingHelper();
        for (HgDataFile df : BundleGenerator.sortedByName(files)) {
            RevlogStream s = this.repo.getImplAccess().getStream(df);
            final IntVector fileRevs = new IntVector();
            s.iterate(0, -3, false, new RevlogStream.Inspector(){

                @Override
                public void next(int revisionIndex, int actualLen, int baseRevision, int linkRevision, int parent1Revision, int parent2Revision, byte[] nodeid, DataAccess data) throws HgRuntimeException {
                    if (Arrays.binarySearch(clogRevs, linkRevision) >= 0) {
                        fileRevs.add(revisionIndex);
                    }
                }
            });
            fileRevs.sort(true);
            if (fileRevs.isEmpty()) continue;
            byte[] fnameBytes = fnEncoder.toBundle(df.getPath());
            outRaw.writeInt(fnameBytes.length + 4);
            outRaw.writeByte(fnameBytes);
            new ChunkGenerator(outRaw, clogMap).iterate(s, fileRevs.toArray(true));
            outRaw.writeInt(0);
        }
        outRaw.writeInt(0);
        outRaw.done();
        osBundle.flush();
        osBundle.close();
        return bundleFile;
    }

    private static Collection<HgDataFile> sortedByName(List<HgDataFile> files) {
        Collections.sort(files, new Comparator<HgDataFile>(){

            @Override
            public int compare(HgDataFile o1, HgDataFile o2) {
                return o1.getPath().compareTo(o2.getPath());
            }
        });
        return files;
    }

    private static class ChunkGenerator
    implements RevlogStream.Inspector {
        private final DataSerializer ds;
        private final IntMap<Nodeid> parentMap;
        private final IntMap<Nodeid> clogMap;
        private byte[] prevContent;
        private int startParent;

        public ChunkGenerator(DataSerializer dataSerializer, IntMap<Nodeid> clogNodeidMap) {
            this.ds = dataSerializer;
            this.parentMap = new IntMap(clogNodeidMap.size());
            this.clogMap = clogNodeidMap;
        }

        public void iterate(RevlogStream s, int[] revisions) throws HgRuntimeException {
            int[] revs2read;
            int[] p = s.parents(revisions[0], new int[2]);
            this.startParent = p[0];
            if (this.startParent == -1) {
                revs2read = revisions;
                this.prevContent = new byte[0];
            } else {
                revs2read = new int[revisions.length + 1];
                revs2read[0] = this.startParent;
                System.arraycopy(revisions, 0, revs2read, 1, revisions.length);
            }
            this.fillMissingParentsMap(s, revisions);
            s.iterate(revs2read, true, this);
        }

        private void fillMissingParentsMap(RevlogStream s, int[] revisions) throws HgRuntimeException {
            int[] p = new int[2];
            int i = 1;
            while (i < revisions.length) {
                s.parents(revisions[i], p);
                if (p[0] != -1 && Arrays.binarySearch(revisions, p[0]) < 0) {
                    this.parentMap.put(p[0], Nodeid.fromBinary(s.nodeid(p[0]), 0));
                }
                if (p[1] != -1 && Arrays.binarySearch(revisions, p[1]) < 0) {
                    this.parentMap.put(p[1], Nodeid.fromBinary(s.nodeid(p[1]), 0));
                }
                ++i;
            }
        }

        @Override
        public void next(int revisionIndex, int actualLen, int baseRevision, int linkRevision, int parent1Revision, int parent2Revision, byte[] nodeid, DataAccess data) throws HgRuntimeException {
            try {
                this.parentMap.put(revisionIndex, Nodeid.fromBinary(nodeid, 0));
                byte[] nextContent = data.byteArray();
                data.done();
                if (revisionIndex == this.startParent) {
                    this.prevContent = nextContent;
                    return;
                }
                Patch p = GeneratePatchInspector.delta(this.prevContent, nextContent);
                this.prevContent = nextContent;
                nextContent = null;
                Patch.PatchDataSource pds = new Patch.PatchDataSource(p);
                int len = pds.serializeLength() + 84;
                this.ds.writeInt(len);
                this.ds.write(nodeid, 0, 20);
                if (parent1Revision != -1) {
                    this.ds.writeByte(this.parentMap.get(parent1Revision).toByteArray());
                } else {
                    this.ds.writeByte(Nodeid.NULL.toByteArray());
                }
                if (parent2Revision != -1) {
                    this.ds.writeByte(this.parentMap.get(parent2Revision).toByteArray());
                } else {
                    this.ds.writeByte(Nodeid.NULL.toByteArray());
                }
                this.ds.writeByte(this.clogMap.get(linkRevision).toByteArray());
                pds.serialize(this.ds);
            }
            catch (IOException ex) {
                throw new HgInvalidControlFileException(ex.getMessage(), ex, null);
            }
            catch (HgIOException ex) {
                throw new HgInvalidControlFileException(ex, true);
            }
        }
    }
}

