/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.core.SessionContext;
import org.tmatesoft.hg.internal.DataSerializer;
import org.tmatesoft.hg.internal.FileUtils;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.repo.HgBundle;
import org.tmatesoft.hg.repo.HgInternals;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.LogFacility;

public class BundleSerializer
implements DataSerializer.DataSource {
    private final LogFacility log;
    private final File bundleFile;

    public static BundleSerializer newInstance(SessionContext ctx, HgBundle bundle) {
        return new BundleSerializer(ctx.getLog(), HgInternals.getBundleFile(bundle));
    }

    public BundleSerializer(LogFacility logFacility, File bundleFile) {
        this.log = logFacility;
        this.bundleFile = bundleFile;
    }

    @Override
    public void serialize(DataSerializer out) throws HgIOException, HgRuntimeException {
        FileInputStream fis = null;
        try {
            try {
                int r;
                fis = new FileInputStream(this.bundleFile);
                byte[] buffer = new byte[8192];
                while ((r = fis.read(buffer, 0, buffer.length)) > 0) {
                    out.write(buffer, 0, r);
                }
            }
            catch (IOException iOException) {
                throw new HgIOException("Failed to serialize bundle", this.bundleFile);
            }
        }
        finally {
            new FileUtils(this.log, this).closeQuietly(fis, this.bundleFile);
        }
    }

    @Override
    public int serializeLength() throws HgRuntimeException {
        return Internals.ltoi(this.bundleFile.length());
    }
}

