/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.hg.util.ByteChannel;

public class ByteArrayChannel
implements ByteChannel {
    private final List<ByteBuffer> buffers;
    private ByteBuffer target;
    private byte[] result;

    public ByteArrayChannel() {
        this(-1);
    }

    public ByteArrayChannel(int size) {
        if (size == -1) {
            this.buffers = new LinkedList<ByteBuffer>();
        } else {
            if (size < 0) {
                throw new IllegalArgumentException(String.valueOf(size));
            }
            this.buffers = null;
            this.target = ByteBuffer.allocate(size);
        }
    }

    @Override
    public int write(ByteBuffer buffer) {
        int rv = buffer.remaining();
        if (this.buffers == null) {
            this.target.put(buffer);
        } else {
            ByteBuffer copy = ByteBuffer.allocate(rv);
            copy.put(buffer);
            this.buffers.add(copy);
        }
        this.result = null;
        return rv;
    }

    public byte[] toArray() {
        if (this.result != null) {
            return this.result;
        }
        if (this.buffers == null) {
            assert (this.target.hasArray());
            return this.target.array();
        }
        int total = 0;
        for (ByteBuffer bb : this.buffers) {
            bb.flip();
            total += bb.limit();
        }
        this.result = new byte[total];
        int off = 0;
        for (ByteBuffer bb : this.buffers) {
            bb.get(this.result, off, bb.limit());
            off += bb.limit();
        }
        return this.result;
    }
}

