/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.IOException;
import org.tmatesoft.hg.internal.DataAccess;

public class ByteArrayDataAccess
extends DataAccess {
    private final byte[] data;
    private final int offset;
    private final int length;
    private int pos;

    public ByteArrayDataAccess(byte[] data) {
        this(data, 0, data.length);
    }

    public ByteArrayDataAccess(byte[] data, int offset, int length) {
        this.data = data;
        this.offset = offset;
        this.length = length;
        this.pos = 0;
    }

    @Override
    public byte readByte() throws IOException {
        if (this.pos >= this.length) {
            throw new IOException();
        }
        return this.data[this.offset + this.pos++];
    }

    @Override
    public void readBytes(byte[] buf, int off, int len) throws IOException {
        if (len > this.length - this.pos) {
            throw new IOException(String.format("Requested %d bytes at position %d of %d total", len, this.pos, this.length));
        }
        System.arraycopy(this.data, this.offset + this.pos, buf, off, len);
        this.pos += len;
    }

    @Override
    public int readInt() throws IOException {
        if (this.length - this.pos < 4) {
            throw new IOException();
        }
        int x = this.offset + this.pos;
        int rv = this.data[x++] << 24 | (this.data[x++] & 0xFF) << 16 | (this.data[x++] & 0xFF) << 8 | this.data[x] & 0xFF;
        this.pos += 4;
        return rv;
    }

    @Override
    public long readLong() throws IOException {
        if (this.length - this.pos < 8) {
            throw new IOException();
        }
        int x = this.offset + this.pos;
        int i1 = this.data[x++] << 24 | (this.data[x++] & 0xFF) << 16 | (this.data[x++] & 0xFF) << 8 | this.data[x++] & 0xFF;
        int i2 = this.data[x++] << 24 | (this.data[x++] & 0xFF) << 16 | (this.data[x++] & 0xFF) << 8 | this.data[x] & 0xFF;
        this.pos += 8;
        return (long)i1 << 32 | (long)i2 & 0xFFFFFFFFL;
    }

    @Override
    public ByteArrayDataAccess reset() {
        this.pos = 0;
        return this;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public void seek(int offset) {
        this.pos = offset;
    }

    @Override
    public void skip(int bytes) {
        this.seek(this.pos + bytes);
    }

    @Override
    public boolean isEmpty() {
        return this.pos >= this.length;
    }

    @Override
    public byte[] byteArray() {
        return this.data;
    }
}

