/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

public class ByteVector {
    private byte[] data;
    private int count;
    private final int increment;

    public ByteVector(int initialSize, int increment) {
        this.data = new byte[initialSize];
        this.increment = increment;
    }

    public void add(int b) {
        if (this.count == this.data.length) {
            byte[] newData = new byte[this.count + this.increment];
            System.arraycopy(this.data, 0, newData, 0, this.count);
            this.data = newData;
        }
        this.data[this.count++] = (byte)b;
    }

    public int size() {
        return this.count;
    }

    public void clear() {
        this.count = 0;
    }

    public boolean equalsTo(byte[] array) {
        if (array == null || array.length != this.count) {
            return false;
        }
        int i = 0;
        while (i < this.count) {
            if (this.data[i] != array[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void copyTo(byte[] destination) {
        if (destination == null || destination.length < this.count) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(this.data, 0, destination, 0, this.count);
    }

    public byte[] toByteArray() {
        byte[] rv = new byte[this.count];
        this.copyTo(rv);
        return rv;
    }
}

