/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.core.SessionContext;
import org.tmatesoft.hg.internal.FileUtils;
import org.tmatesoft.hg.internal.Transaction;
import org.tmatesoft.hg.repo.HgInvalidStateException;

public final class COWTransaction
extends Transaction {
    private final FileUtils fileHelper;
    private final List<RollbackEntry> entries = new LinkedList<RollbackEntry>();

    public COWTransaction(SessionContext.Source ctxSource) {
        this.fileHelper = new FileUtils(ctxSource.getSessionContext().getLog(), this);
    }

    @Override
    public File prepare(File f) throws HgIOException {
        if (this.known(f)) {
            return f;
        }
        if (!f.exists()) {
            return this.recordNonExistent(f);
        }
        File parentDir = f.getParentFile();
        assert (parentDir.canWrite());
        File copy = new File(parentDir, String.valueOf(f.getName()) + ".hg4j.copy");
        this.fileHelper.copy(f, copy);
        long lm = f.lastModified();
        copy.setLastModified(lm);
        File backup = new File(parentDir, String.valueOf(f.getName()) + ".hg4j.orig");
        if (backup.exists()) {
            backup.delete();
        }
        if (!f.renameTo(backup)) {
            throw new HgIOException(String.format("Failed to backup %s to %s", f.getName(), backup.getName()), backup);
        }
        if (!copy.renameTo(f)) {
            throw new HgIOException(String.format("Failed to bring on-write copy in place (%s to %s)", copy.getName(), f.getName()), copy);
        }
        f.setLastModified(lm);
        this.record(f, backup);
        return f;
    }

    @Override
    public File prepare(File origin, File backup) throws HgIOException {
        if (this.known(origin)) {
            return origin;
        }
        if (!origin.exists()) {
            return this.recordNonExistent(origin);
        }
        this.fileHelper.copy(origin, backup);
        RollbackEntry e = this.record(origin, backup);
        e.keepBackup = true;
        return origin;
    }

    @Override
    public void done(File f) throws HgIOException {
        this.find((File)f).success = true;
    }

    @Override
    public void failure(File f, IOException ex) {
        this.find((File)f).failure = ex;
    }

    @Override
    public void commit() throws HgIOException {
        Iterator<RollbackEntry> it = this.entries.iterator();
        while (it.hasNext()) {
            RollbackEntry e = it.next();
            if (!e.success) {
                throw new HgInvalidStateException(String.format("Attempt to commit transaction without successful clearance of file %s", e.origin));
            }
            if (e.failure != null) {
                throw new HgIOException("Can't close transaction with a failure.", e.failure, e.origin);
            }
            if (!e.keepBackup && e.backup != null) {
                e.backup.delete();
            }
            it.remove();
        }
    }

    @Override
    public void rollback() throws HgIOException {
        LinkedList<RollbackEntry> success = new LinkedList<RollbackEntry>();
        Iterator<RollbackEntry> it = this.entries.iterator();
        while (it.hasNext()) {
            RollbackEntry e = it.next();
            e.origin.delete();
            if (e.backup != null) {
                if (!e.backup.renameTo(e.origin)) {
                    String msg = String.format("Transaction rollback failed, could not rename backup %s back to %s", e.backup.getName(), e.origin.getName());
                    throw new HgIOException(msg, e.origin);
                }
                e.origin.setLastModified(System.currentTimeMillis());
            }
            success.add(e);
            it.remove();
        }
    }

    private File recordNonExistent(File f) throws HgIOException {
        this.record(f, null);
        try {
            f.getParentFile().mkdirs();
            f.createNewFile();
            return f;
        }
        catch (IOException ex) {
            throw new HgIOException("Failed to create new file", ex, f);
        }
    }

    private RollbackEntry record(File origin, File backup) {
        RollbackEntry e = new RollbackEntry(origin, backup);
        this.entries.add(e);
        return e;
    }

    private boolean known(File f) {
        RollbackEntry e = this.lookup(f);
        return e != null;
    }

    private RollbackEntry find(File f) {
        RollbackEntry e = this.lookup(f);
        if (e != null) {
            return e;
        }
        assert (false);
        return new RollbackEntry(f, f);
    }

    private RollbackEntry lookup(File f) {
        for (RollbackEntry e : this.entries) {
            if (!e.origin.equals(f)) continue;
            return e;
        }
        return null;
    }

    public static class Factory
    implements Transaction.Factory {
        @Override
        public Transaction create(SessionContext.Source ctxSource) {
            return new COWTransaction(ctxSource);
        }
    }

    private static class RollbackEntry {
        public final File origin;
        public final File backup;
        public boolean success = false;
        public IOException failure = null;
        public boolean keepBackup = false;

        public RollbackEntry(File o, File b) {
            this.origin = o;
            this.backup = b;
        }
    }
}

