/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.DataSerializer;
import org.tmatesoft.hg.internal.EncodingHelper;
import org.tmatesoft.hg.util.Path;

public class ChangelogEntryBuilder
implements DataSerializer.DataSource {
    private final EncodingHelper encHelper;
    private String user;
    private List<Path> modifiedFiles;
    private final Map<String, String> extrasMap = new LinkedHashMap<String, String>();
    private Integer tzOffset;
    private Long csetTime;
    private Nodeid manifestRev;
    private CharSequence comment;

    ChangelogEntryBuilder(EncodingHelper encodingHelper) {
        this.encHelper = encodingHelper;
    }

    public ChangelogEntryBuilder user(String username) {
        this.user = username;
        return this;
    }

    public String user() {
        if (this.user == null) {
            this.user = System.getProperty("user.name");
        }
        return this.user;
    }

    public ChangelogEntryBuilder setModified(Collection<Path> files) {
        this.modifiedFiles = new ArrayList(files == null ? Collections.emptyList() : files);
        return this;
    }

    public ChangelogEntryBuilder addModified(Collection<Path> files) {
        if (this.modifiedFiles == null) {
            return this.setModified(files);
        }
        this.modifiedFiles.addAll(files);
        return this;
    }

    public ChangelogEntryBuilder branch(String branchName) {
        if (branchName == null || "default".equals(branchName)) {
            this.extrasMap.remove("branch");
        } else {
            this.extrasMap.put("branch", branchName);
        }
        return this;
    }

    public ChangelogEntryBuilder extras(Map<String, String> extras) {
        this.extrasMap.clear();
        this.extrasMap.putAll(extras);
        return this;
    }

    public ChangelogEntryBuilder date(long seconds, int timezoneOffset) {
        this.csetTime = seconds;
        this.tzOffset = timezoneOffset;
        return this;
    }

    public ChangelogEntryBuilder manifest(Nodeid manifestRevision) {
        this.manifestRev = manifestRevision;
        return this;
    }

    public ChangelogEntryBuilder comment(CharSequence commentString) {
        this.comment = commentString;
        return this;
    }

    @Override
    public void serialize(DataSerializer out) throws HgIOException {
        byte[] b = this.build();
        out.write(b, 0, b.length);
    }

    @Override
    public int serializeLength() {
        return -1;
    }

    public byte[] build() {
        byte[] b;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        CharSequence extras = this.buildExtras();
        CharSequence files = this.buildFiles();
        byte[] manifestRevision = this.manifestRev.toString().getBytes();
        byte[] username = this.encHelper.userToChangeset(this.user());
        out.write(manifestRevision, 0, manifestRevision.length);
        out.write(10);
        out.write(username, 0, username.length);
        out.write(10);
        long csetDate = this.csetTime();
        byte[] date = String.format("%d %d", csetDate, this.csetTimezone(csetDate)).getBytes();
        out.write(date, 0, date.length);
        if (extras.length() > 0) {
            out.write(32);
            b = extras.toString().getBytes();
            out.write(b, 0, b.length);
        }
        out.write(10);
        b = this.encHelper.fileToChangeset(files);
        out.write(b, 0, b.length);
        out.write(10);
        out.write(10);
        byte[] cmt = this.encHelper.commentToChangeset(this.comment);
        out.write(cmt, 0, cmt.length);
        return out.toByteArray();
    }

    private CharSequence buildExtras() {
        StringBuilder extras = new StringBuilder();
        Iterator<Map.Entry<String, String>> it = this.extrasMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> next = it.next();
            extras.append(ChangelogEntryBuilder.encodeExtrasPair(next.getKey()));
            extras.append(':');
            extras.append(ChangelogEntryBuilder.encodeExtrasPair(next.getValue()));
            if (!it.hasNext()) continue;
            extras.append('\u0000');
        }
        return extras;
    }

    private CharSequence buildFiles() {
        StringBuilder files = new StringBuilder();
        if (this.modifiedFiles != null) {
            Collections.sort(this.modifiedFiles);
            Iterator<Path> it = this.modifiedFiles.iterator();
            while (it.hasNext()) {
                files.append(it.next());
                if (!it.hasNext()) continue;
                files.append('\n');
            }
        }
        return files;
    }

    private static final CharSequence encodeExtrasPair(String s) {
        if (s != null) {
            return s.replace("\\", "\\\\").replace("\n", "\\n").replace("\r", "\\r").replace("\u0000", "\\0");
        }
        return s;
    }

    private long csetTime() {
        if (this.csetTime != null) {
            return this.csetTime;
        }
        return System.currentTimeMillis() / 1000L;
    }

    private int csetTimezone(long time) {
        if (this.tzOffset != null) {
            return this.tzOffset;
        }
        return -(TimeZone.getDefault().getOffset(time) / 1000);
    }
}

