/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import org.tmatesoft.hg.internal.IntMap;
import org.tmatesoft.hg.repo.HgChangelog;
import org.tmatesoft.hg.repo.HgDataFile;
import org.tmatesoft.hg.repo.HgInternals;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.Path;

public class ChangelogHelper {
    private final int leftBoundary;
    private final HgRepository repo;
    private final IntMap<HgChangelog.RawChangeset> cache = new IntMap(32);
    private String nextCommitAuthor;

    public ChangelogHelper(HgRepository hgRepo, int leftBoundaryRevision) {
        this.repo = hgRepo;
        this.leftBoundary = leftBoundaryRevision;
    }

    public HgRepository getRepo() {
        return this.repo;
    }

    public HgChangelog.RawChangeset findLatestChangeWith(Path file) throws HgRuntimeException {
        HgDataFile df = this.repo.getFileNode(file);
        if (!df.exists()) {
            return null;
        }
        int changelogRev = df.getChangesetRevisionIndex(-3);
        if (changelogRev >= this.leftBoundary) {
            HgChangelog.RawChangeset cs = this.cache.get(changelogRev);
            if (cs == null) {
                cs = this.repo.getChangelog().range(changelogRev, changelogRev).get(0);
                this.cache.put(changelogRev, cs);
            }
            return cs;
        }
        return null;
    }

    public String getNextCommitUsername() {
        if (this.nextCommitAuthor == null) {
            this.nextCommitAuthor = new HgInternals(this.repo).getNextCommitUsername();
        }
        return this.nextCommitAuthor;
    }
}

