/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;

public class ChangelogMonitor {
    private final HgRepository repo;
    private int changelogRevCount = -1;
    private Nodeid changelogLastRev = null;

    public ChangelogMonitor(HgRepository hgRepo) {
        this.repo = hgRepo;
    }

    public void touch() throws HgRuntimeException {
        this.changelogRevCount = this.repo.getChangelog().getRevisionCount();
        this.changelogLastRev = this.safeGetRevision(this.changelogRevCount - 1);
    }

    public boolean isChanged() throws HgRuntimeException {
        int rc = this.repo.getChangelog().getRevisionCount();
        if (rc != this.changelogRevCount) {
            return true;
        }
        Nodeid r = this.safeGetRevision(rc - 1);
        return !r.equals(this.changelogLastRev);
    }

    private Nodeid safeGetRevision(int revIndex) throws HgRuntimeException {
        if (revIndex >= 0) {
            return this.repo.getChangelog().getRevision(revIndex);
        }
        return Nodeid.NULL;
    }
}

