/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.core.SessionContext;
import org.tmatesoft.hg.internal.DataAccess;
import org.tmatesoft.hg.internal.EncodingHelper;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.internal.Pool;
import org.tmatesoft.hg.repo.HgChangelog;
import org.tmatesoft.hg.repo.HgInvalidDataFormatException;

public final class ChangesetParser {
    private final EncodingHelper encHelper;
    private final Pool<String> usersPool;
    private final Pool<String> filesPool;
    private final CsetFactory factory;

    public ChangesetParser(SessionContext.Source sessionContex, CsetFactory csetFactory) {
        assert (csetFactory != null);
        this.encHelper = Internals.buildFileNameEncodingHelper(sessionContex);
        this.usersPool = new Pool();
        this.filesPool = new Pool();
        this.factory = csetFactory;
    }

    public void dispose() {
        this.usersPool.clear();
        this.filesPool.clear();
    }

    public HgChangelog.RawChangeset parse(DataAccess da) throws IOException, HgInvalidDataFormatException {
        byte[] data = da.byteArray();
        return this.parse(data);
    }

    public HgChangelog.RawChangeset parse(byte[] data) throws HgInvalidDataFormatException {
        return this.init(data, 0, data.length);
    }

    private HgChangelog.RawChangeset init(byte[] data, int offset, int length) throws HgInvalidDataFormatException {
        int bufferEndIndex = offset + length;
        int breakIndex1 = ChangesetParser.indexOf(data, (byte)10, offset, bufferEndIndex);
        if (breakIndex1 == -1) {
            throw new HgInvalidDataFormatException("Bad Changeset data");
        }
        Nodeid _nodeid = Nodeid.fromAscii(data, 0, breakIndex1);
        int breakIndex2 = ChangesetParser.indexOf(data, (byte)10, breakIndex1 + 1, bufferEndIndex);
        if (breakIndex2 == -1) {
            throw new HgInvalidDataFormatException("Bad Changeset data");
        }
        String _user = this.encHelper.userFromChangeset(data, breakIndex1 + 1, breakIndex2 - breakIndex1 - 1);
        _user = this.usersPool.unify(_user);
        int breakIndex3 = ChangesetParser.indexOf(data, (byte)10, breakIndex2 + 1, bufferEndIndex);
        if (breakIndex3 == -1) {
            throw new HgInvalidDataFormatException("Bad Changeset data");
        }
        String _timeString = new String(data, breakIndex2 + 1, breakIndex3 - breakIndex2 - 1);
        int space1 = _timeString.indexOf(32);
        if (space1 == -1) {
            throw new HgInvalidDataFormatException(String.format("Bad Changeset data: %s in [%d..%d]", "time string", breakIndex2 + 1, breakIndex3));
        }
        int space2 = _timeString.indexOf(32, space1 + 1);
        if (space2 == -1) {
            space2 = _timeString.length();
        }
        long unixTime = Long.parseLong(_timeString.substring(0, space1));
        int _timezone = Integer.parseInt(_timeString.substring(space1 + 1, space2));
        Date _time = new Date(unixTime * 1000L);
        String _extras = space2 < _timeString.length() ? _timeString.substring(space2 + 1) : null;
        Map<String, String> _extrasMap = this.parseExtras(_extras);
        int lastStart = breakIndex3 + 1;
        int breakIndex4 = ChangesetParser.indexOf(data, (byte)10, lastStart, bufferEndIndex);
        ArrayList<String> _files = null;
        if (breakIndex4 > lastStart) {
            _files = new ArrayList<String>(5);
            while (breakIndex4 != -1 && breakIndex4 + 1 < bufferEndIndex) {
                String fname = this.encHelper.fileFromChangeset(data, lastStart, breakIndex4 - lastStart);
                _files.add(this.filesPool.unify(fname));
                lastStart = breakIndex4 + 1;
                if (data[breakIndex4 + 1] == 10) break;
                breakIndex4 = ChangesetParser.indexOf(data, (byte)10, lastStart, bufferEndIndex);
            }
            if (breakIndex4 == -1 || breakIndex4 >= bufferEndIndex) {
                throw new HgInvalidDataFormatException("Bad Changeset data");
            }
        } else {
            --breakIndex4;
        }
        String _comment = this.encHelper.commentFromChangeset(data, breakIndex4 + 2, bufferEndIndex - breakIndex4 - 2);
        HgChangelog.RawChangeset target = this.factory.create(_nodeid, _user, _time, _timezone, _files, _comment, _extrasMap);
        return target;
    }

    private Map<String, String> parseExtras(String _extras) {
        String string = _extras = _extras == null ? null : _extras.trim();
        if (_extras == null || _extras.length() == 0) {
            return Collections.singletonMap("branch", "default");
        }
        HashMap<String, String> _extrasMap = new HashMap<String, String>();
        int lastIndex = 0;
        do {
            int sp;
            if ((sp = _extras.indexOf(0, lastIndex)) == -1) {
                sp = _extras.length();
            }
            if (sp <= lastIndex) continue;
            String pair = _extras.substring(lastIndex, sp);
            pair = ChangesetParser.decode(pair);
            int eq = pair.indexOf(58);
            _extrasMap.put(pair.substring(0, eq), pair.substring(eq + 1));
            lastIndex = sp + 1;
        } while (lastIndex < _extras.length());
        if (!_extrasMap.containsKey("branch")) {
            _extrasMap.put("branch", "default");
        }
        return Collections.unmodifiableMap(_extrasMap);
    }

    private static int indexOf(byte[] src, byte what, int startOffset, int endIndex) {
        int i = startOffset;
        while (i < endIndex) {
            if (src[i] == what) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static String decode(String s) {
        if (s != null && s.indexOf(92) != -1) {
            return s.replace("\\\\", "\\").replace("\\n", "\n").replace("\\r", "\r").replace("\\0", "\u0000");
        }
        return s;
    }

    public static interface CsetFactory {
        public HgChangelog.RawChangeset create(Nodeid var1, String var2, Date var3, int var4, List<String> var5, String var6, Map<String, String> var7);
    }
}

