/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.core.HgRepositoryLockException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.ChangelogEntryBuilder;
import org.tmatesoft.hg.internal.DataSerializer;
import org.tmatesoft.hg.internal.DirstateBuilder;
import org.tmatesoft.hg.internal.DirstateReader;
import org.tmatesoft.hg.internal.EncodingHelper;
import org.tmatesoft.hg.internal.FNCacheFile;
import org.tmatesoft.hg.internal.FileUtils;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.internal.ManifestEntryBuilder;
import org.tmatesoft.hg.internal.ManifestRevision;
import org.tmatesoft.hg.internal.PhasesHelper;
import org.tmatesoft.hg.internal.RevlogStream;
import org.tmatesoft.hg.internal.RevlogStreamWriter;
import org.tmatesoft.hg.internal.Transaction;
import org.tmatesoft.hg.repo.HgChangelog;
import org.tmatesoft.hg.repo.HgDataFile;
import org.tmatesoft.hg.repo.HgPhase;
import org.tmatesoft.hg.repo.HgRepositoryFiles;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.LogFacility;
import org.tmatesoft.hg.util.Pair;
import org.tmatesoft.hg.util.Path;

public final class CommitFacility {
    private final Internals repo;
    private final int p1Commit;
    private final int p2Commit;
    private Map<Path, Pair<HgDataFile, DataSerializer.DataSource>> files = new LinkedHashMap<Path, Pair<HgDataFile, DataSerializer.DataSource>>();
    private Set<Path> removals = new TreeSet<Path>();
    private String branch;
    private String user;

    public CommitFacility(Internals hgRepo, int parentCommit) {
        this(hgRepo, parentCommit, -1);
    }

    public CommitFacility(Internals hgRepo, int parent1Commit, int parent2Commit) {
        this.repo = hgRepo;
        this.p1Commit = parent1Commit;
        this.p2Commit = parent2Commit;
        if (parent1Commit != -1 && parent1Commit == parent2Commit) {
            throw new IllegalArgumentException("Merging same revision is dubious");
        }
    }

    public boolean isMerge() {
        return this.p1Commit != -1 && this.p2Commit != -1;
    }

    public void add(HgDataFile dataFile, DataSerializer.DataSource content) {
        if (content == null) {
            throw new IllegalArgumentException();
        }
        this.removals.remove(dataFile.getPath());
        this.files.put(dataFile.getPath(), new Pair<HgDataFile, DataSerializer.DataSource>(dataFile, content));
    }

    public void forget(HgDataFile dataFile) {
        this.files.remove(dataFile.getPath());
        this.removals.add(dataFile.getPath());
    }

    public void branch(String branchName) {
        this.branch = branchName;
    }

    public void user(String userName) {
        this.user = userName;
    }

    public Nodeid commit(String message, Transaction transaction) throws HgIOException, HgRepositoryLockException, HgRuntimeException {
        Nodeid changesetRev;
        ArrayList<Path> touchInDirstate;
        Nodeid p2Cset;
        Nodeid p1Cset;
        block25: {
            String newBranchValue;
            HgChangelog clog = this.repo.getRepo().getChangelog();
            int clogRevisionIndex = clog.getRevisionCount();
            ManifestRevision c1Manifest = new ManifestRevision(null, null);
            ManifestRevision c2Manifest = new ManifestRevision(null, null);
            p1Cset = this.p1Commit == -1 ? null : clog.getRevision(this.p1Commit);
            Nodeid nodeid = p2Cset = this.p2Commit == -1 ? null : clog.getRevision(this.p2Commit);
            if (this.p1Commit != -1) {
                this.repo.getRepo().getManifest().walk(this.p1Commit, this.p1Commit, c1Manifest);
            }
            if (this.p2Commit != -1) {
                this.repo.getRepo().getManifest().walk(this.p2Commit, this.p2Commit, c2Manifest);
            }
            Pair<Integer, Integer> manifestParents = new Pair<Integer, Integer>(c1Manifest.revisionIndex(), c2Manifest.revisionIndex());
            TreeMap<Path, Object> newManifestRevision = new TreeMap<Path, Object>();
            HashMap<Path, Pair<Integer, Integer>> fileParents = new HashMap<Path, Pair<Integer, Integer>>();
            for (Path f : c1Manifest.files()) {
                HgDataFile hgDataFile = this.repo.getRepo().getFileNode(f);
                Nodeid fileKnownRev1 = c1Manifest.nodeid(f);
                int fileRevIndex1 = hgDataFile.getRevisionIndex(fileKnownRev1);
                Nodeid fileKnownRev2 = c2Manifest.nodeid(f);
                int fileRevIndex2 = fileKnownRev2 != null ? hgDataFile.getRevisionIndex(fileKnownRev2) : -1;
                fileParents.put(f, new Pair<Integer, Integer>(fileRevIndex1, fileRevIndex2));
                newManifestRevision.put(f, fileKnownRev1);
            }
            for (Path p : this.removals) {
                newManifestRevision.remove(p);
            }
            this.saveCommitMessage(message);
            FNCacheFile.Mediator fncache = new FNCacheFile.Mediator(this.repo, transaction);
            touchInDirstate = new ArrayList<Path>();
            for (Pair pair : this.files.values()) {
                HgDataFile df = (HgDataFile)pair.first();
                DataSerializer.DataSource bds = (DataSerializer.DataSource)pair.second();
                Pair<Integer, Integer> fp = (Pair<Integer, Integer>)fileParents.get(df.getPath());
                if (fp == null) {
                    fp = new Pair<Integer, Integer>(-1, -1);
                }
                RevlogStream contentStream = this.repo.getImplAccess().getStream(df);
                boolean isNewFile = !df.exists();
                RevlogStreamWriter fileWriter = new RevlogStreamWriter(this.repo, contentStream, transaction);
                Nodeid fileRev = fileWriter.addRevision(bds, clogRevisionIndex, fp.first(), fp.second()).second();
                newManifestRevision.put(df.getPath(), fileRev);
                touchInDirstate.add(df.getPath());
                if (!isNewFile) continue;
                fncache.registerNew(df.getPath(), contentStream);
            }
            EncodingHelper encodingHelper = this.repo.buildFileNameEncodingHelper();
            ManifestEntryBuilder manifestBuilder = new ManifestEntryBuilder(encodingHelper);
            for (Map.Entry me : newManifestRevision.entrySet()) {
                manifestBuilder.add(((Path)me.getKey()).toString(), (Nodeid)me.getValue());
            }
            RevlogStreamWriter manifestWriter = new RevlogStreamWriter(this.repo, this.repo.getImplAccess().getManifestStream(), transaction);
            Nodeid manifestRev = manifestWriter.addRevision(manifestBuilder, clogRevisionIndex, manifestParents.first(), manifestParents.second()).second();
            ChangelogEntryBuilder changelogBuilder = new ChangelogEntryBuilder(encodingHelper);
            changelogBuilder.setModified(this.files.keySet());
            changelogBuilder.branch(this.branch == null ? "default" : this.branch);
            changelogBuilder.user(String.valueOf(this.user));
            changelogBuilder.manifest(manifestRev).comment(message);
            RevlogStreamWriter changelogWriter = new RevlogStreamWriter(this.repo, this.repo.getImplAccess().getChangelogStream(), transaction);
            changesetRev = changelogWriter.addRevision(changelogBuilder, clogRevisionIndex, this.p1Commit, this.p2Commit).second();
            fncache.complete();
            String oldBranchValue = DirstateReader.readBranch(this.repo);
            String string = newBranchValue = this.branch == null ? "default" : this.branch;
            if (!oldBranchValue.equals(newBranchValue)) {
                File branchFile = transaction.prepare(this.repo.getRepositoryFile(HgRepositoryFiles.Branch), this.repo.getRepositoryFile(HgRepositoryFiles.UndoBranch));
                FileOutputStream fos = null;
                try {
                    try {
                        fos = new FileOutputStream(branchFile);
                        fos.write(newBranchValue.getBytes(EncodingHelper.getUTF8().name()));
                        fos.flush();
                        fos.close();
                        fos = null;
                        transaction.done(branchFile);
                    }
                    catch (IOException ex) {
                        transaction.failure(branchFile, ex);
                        this.repo.getLog().dump(this.getClass(), LogFacility.Severity.Error, ex, "Failed to write branch information, error ignored");
                        try {
                            if (fos != null) {
                                fos.close();
                            }
                            break block25;
                        }
                        catch (IOException ex2) {
                            this.repo.getLog().dump(this.getClass(), LogFacility.Severity.Error, ex2, null);
                        }
                        break block25;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException ex) {
                        this.repo.getLog().dump(this.getClass(), LogFacility.Severity.Error, ex, null);
                    }
                    throw throwable;
                }
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException ex) {
                    this.repo.getLog().dump(this.getClass(), LogFacility.Severity.Error, ex, null);
                }
            }
        }
        DirstateBuilder dirstateBuilder = new DirstateBuilder(this.repo);
        dirstateBuilder.fillFrom(new DirstateReader(this.repo, new Path.SimpleSource()));
        for (Path p : this.removals) {
            dirstateBuilder.recordRemoved(p);
        }
        for (Path p : touchInDirstate) {
            dirstateBuilder.recordUncertain(p);
        }
        dirstateBuilder.parents(changesetRev, Nodeid.NULL);
        dirstateBuilder.serialize(transaction);
        if (this.p1Commit != -1 || this.p2Commit != -1) {
            this.repo.getRepo().getBookmarks().updateActive(p1Cset, p2Cset, changesetRev);
        }
        PhasesHelper phaseHelper = new PhasesHelper(this.repo);
        HgPhase newCommitPhase = HgPhase.parse(this.repo.getRepo().getConfiguration().getStringValue("phases", "new-commit", HgPhase.Draft.mercurialString()));
        phaseHelper.newCommitNode(changesetRev, newCommitPhase);
        return changesetRev;
    }

    private void saveCommitMessage(String message) throws HgIOException {
        File lastMessage = this.repo.getRepositoryFile(HgRepositoryFiles.LastMessage);
        if (lastMessage.isFile() && !lastMessage.canWrite() || !lastMessage.getParentFile().canWrite()) {
            return;
        }
        FileWriter w = null;
        try {
            try {
                w = new FileWriter(lastMessage);
                w.write(message == null ? new String() : message);
                w.flush();
            }
            catch (IOException ex) {
                throw new HgIOException("Failed to save last commit message", ex, lastMessage);
            }
        }
        finally {
            new FileUtils(this.repo.getLog(), this).closeQuietly(w, lastMessage);
        }
    }
}

