/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import org.tmatesoft.hg.core.HgRepositoryLockException;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRepositoryLock;
import org.tmatesoft.hg.util.LogFacility;

public final class CompleteRepoLock {
    private final HgRepository repo;
    private HgRepositoryLock wdLock;
    private HgRepositoryLock storeLock;

    public CompleteRepoLock(HgRepository hgRepo) {
        this.repo = hgRepo;
    }

    public void acquire() throws HgRepositoryLockException {
        this.wdLock = this.repo.getWorkingDirLock();
        this.storeLock = this.repo.getStoreLock();
        this.wdLock.acquire();
        try {
            this.storeLock.acquire();
        }
        catch (HgRepositoryLockException ex) {
            try {
                this.wdLock.release();
            }
            catch (HgRepositoryLockException e2) {
                LogFacility log = this.repo.getSessionContext().getLog();
                log.dump(this.getClass(), LogFacility.Severity.Error, e2, "Nested exception ignored once failed to acquire store lock");
            }
            throw ex;
        }
    }

    public void release() throws HgRepositoryLockException {
        try {
            this.storeLock.release();
        }
        catch (HgRepositoryLockException ex) {
            try {
                this.wdLock.release();
            }
            catch (HgRepositoryLockException e2) {
                LogFacility log = this.repo.getSessionContext().getLog();
                log.dump(this.getClass(), LogFacility.Severity.Error, e2, "Nested exception ignored when releasing working directory lock");
            }
            throw ex;
        }
        this.wdLock.release();
    }
}

