/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.core.SessionContext;
import org.tmatesoft.hg.internal.LineReader;
import org.tmatesoft.hg.util.LogFacility;

public class ConfigFile {
    private final SessionContext sessionContext;
    private List<String> sections;
    private List<Map<String, String>> content;

    public ConfigFile(SessionContext ctx) {
        this.sessionContext = ctx;
    }

    public void addLocation(File path) throws HgIOException {
        this.read(path);
    }

    public boolean hasSection(String sectionName) {
        return this.sections == null ? false : this.sections.indexOf(sectionName) != -1;
    }

    public List<String> getSectionNames() {
        return this.sections == null ? Collections.emptyList() : Collections.unmodifiableList(this.sections);
    }

    public Map<String, String> getSection(String sectionName) {
        if (this.sections == null) {
            return Collections.emptyMap();
        }
        int x = this.sections.indexOf(sectionName);
        if (x == -1) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.content.get(x));
    }

    public boolean getBoolean(String sectionName, String key, boolean defaultValue) {
        String value = this.getSection(sectionName).get(key);
        if (value == null) {
            return defaultValue;
        }
        String[] stringArray = new String[]{"true", "yes", "on", "1"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equalsIgnoreCase(value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getString(String sectionName, String key, String defaultValue) {
        String value = this.getSection(sectionName).get(key);
        return value == null ? defaultValue : value;
    }

    public int getInteger(String sectionName, String key, int defaultValue) {
        String value = this.getSection(sectionName).get(key);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    public void putString(String sectionName, String key, String newValue) {
        int x;
        Map<String, String> section = null;
        if (this.sections == null) {
            this.sections = new ArrayList<String>();
            this.content = new ArrayList<Map<String, String>>();
        }
        if ((x = this.sections.indexOf(sectionName)) == -1) {
            if (newValue == null) {
                return;
            }
            this.sections.add(sectionName);
            section = new LinkedHashMap<String, String>();
            this.content.add(section);
        } else {
            section = this.content.get(x);
        }
        if (newValue == null) {
            section.remove(key);
        } else {
            section.put(key, newValue);
        }
    }

    private void read(File f) throws HgIOException {
        if (f == null || !f.canRead()) {
            return;
        }
        if (this.sections == null) {
            this.sections = new ArrayList<String>();
            this.content = new ArrayList<Map<String, String>>();
        }
        new Parser().go(f, this);
        ((ArrayList)this.sections).trimToSize();
        ((ArrayList)this.content).trimToSize();
        assert (this.sections.size() == this.content.size());
    }

    public void writeTo(File f) throws IOException {
        byte[] data = this.compose();
        if (!f.exists()) {
            f.createNewFile();
        }
        FileChannel fc = new FileOutputStream(f).getChannel();
        FileLock fl = fc.lock();
        try {
            fc.write(ByteBuffer.wrap(data));
        }
        finally {
            fl.release();
            fc.close();
        }
    }

    private byte[] compose() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        PrintStream ps = new PrintStream(bos);
        Iterator<String> sectionNames = this.sections.iterator();
        for (Map<String, String> s : this.content) {
            String name = sectionNames.next();
            if (s.isEmpty()) continue;
            ps.print('[');
            ps.print(name);
            ps.println(']');
            for (Map.Entry<String, String> e : s.entrySet()) {
                ps.print(e.getKey());
                ps.print('=');
                ps.println(e.getValue());
            }
            ps.println();
        }
        ps.flush();
        return bos.toByteArray();
    }

    private static class Parser
    implements LineReader.LineConsumer<ConfigFile> {
        private String sectionName = "";
        private Map<String, String> section = new LinkedHashMap<String, String>();
        private File contextFile;

        private Parser() {
        }

        @Override
        public boolean consume(String line, ConfigFile cfg) throws IOException {
            int x = line.indexOf(35);
            if (x != -1) {
                line = new String(line.substring(0, x).trim());
            }
            if (line.length() <= 2) {
                return true;
            }
            if (line.charAt(0) == '[' && line.charAt(line.length() - 1) == ']') {
                this.sectionName = line.substring(1, line.length() - 1);
                if (cfg.sections.indexOf(this.sectionName) == -1) {
                    cfg.sections.add(this.sectionName);
                    this.section = new LinkedHashMap<String, String>();
                    cfg.content.add(this.section);
                } else {
                    this.section = null;
                }
            } else if (line.startsWith("%unset")) {
                if (this.section != null) {
                    this.section.remove(line.substring(7).trim());
                }
            } else if (line.startsWith("%include")) {
                this.processInclude(line.substring(9).trim(), cfg);
            } else {
                x = line.indexOf(61);
                if (x != -1) {
                    String key = line.substring(0, x).trim();
                    String value = line.substring(x + 1).trim();
                    if (this.section == null) {
                        int i = cfg.sections.indexOf(this.sectionName);
                        assert (i >= 0);
                        this.section = (Map)cfg.content.get(i);
                    }
                    if (this.sectionName.length() == 0) {
                        cfg.sections.add(this.sectionName);
                        cfg.content.add(this.section);
                    }
                    this.section.put(key, value);
                }
            }
            return true;
        }

        public void go(File f, ConfigFile cfg) throws HgIOException {
            this.contextFile = f;
            LineReader lr = new LineReader(f, cfg.sessionContext.getLog());
            lr.ignoreLineComments("#");
            lr.read(this, cfg);
        }

        private void processInclude(String includeValue, ConfigFile cfg) {
            File f = includeValue.startsWith("~/") ? new File(System.getProperty("user.home"), includeValue.substring(2)) : new File(this.contextFile.getParentFile(), includeValue);
            try {
                if (f.canRead()) {
                    new Parser().go(f, cfg);
                } else {
                    LogFacility lf = cfg.sessionContext.getLog();
                    lf.dump(ConfigFile.class, LogFacility.Severity.Debug, "Can't read file to  include: %s", f);
                }
            }
            catch (HgIOException hgIOException) {
                LogFacility lf = cfg.sessionContext.getLog();
                lf.dump(ConfigFile.class, LogFacility.Severity.Warn, "Can't include %s (%s)", f, includeValue);
            }
        }
    }
}

