/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;

public class ConfigFileParser {
    private ParseState state = ParseState.Initial;
    private int lastNonEmptyLineEndOffset = -1;
    private String sectionName;
    private int sectionStart = -1;
    private String entryKey;
    private int entryStart = -1;
    private int valueStart = -1;
    private int valueEnd = -1;
    private ArrayList<Entry> entries;
    private ArrayList<Section> sections = new ArrayList();
    private byte[] contents;
    private List<String> deletions = new ArrayList<String>(5);
    private List<String> additions = new ArrayList<String>(5);
    private List<String> changes = new ArrayList<String>(5);

    public boolean exists(String section, String key) {
        assert (this.contents != null);
        for (Section s : this.sections) {
            if (!s.name.equals(section)) continue;
            Entry[] entryArray = s.entries;
            int n = s.entries.length;
            int n2 = 0;
            while (n2 < n) {
                Entry e = entryArray[n2];
                if (e.name.equals(key)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return false;
    }

    public void add(String section, String key, String newValue) {
        this.additions.add(section);
        this.additions.add(key);
        this.additions.add(newValue);
    }

    public void change(String section, String key, String newValue) {
        this.changes.add(section);
        this.changes.add(key);
        this.changes.add(newValue);
    }

    public void delete(String section, String key) {
        this.deletions.add(section);
        this.deletions.add(key);
    }

    public void parse(InputStream is) throws IOException {
        int b;
        this.state = ParseState.Initial;
        this.sections.clear();
        this.contents = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        ByteArrayOutputStream line = new ByteArrayOutputStream(80);
        int offset = 0;
        int lineOffset = -1;
        int lineNumber = 1;
        boolean crDetected = false;
        while ((b = is.read()) != -1) {
            bos.write(b);
            if (b == 10 || b == 13) {
                if (line.size() > 0) {
                    this.processLine(lineNumber, lineOffset, line.toByteArray());
                    line.reset();
                    lineOffset = -1;
                    this.lastNonEmptyLineEndOffset = bos.size() - 1;
                }
                if (b != 10 || !crDetected) {
                    ++lineNumber;
                }
                crDetected = b == 13;
            } else {
                crDetected = false;
                if (line.size() == 0) {
                    lineOffset = offset;
                }
                line.write(b);
            }
            ++offset;
        }
        if (line.size() > 0) {
            this.processLine(lineNumber, lineOffset, line.toByteArray());
            this.lastNonEmptyLineEndOffset = bos.size();
        }
        if (this.state == ParseState.Entry) {
            this.closeEntry();
        }
        if (this.state == ParseState.Section) {
            this.closeSection();
        }
        this.contents = bos.toByteArray();
    }

    public void update(OutputStream out) throws IOException {
        if (this.contents == null) {
            throw new IOException("Shall parse first");
        }
        HashSet<String> processedSections = new HashSet<String>();
        int contentsOffset = 0;
        for (Section section : this.sections) {
            LinkedHashMap<String, String> additionsInSection = new LinkedHashMap<String, String>();
            LinkedHashMap<String, String> changesInSection = new LinkedHashMap<String, String>();
            LinkedHashSet<String> deletionsInSection = new LinkedHashSet<String>();
            if (!processedSections.contains(section.name)) {
                String v;
                String k;
                String s;
                Iterator<String> it = this.additions.iterator();
                while (it.hasNext()) {
                    s = it.next();
                    k = it.next();
                    v = it.next();
                    if (!section.name.equals(s)) continue;
                    additionsInSection.put(k, v);
                }
                it = this.changes.iterator();
                while (it.hasNext()) {
                    s = it.next();
                    k = it.next();
                    v = it.next();
                    if (!section.name.equals(s)) continue;
                    changesInSection.put(k, v);
                }
                it = this.deletions.iterator();
                while (it.hasNext()) {
                    s = it.next();
                    k = it.next();
                    if (!section.name.equals(s)) continue;
                    deletionsInSection.add(k);
                }
            }
            Entry[] entryArray = section.entries;
            int k = section.entries.length;
            int s = 0;
            while (s < k) {
                Entry e = entryArray[s];
                if (deletionsInSection.contains(e.name)) {
                    out.write(this.contents, contentsOffset, e.start - contentsOffset);
                    contentsOffset = e.valueEnd + 1;
                } else if (changesInSection.containsKey(e.name)) {
                    if (e.valueStart == -1) {
                        out.write(this.contents, contentsOffset, e.valueEnd + 1 - contentsOffset);
                    } else {
                        out.write(this.contents, contentsOffset, e.valueStart - contentsOffset);
                    }
                    String value = (String)changesInSection.get(e.name);
                    out.write(value == null ? new byte[]{} : value.getBytes());
                    contentsOffset = e.valueEnd + 1;
                }
                ++s;
            }
            if (section.entries.length == 0) {
                out.write(this.contents, contentsOffset, section.end - contentsOffset);
                contentsOffset = section.end;
            }
            if (!additionsInSection.isEmpty()) {
                out.write(this.contents, contentsOffset, section.end - contentsOffset);
                contentsOffset = section.end;
                for (String k2 : additionsInSection.keySet()) {
                    String v = (String)additionsInSection.get(k2);
                    out.write(String.format("\n%s = %s", k2, v == null ? "" : v).getBytes());
                }
            }
            processedSections.add(section.name);
        }
        out.write(this.contents, contentsOffset, this.contents.length - contentsOffset);
        LinkedHashSet<String> newSections = new LinkedHashSet<String>();
        Iterator<String> it = this.additions.iterator();
        while (it.hasNext()) {
            String s = it.next();
            it.next();
            it.next();
            if (processedSections.contains(s)) continue;
            newSections.add(s);
        }
        for (String newSectionName : newSections) {
            out.write(String.format("\n[%s]", newSectionName).getBytes());
            Iterator<String> it2 = this.additions.iterator();
            while (it2.hasNext()) {
                String k2;
                String s = it2.next();
                k2 = it2.next();
                String v = it2.next();
                if (!newSectionName.equals(s)) continue;
                out.write(String.format("\n%s = %s", k2, v).getBytes());
            }
            out.write("\n".getBytes());
        }
    }

    private void processLine(int lineNumber, int offset, byte[] line) throws IOException {
        int localOffset = 0;
        int i = 0;
        while (i < line.length && Character.isWhitespace(line[i])) {
            ++i;
        }
        if (i == line.length) {
            return;
        }
        localOffset = i;
        if (line[i] == 91) {
            if (this.state == ParseState.Entry) {
                this.closeEntry();
            }
            if (this.state == ParseState.Section) {
                this.closeSection();
            }
            while (i < line.length && line[i] != 93) {
                ++i;
            }
            if (i == line.length) {
                throw new IOException(String.format("Can't find closing ']' for section name in line %d", lineNumber));
            }
            this.sectionName = new String(line, localOffset + 1, i - localOffset - 1);
            this.sectionStart = offset + localOffset;
            this.state = ParseState.Section;
        } else {
            if (line[i] == 35 || line[i] == 59) {
                return;
            }
            if (this.state == ParseState.Initial) {
                throw new IOException(String.format("Line %d doesn't belong to any section", lineNumber));
            }
            if (localOffset > 0) {
                if (this.state == ParseState.Section) {
                    throw new IOException(String.format("Non-indented key is expected in line %d", lineNumber));
                }
                assert (this.state == ParseState.Entry);
                if (this.valueStart == -1) {
                    this.valueStart = offset + localOffset;
                }
                this.valueEnd = offset + line.length - 1;
            } else {
                if (this.state == ParseState.Entry) {
                    this.closeEntry();
                }
                assert (this.state == ParseState.Section);
                this.state = ParseState.Entry;
                while (i < line.length && !Character.isWhitespace(line[i]) && line[i] != 61) {
                    ++i;
                }
                if (i == line.length) {
                    throw new IOException(String.format("Can't process entry in line %d", lineNumber));
                }
                this.entryKey = new String(line, localOffset, i - localOffset);
                this.entryStart = offset + localOffset;
                while (i < line.length && line[i] != 61) {
                    ++i;
                }
                if (i == line.length) {
                    throw new IOException(String.format("Can't find '=' after key %s in line %d", this.entryKey, lineNumber));
                }
                ++i;
                while (i < line.length && Character.isWhitespace(line[i])) {
                    ++i;
                }
                this.valueStart = i == line.length ? -1 : offset + i;
                this.valueEnd = offset + line.length - 1;
            }
        }
    }

    private void closeSection() {
        assert (this.state == ParseState.Section);
        assert (this.sectionName != null);
        assert (this.lastNonEmptyLineEndOffset != -1);
        Section s = new Section(this.sectionName, this.sectionStart, this.lastNonEmptyLineEndOffset, this.entries == null ? Collections.emptyList() : this.entries);
        this.sections.add(s);
        this.sectionName = null;
        this.sectionStart = -1;
        this.state = ParseState.Initial;
        this.entries = null;
    }

    private void closeEntry() {
        assert (this.state == ParseState.Entry);
        assert (this.entryKey != null);
        this.state = ParseState.Section;
        Entry e = new Entry(this.entryKey, this.entryStart, this.valueStart, this.valueEnd);
        if (this.entries == null) {
            this.entries = new ArrayList();
        }
        this.entries.add(e);
        this.entryKey = null;
        this.entryStart = this.valueStart = this.valueEnd - 1;
    }

    private static class Block {
        public final int start;

        Block(int s) {
            this.start = s;
        }
    }

    private static class Entry
    extends Block {
        public final int valueStart;
        public final int valueEnd;
        public final String name;

        Entry(String n, int s, int vs, int ve) {
            super(s);
            this.name = n;
            this.valueStart = vs;
            this.valueEnd = ve;
        }
    }

    private static enum ParseState {
        Initial,
        Section,
        Entry;

    }

    private static class Section
    extends Block {
        public final String name;
        public final Entry[] entries;
        public final int end;

        Section(String n, int s, int endOffset, List<Entry> e) {
            super(s);
            this.name = n;
            this.end = endOffset;
            this.entries = new Entry[e.size()];
            e.toArray(this.entries);
        }
    }
}

