/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import org.tmatesoft.hg.core.HgBadArgumentException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.repo.HgInvalidRevisionException;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;

public class CsetParamKeeper {
    private final HgRepository repo;
    private int changelogRevisionIndex = Integer.MIN_VALUE;

    public CsetParamKeeper(HgRepository hgRepo) {
        this.repo = hgRepo;
    }

    public CsetParamKeeper set(Nodeid changeset) throws HgBadArgumentException {
        try {
            this.set(this.repo.getChangelog().getRevisionIndex(changeset));
        }
        catch (HgInvalidRevisionException ex) {
            throw new HgBadArgumentException("Can't find revision", ex).setRevision(changeset);
        }
        catch (HgRuntimeException ex) {
            throw new HgBadArgumentException(String.format("Can't initialize with revision %s", changeset.shortNotation()), ex);
        }
        return this;
    }

    public CsetParamKeeper set(int changelogRevIndex) throws HgBadArgumentException {
        try {
            int lastCsetIndex = this.repo.getChangelog().getLastRevision();
            if (changelogRevIndex == -3) {
                changelogRevIndex = lastCsetIndex;
            }
            if (changelogRevIndex < 0 || changelogRevIndex > lastCsetIndex) {
                throw new HgBadArgumentException(String.format("Bad revision index %d, value from [0..%d] expected", changelogRevIndex, lastCsetIndex), null).setRevisionIndex(changelogRevIndex);
            }
            this.doSet(changelogRevIndex);
        }
        catch (HgRuntimeException ex) {
            throw new HgBadArgumentException(String.format("Can't initialize with revision index %d", changelogRevIndex), ex);
        }
        return this;
    }

    public void doSet(int changelogRevIndex) {
        this.changelogRevisionIndex = changelogRevIndex;
    }

    public int get() {
        return this.changelogRevisionIndex;
    }

    public int get(int defaultRevisionIndex) throws HgRuntimeException {
        if (this.changelogRevisionIndex != Integer.MIN_VALUE && this.changelogRevisionIndex != -3) {
            return this.changelogRevisionIndex;
        }
        if (this.changelogRevisionIndex == -3 || defaultRevisionIndex == -3) {
            return this.repo.getChangelog().getLastRevision();
        }
        return defaultRevisionIndex;
    }
}

