/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.tmatesoft.hg.internal.Internals;

public class DataAccess {
    private byte[] longBuffer;

    public boolean isEmpty() throws IOException {
        return true;
    }

    public int length() throws IOException {
        return 0;
    }

    public long longLength() throws IOException {
        return this.length();
    }

    public void longSeek(long offset) throws IOException {
        this.seek(Internals.ltoi(offset));
    }

    public DataAccess reset() throws IOException {
        return this;
    }

    public void seek(int offset) throws IOException {
        if (offset == 0) {
            return;
        }
        throw new IOException(String.format("No data, can't seek %d bytes", offset));
    }

    public void skip(int bytes) throws IOException {
        if (bytes == 0) {
            return;
        }
        throw new IOException(String.format("No data, can't skip %d bytes", bytes));
    }

    public void done() {
    }

    public int readInt() throws IOException {
        if (this.longBuffer == null) {
            this.longBuffer = new byte[8];
        }
        byte[] b = this.longBuffer;
        this.readBytes(b, 0, 4);
        return b[0] << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
    }

    public long readLong() throws IOException {
        if (this.longBuffer == null) {
            this.longBuffer = new byte[8];
        }
        byte[] b = this.longBuffer;
        this.readBytes(b, 0, 8);
        int i1 = b[0] << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
        int i2 = b[4] << 24 | (b[5] & 0xFF) << 16 | (b[6] & 0xFF) << 8 | b[7] & 0xFF;
        return (long)i1 << 32 | (long)i2 & 0xFFFFFFFFL;
    }

    public void readBytes(byte[] buf, int offset, int length) throws IOException {
        if (length == 0) {
            return;
        }
        throw new IOException(String.format("No data, can't read %d bytes", length));
    }

    public void readBytes(ByteBuffer buf) throws IOException {
        while (!this.isEmpty() && buf.hasRemaining()) {
            buf.put(this.readByte());
        }
    }

    public byte readByte() throws IOException {
        throw new UnsupportedOperationException();
    }

    public byte[] byteArray() throws IOException {
        this.reset();
        byte[] rv = new byte[this.length()];
        this.readBytes(rv, 0, rv.length);
        return rv;
    }
}

