/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.IOException;
import java.io.InputStream;
import org.tmatesoft.hg.internal.DataAccess;

public class DataAccessInputStream
extends InputStream {
    private final DataAccess da;
    private int bytesLeft = -1;

    public DataAccessInputStream(DataAccess dataAccess) {
        this.da = dataAccess;
    }

    @Override
    public int available() throws IOException {
        this.initAvailable();
        return this.bytesLeft;
    }

    @Override
    public int read() throws IOException {
        this.initAvailable();
        if (this.bytesLeft == 0) {
            return -1;
        }
        byte rv = this.da.readByte();
        --this.bytesLeft;
        return rv;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.initAvailable();
        if (this.bytesLeft == 0) {
            return -1;
        }
        if (len == 0) {
            return 0;
        }
        int x = Math.min(len, this.bytesLeft);
        this.da.readBytes(b, off, x);
        this.bytesLeft -= x;
        return x;
    }

    private void initAvailable() throws IOException {
        this.da.reset();
        if (this.bytesLeft == -1) {
            this.bytesLeft = this.da.length();
        }
    }
}

