/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.core.SessionContext;
import org.tmatesoft.hg.internal.DataAccess;
import org.tmatesoft.hg.internal.DataSerializer;
import org.tmatesoft.hg.internal.FileUtils;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.internal.PropertyMarshal;
import org.tmatesoft.hg.internal.Transaction;
import org.tmatesoft.hg.util.LogFacility;

public class DataAccessProvider {
    public static final String CFG_PROPERTY_MAPIO_LIMIT = "hg4j.dap.mapio_limit";
    public static final String CFG_PROPERTY_MAPIO_BUFFER_SIZE = "hg4j.dap.mapio_buffer";
    public static final String CFG_PROPERTY_FILE_BUFFER_SIZE = "hg4j.dap.file_buffer";
    private static final int DEFAULT_MAPIO_LIMIT = 102400;
    private static final int DEFAULT_FILE_BUFFER = 8192;
    private static final int DEFAULT_MAPIO_BUFFER = 102400;
    private final int mapioMagicBoundary;
    private final int bufferSize;
    private final int mapioBufSize;
    private final SessionContext context;

    public DataAccessProvider(SessionContext ctx) {
        this.context = ctx;
        PropertyMarshal pm = new PropertyMarshal(ctx);
        this.mapioMagicBoundary = DataAccessProvider.mapioBoundaryValue(pm.getInt(CFG_PROPERTY_MAPIO_LIMIT, 102400));
        this.bufferSize = pm.getInt(CFG_PROPERTY_FILE_BUFFER_SIZE, 8192);
        this.mapioBufSize = pm.getInt(CFG_PROPERTY_MAPIO_BUFFER_SIZE, 102400);
    }

    public DataAccessProvider(SessionContext ctx, int mapioBoundary, int regularBufferSize, int mapioBufferSize) {
        this.context = ctx;
        this.mapioMagicBoundary = DataAccessProvider.mapioBoundaryValue(mapioBoundary);
        this.bufferSize = regularBufferSize;
        this.mapioBufSize = mapioBufferSize;
    }

    private static int mapioBoundaryValue(int mapioBoundary) {
        return mapioBoundary == 0 ? Integer.MAX_VALUE : mapioBoundary;
    }

    public DataAccess createReader(File f, boolean shortRead) {
        if (!f.exists()) {
            return new DataAccess();
        }
        try {
            FileInputStream fis = new FileInputStream(f);
            long flen = f.length();
            if (!shortRead && flen > (long)this.mapioMagicBoundary) {
                return new MemoryMapFileAccess(fis, flen, this.mapioBufSize, this.context.getLog());
            }
            boolean useDirectBuffer = false;
            return new FileAccess(fis, flen, this.bufferSize, useDirectBuffer, this.context.getLog());
        }
        catch (IOException ex) {
            this.context.getLog().dump(this.getClass(), LogFacility.Severity.Error, ex, null);
            return new DataAccess();
        }
    }

    public DataSerializer createWriter(Transaction tr, File f, boolean createNewIfDoesntExist) {
        if (!f.exists() && !createNewIfDoesntExist) {
            return new DataSerializer();
        }
        return new TransactionAwareFileSerializer(tr, f);
    }

    private static class FileAccess
    extends DataAccess {
        private FileInputStream fileStream;
        private FileChannel fileChannel;
        private ByteBuffer buffer;
        private long bufferStartInFile = 0L;
        private final long size;
        private final LogFacility logFacility;

        public FileAccess(FileInputStream fis, long channelSize, int bufferSizeHint, boolean useDirect, LogFacility log) {
            this.fileStream = fis;
            this.fileChannel = fis.getChannel();
            this.size = channelSize;
            this.logFacility = log;
            int capacity = this.size < (long)bufferSizeHint ? (int)this.size : bufferSizeHint;
            this.buffer = useDirect ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
            this.buffer.flip();
        }

        @Override
        public boolean isEmpty() {
            return this.bufferStartInFile + (long)this.buffer.position() >= this.size;
        }

        @Override
        public DataAccess reset() throws IOException {
            this.longSeek(0L);
            return this;
        }

        @Override
        public int length() {
            return Internals.ltoi(this.longLength());
        }

        @Override
        public long longLength() {
            return this.size;
        }

        @Override
        public void longSeek(long offset) throws IOException {
            if (offset > this.size) {
                throw new IllegalArgumentException(String.format("Can't seek to %d for the file of size %d (buffer start:%d)", offset, this.size, this.bufferStartInFile));
            }
            if (offset < this.bufferStartInFile + (long)this.buffer.limit() && offset >= this.bufferStartInFile) {
                this.buffer.position(Internals.ltoi(offset - this.bufferStartInFile));
            } else {
                this.bufferStartInFile = offset;
                this.buffer.clear();
                this.buffer.limit(0);
                this.fileChannel.position(offset);
            }
        }

        @Override
        public void seek(int offset) throws IOException {
            this.longSeek(offset);
        }

        @Override
        public void skip(int bytes) throws IOException {
            int newPos = this.buffer.position() + bytes;
            if (newPos >= 0 && newPos < this.buffer.limit()) {
                this.buffer.position(newPos);
            } else {
                this.longSeek(this.bufferStartInFile + (long)newPos);
            }
        }

        private boolean fill() throws IOException {
            if (!this.buffer.hasRemaining()) {
                this.bufferStartInFile += (long)this.buffer.limit();
                this.buffer.clear();
                if (this.bufferStartInFile < this.size) {
                    this.fileChannel.read(this.buffer);
                }
                this.buffer.flip();
            }
            return this.buffer.hasRemaining();
        }

        @Override
        public void readBytes(byte[] buf, int offset, int length) throws IOException {
            if (!this.buffer.hasRemaining()) {
                this.fill();
            }
            while (length > 0) {
                int tail = this.buffer.remaining();
                if (tail == 0) {
                    throw new IOException();
                }
                if (tail >= length) {
                    this.buffer.get(buf, offset, length);
                } else {
                    this.buffer.get(buf, offset, tail);
                    this.fill();
                }
                offset += tail;
                length -= tail;
            }
        }

        @Override
        public byte readByte() throws IOException {
            if (this.buffer.hasRemaining()) {
                return this.buffer.get();
            }
            if (this.fill()) {
                return this.buffer.get();
            }
            throw new IOException();
        }

        @Override
        public void done() {
            this.buffer = null;
            if (this.fileStream != null) {
                new FileUtils(this.logFacility, this).closeQuietly(this.fileStream);
                this.fileStream = null;
                this.fileChannel = null;
            }
        }
    }

    private static class MemoryMapFileAccess
    extends DataAccess {
        private FileInputStream fileStream;
        private FileChannel fileChannel;
        private long position = 0L;
        private MappedByteBuffer buffer;
        private final long size;
        private final int memBufferSize;
        private final LogFacility logFacility;

        public MemoryMapFileAccess(FileInputStream fis, long channelSize, int bufferSize, LogFacility log) {
            this.fileStream = fis;
            this.fileChannel = fis.getChannel();
            this.size = channelSize;
            this.logFacility = log;
            this.memBufferSize = (long)bufferSize > channelSize ? (int)channelSize : bufferSize;
        }

        @Override
        public boolean isEmpty() {
            return this.position + (long)(this.buffer == null ? 0 : this.buffer.position()) >= this.size;
        }

        @Override
        public DataAccess reset() throws IOException {
            this.longSeek(0L);
            return this;
        }

        @Override
        public int length() {
            return Internals.ltoi(this.longLength());
        }

        @Override
        public long longLength() {
            return this.size;
        }

        @Override
        public void longSeek(long offset) {
            assert (offset >= 0L);
            if (this.buffer != null && offset >= this.position && offset - this.position < (long)this.buffer.limit()) {
                this.buffer.position(Internals.ltoi(offset - this.position));
            } else {
                this.position = offset;
                this.buffer = null;
            }
        }

        @Override
        public void seek(int offset) {
            this.longSeek(offset);
        }

        @Override
        public void skip(int bytes) throws IOException {
            assert (bytes >= 0);
            if (this.buffer == null) {
                this.position += (long)bytes;
                return;
            }
            if (this.buffer.remaining() > bytes) {
                this.buffer.position(this.buffer.position() + bytes);
            } else {
                this.position += (long)(this.buffer.position() + bytes);
                this.buffer = null;
            }
        }

        private void fill() throws IOException {
            if (this.buffer != null) {
                this.position += (long)this.buffer.position();
            }
            long left = this.size - this.position;
            int i = 0;
            while (i < 3) {
                try {
                    this.buffer = this.fileChannel.map(FileChannel.MapMode.READ_ONLY, this.position, left < (long)this.memBufferSize ? left : (long)this.memBufferSize);
                    return;
                }
                catch (IOException ex) {
                    if (i == 2) {
                        throw ex;
                    }
                    if (i == 0) {
                        this.logFacility.dump(this.getClass(), LogFacility.Severity.Warn, ex, "Memory-map failed, gonna try gc() to free virtual memory");
                    }
                    try {
                        this.buffer = null;
                        System.gc();
                        Thread.sleep((1 + i) * 1000);
                    }
                    catch (Throwable t) {
                        this.logFacility.dump(this.getClass(), LogFacility.Severity.Error, t, "Bad luck");
                    }
                    ++i;
                }
            }
        }

        @Override
        public void readBytes(byte[] buf, int offset, int length) throws IOException {
            if (this.buffer == null || !this.buffer.hasRemaining()) {
                this.fill();
            }
            while (length > 0) {
                int tail = this.buffer.remaining();
                if (tail == 0) {
                    throw new IOException();
                }
                if (tail >= length) {
                    this.buffer.get(buf, offset, length);
                } else {
                    this.buffer.get(buf, offset, tail);
                    this.fill();
                }
                offset += tail;
                length -= tail;
            }
        }

        @Override
        public byte readByte() throws IOException {
            if (this.buffer == null || !this.buffer.hasRemaining()) {
                this.fill();
            }
            if (this.buffer.hasRemaining()) {
                return this.buffer.get();
            }
            throw new IOException();
        }

        @Override
        public void done() {
            this.buffer = null;
            if (this.fileStream != null) {
                new FileUtils(this.logFacility, this).closeQuietly(this.fileStream);
                this.fileStream = null;
                this.fileChannel = null;
            }
        }
    }

    private static class TransactionAwareFileSerializer
    extends DataSerializer {
        private final Transaction transaction;
        private final File file;
        private FileOutputStream fos;
        private File transactionFile;
        private boolean writeFailed = false;

        public TransactionAwareFileSerializer(Transaction tr, File f) {
            this.transaction = tr;
            this.file = f;
        }

        @Override
        public void write(byte[] data, int offset, int length) throws HgIOException {
            try {
                if (this.fos == null) {
                    this.transactionFile = this.transaction.prepare(this.file);
                    this.fos = new FileOutputStream(this.transactionFile, true);
                }
                this.fos.write(data, offset, length);
                this.fos.flush();
            }
            catch (IOException ex) {
                this.writeFailed = true;
                this.transaction.failure(this.transactionFile, ex);
                throw new HgIOException("Write failure", ex, this.transactionFile);
            }
        }

        @Override
        public void done() throws HgIOException {
            if (this.fos != null) {
                assert (this.transactionFile != null);
                try {
                    this.fos.close();
                    if (!this.writeFailed) {
                        this.transaction.done(this.transactionFile);
                    }
                    this.fos = null;
                }
                catch (IOException ex) {
                    if (!this.writeFailed) {
                        this.transaction.failure(this.transactionFile, ex);
                    }
                    throw new HgIOException("Write failure", ex, this.transactionFile);
                }
            }
        }
    }
}

