/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.repo.HgRuntimeException;

public class DataSerializer {
    private byte[] buffer;

    public void writeByte(byte ... values) throws HgIOException {
        this.write(values, 0, values.length);
    }

    public void writeInt(int ... values) throws HgIOException {
        this.ensureBufferSize(4 * values.length);
        int idx = 0;
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int v = nArray[n2];
            DataSerializer.bigEndian(v, this.buffer, idx);
            idx += 4;
            ++n2;
        }
        this.write(this.buffer, 0, idx);
    }

    public void write(byte[] data, int offset, int length) throws HgIOException {
        throw new HgIOException("Attempt to write to non-existent file", null);
    }

    public void done() throws HgIOException {
    }

    private void ensureBufferSize(int bytesNeeded) {
        if (this.buffer == null || this.buffer.length < bytesNeeded) {
            this.buffer = new byte[bytesNeeded];
        }
    }

    public static final void bigEndian(int value, byte[] buffer, int offset) {
        assert (offset + 4 <= buffer.length);
        buffer[offset++] = (byte)(value >>> 24 & 0xFF);
        buffer[offset++] = (byte)(value >>> 16 & 0xFF);
        buffer[offset++] = (byte)(value >>> 8 & 0xFF);
        buffer[offset++] = (byte)(value & 0xFF);
    }

    public static class ByteArrayDataSource
    implements DataSource {
        private final byte[] data;

        public ByteArrayDataSource(byte[] bytes) {
            this.data = bytes;
        }

        @Override
        public void serialize(DataSerializer out) throws HgIOException {
            if (this.data != null) {
                out.write(this.data, 0, this.data.length);
            }
        }

        @Override
        public int serializeLength() {
            return this.data == null ? 0 : this.data.length;
        }
    }

    public static class ByteArraySerializer
    extends DataSerializer {
        private final ByteArrayOutputStream out = new ByteArrayOutputStream();

        @Override
        public void write(byte[] data, int offset, int length) {
            this.out.write(data, offset, length);
        }

        public byte[] toByteArray() {
            return this.out.toByteArray();
        }
    }

    public static interface DataSource {
        public void serialize(DataSerializer var1) throws HgIOException, HgRuntimeException;

        public int serializeLength() throws HgRuntimeException;
    }

    public static class OutputStreamSerializer
    extends DataSerializer {
        private final OutputStream out;

        public OutputStreamSerializer(OutputStream outputStream) {
            this.out = outputStream;
        }

        @Override
        public void write(byte[] data, int offset, int length) throws HgIOException {
            try {
                this.out.write(data, offset, length);
            }
            catch (IOException ex) {
                throw new HgIOException(ex.getMessage(), ex, null);
            }
        }
    }
}

