/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.util.zip.Deflater;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.internal.DataSerializer;

class DeflaterDataSerializer
extends DataSerializer {
    private static final int AUX_BUFFER_CAPACITY = 5;
    private final DataSerializer delegate;
    private final Deflater deflater;
    private final byte[] deflateOutBuffer;
    private final byte[] auxBuffer;

    public DeflaterDataSerializer(DataSerializer delegateSerializer, Deflater def, int bufferSizeHint) {
        this.delegate = delegateSerializer;
        this.deflater = def;
        this.deflateOutBuffer = new byte[bufferSizeHint <= 0 ? 2048 : bufferSizeHint];
        this.auxBuffer = new byte[20];
    }

    @Override
    public void writeInt(int ... values) throws HgIOException {
        int i = 0;
        while (i < values.length) {
            int idx = 0;
            int j = i;
            int x = Math.min(values.length, i + 5);
            while (j < x) {
                int v = values[j];
                this.auxBuffer[idx++] = (byte)(v >>> 24 & 0xFF);
                this.auxBuffer[idx++] = (byte)(v >>> 16 & 0xFF);
                this.auxBuffer[idx++] = (byte)(v >>> 8 & 0xFF);
                this.auxBuffer[idx++] = (byte)(v & 0xFF);
                ++j;
            }
            this.internalWrite(this.auxBuffer, 0, idx);
            i += 5;
        }
    }

    @Override
    public void write(byte[] data, int offset, int length) throws HgIOException {
        int stride = this.deflateOutBuffer.length;
        int i = 0;
        while (i < length) {
            this.internalWrite(data, offset + i, Math.min(stride, length - i));
            i += stride;
        }
    }

    private void internalWrite(byte[] data, int offset, int length) throws HgIOException {
        this.deflater.setInput(data, offset, length);
        while (!this.deflater.needsInput()) {
            this.deflate();
        }
    }

    @Override
    public void done() throws HgIOException {
        this.delegate.done();
    }

    public void finish() throws HgIOException {
        if (!this.deflater.finished()) {
            this.deflater.finish();
            while (!this.deflater.finished()) {
                this.deflate();
            }
        }
    }

    protected void deflate() throws HgIOException {
        int len = this.deflater.deflate(this.deflateOutBuffer, 0, this.deflateOutBuffer.length);
        if (len > 0) {
            this.delegate.write(this.deflateOutBuffer, 0, len);
        }
    }
}

