/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.hg.internal.IntMap;
import org.tmatesoft.hg.internal.IntSliceSeq;
import org.tmatesoft.hg.internal.IntTuple;
import org.tmatesoft.hg.internal.IntVector;

public class DiffHelper<T extends ChunkSequence<?>> {
    private Map<Object, IntVector> chunk2UseIndex;
    private T seq1;
    private T seq2;
    private int matchStartS1;
    private int matchStartS2;
    private MatchInspector<T> matchInspector;

    public void init(T s1, T s2) {
        this.seq1 = s1;
        this.seq2 = s2;
        this.prepare(s2);
    }

    public void init(T s1) {
        if (this.seq2 == null) {
            throw new IllegalStateException("Use this #init() only when target sequence shall be matched against different origin");
        }
        this.seq1 = s1;
    }

    private void prepare(T s2) {
        this.chunk2UseIndex = new HashMap<Object, IntVector>();
        int i = 0;
        int len = s2.chunkCount();
        while (i < len) {
            Object bc = s2.chunk(i);
            IntVector loc = this.chunk2UseIndex.get(bc);
            if (loc == null) {
                loc = new IntVector();
                this.chunk2UseIndex.put(bc, loc);
            }
            loc.add(i);
            ++i;
        }
    }

    public void findMatchingBlocks(MatchInspector<T> insp) {
        insp.begin(this.seq1, this.seq2);
        this.matchInspector = insp;
        this.findMatchingBlocks(0, this.seq1.chunkCount(), 0, this.seq2.chunkCount());
        insp.end();
    }

    void findAllMatchAlternatives(final MatchInspector<T> insp) {
        IntSliceSeq nextCheck;
        DeltaInspector myInsp;
        assert (this.seq1.chunkCount() > 0);
        final IntSliceSeq insertions = new IntSliceSeq(2);
        final boolean[] matchedAny = new boolean[1];
        this.matchInspector = myInsp = new DeltaInspector<T>(){

            @Override
            protected void unchanged(int s1From, int s2From, int length) {
                matchedAny[0] = true;
                insp.match(s1From, s2From, length);
            }

            @Override
            protected void added(int s1InsertPoint, int s2From, int s2To) {
                insertions.add(s2From, s2To);
            }
        };
        myInsp.begin(this.seq1, this.seq2);
        IntSliceSeq s2RangesToCheck = new IntSliceSeq(2, 1, 0);
        s2RangesToCheck.add(0, this.seq2.chunkCount());
        do {
            nextCheck = new IntSliceSeq(2);
            for (IntTuple t : s2RangesToCheck) {
                int s2Start = t.at(0);
                int s2End = t.at(1);
                myInsp.changeStartS1 = 0;
                myInsp.changeStartS2 = s2Start;
                insp.begin(this.seq1, this.seq2);
                matchedAny[0] = false;
                this.findMatchingBlocks(0, this.seq1.chunkCount(), s2Start, s2End);
                insp.end();
                myInsp.end();
                if (matchedAny[0]) {
                    nextCheck.addAll(insertions);
                }
                insertions.clear();
            }
        } while ((s2RangesToCheck = nextCheck).size() > 0);
    }

    public int longestMatch(int startS1, int endS1, int startS2, int endS2) {
        this.matchStartS2 = 0;
        this.matchStartS1 = 0;
        int maxLength = 0;
        IntMap chunkIndex2MatchCount = new IntMap(8);
        int i = startS1;
        while (i < endS1) {
            Object bc = this.seq1.chunk(i);
            IntVector occurencesInS2 = this.chunk2UseIndex.get(bc);
            if (occurencesInS2 == null) {
                chunkIndex2MatchCount.clear();
            } else {
                IntMap<Integer> newChunkIndex2MatchCount = new IntMap<Integer>(8);
                int[] nArray = occurencesInS2.toArray();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int j = nArray[n2];
                    if (j >= startS2) {
                        if (j >= endS2) break;
                        int prevChunkMatches = chunkIndex2MatchCount.containsKey(j - 1) ? (Integer)chunkIndex2MatchCount.get(j - 1) : 0;
                        int k = prevChunkMatches + 1;
                        newChunkIndex2MatchCount.put(j, k);
                        if (k > maxLength) {
                            this.matchStartS1 = i - k + 1;
                            this.matchStartS2 = j - k + 1;
                            maxLength = k;
                        }
                    }
                    ++n2;
                }
                chunkIndex2MatchCount = newChunkIndex2MatchCount;
            }
            ++i;
        }
        return maxLength;
    }

    private void findMatchingBlocks(int startS1, int endS1, int startS2, int endS2) {
        int matchLength = this.longestMatch(startS1, endS1, startS2, endS2);
        if (matchLength > 0) {
            int saveStartS1 = this.matchStartS1;
            int saveStartS2 = this.matchStartS2;
            if (startS1 < this.matchStartS1 && startS2 < this.matchStartS2) {
                this.findMatchingBlocks(startS1, this.matchStartS1, startS2, this.matchStartS2);
            }
            this.matchInspector.match(saveStartS1, saveStartS2, matchLength);
            if (saveStartS1 + matchLength < endS1 && saveStartS2 + matchLength < endS2) {
                this.findMatchingBlocks(saveStartS1 + matchLength, endS1, saveStartS2 + matchLength, endS2);
            }
        }
    }

    public static interface ChunkSequence<T> {
        public T chunk(int var1);

        public int chunkCount();
    }

    public static class DeltaDumpInspector<T extends ChunkSequence<?>>
    extends DeltaInspector<T> {
        @Override
        protected void changed(int s1From, int s1To, int s2From, int s2To) {
            System.out.printf("changed [%d..%d) with [%d..%d)\n", s1From, s1To, s2From, s2To);
        }

        @Override
        protected void deleted(int s2DeletionPoint, int s1From, int s1To) {
            System.out.printf("deleted [%d..%d)\n", s1From, s1To);
        }

        @Override
        protected void added(int s1InsertPoint, int s2From, int s2To) {
            System.out.printf("added [%d..%d) at %d\n", s2From, s2To, s1InsertPoint);
        }

        @Override
        protected void unchanged(int s1From, int s2From, int length) {
            System.out.printf("same [%d..%d) and [%d..%d)\n", s1From, s1From + length, s2From, s2From + length);
        }
    }

    public static class DeltaInspector<T extends ChunkSequence<?>>
    implements MatchInspector<T> {
        protected int changeStartS1;
        protected int changeStartS2;
        protected T seq1;
        protected T seq2;

        @Override
        public void begin(T s1, T s2) {
            this.seq1 = s1;
            this.seq2 = s2;
            this.changeStartS2 = 0;
            this.changeStartS1 = 0;
        }

        @Override
        public void match(int startSeq1, int startSeq2, int matchLength) {
            this.reportDeltaElement(startSeq1, startSeq2, matchLength);
            this.changeStartS1 = startSeq1 + matchLength;
            this.changeStartS2 = startSeq2 + matchLength;
        }

        @Override
        public void end() {
            if (this.changeStartS1 < this.seq1.chunkCount() - 1 || this.changeStartS2 < this.seq2.chunkCount() - 1) {
                this.reportDeltaElement(this.seq1.chunkCount() - 1, this.seq2.chunkCount() - 1, 0);
            }
        }

        protected void reportDeltaElement(int matchStartSeq1, int matchStartSeq2, int matchLength) {
            if (this.changeStartS1 < matchStartSeq1) {
                if (this.changeStartS2 < matchStartSeq2) {
                    this.changed(this.changeStartS1, matchStartSeq1, this.changeStartS2, matchStartSeq2);
                } else {
                    assert (this.changeStartS2 == matchStartSeq2);
                    this.deleted(matchStartSeq2, this.changeStartS1, matchStartSeq1);
                }
            } else {
                assert (this.changeStartS1 == matchStartSeq1);
                if (this.changeStartS2 < matchStartSeq2) {
                    this.added(this.changeStartS1, this.changeStartS2, matchStartSeq2);
                } else {
                    assert (this.changeStartS2 == matchStartSeq2);
                    if (matchStartSeq1 > 0 || matchStartSeq2 > 0) assert (false) : String.format("adjustent equal blocks %d, %d and %d,%d", this.changeStartS1, matchStartSeq1, this.changeStartS2, matchStartSeq2);
                }
            }
            if (matchLength > 0) {
                this.unchanged(matchStartSeq1, matchStartSeq2, matchLength);
            }
        }

        protected void changed(int s1From, int s1To, int s2From, int s2To) {
        }

        protected void deleted(int s2DeletePoint, int s1From, int s1To) {
        }

        protected void added(int s1InsertPoint, int s2From, int s2To) {
        }

        protected void unchanged(int s1From, int s2From, int length) {
        }
    }

    public static final class LineSequence
    implements ChunkSequence<ByteChain> {
        private final byte[] input;
        private ArrayList<ByteChain> lines;

        public LineSequence(byte[] data) {
            this.input = data;
        }

        public static LineSequence newlines(byte[] array) {
            return new LineSequence(array).splitByNewlines();
        }

        public LineSequence splitByNewlines() {
            this.lines = new ArrayList();
            int lastStart = 0;
            int i = 0;
            while (i < this.input.length) {
                if (this.input[i] == 10) {
                    this.lines.add(new ByteChain(lastStart, i + 1));
                    lastStart = i + 1;
                } else if (this.input[i] == 13) {
                    if (i + 1 < this.input.length && this.input[i + 1] == 10) {
                        ++i;
                    }
                    this.lines.add(new ByteChain(lastStart, i + 1));
                    lastStart = i + 1;
                }
                ++i;
            }
            if (lastStart < this.input.length) {
                this.lines.add(new ByteChain(lastStart, this.input.length));
            }
            this.lines.add(new ByteChain(this.input.length));
            return this;
        }

        @Override
        public ByteChain chunk(int index) {
            return this.lines.get(index);
        }

        @Override
        public int chunkCount() {
            return this.lines.size();
        }

        public byte[] data(int chunkFrom, int chunkTo) {
            if (chunkFrom == chunkTo) {
                return new byte[0];
            }
            int from = this.chunk(chunkFrom).getOffset();
            int to = this.chunk(chunkTo).getOffset();
            byte[] rv = new byte[to - from];
            System.arraycopy(this.input, from, rv, 0, rv.length);
            return rv;
        }

        static int calcHash(byte[] data, int from, int to) {
            int result = 1;
            int i = from;
            while (i < to) {
                result = 31 * result + data[i];
                ++i;
            }
            return result;
        }

        public final class ByteChain {
            private final int start;
            private final int end;
            private final int hash;

            ByteChain(int offset) {
                this.start = this.end = offset;
                this.hash = System.identityHashCode(this);
            }

            ByteChain(int s, int e) {
                this.start = s;
                this.end = e;
                this.hash = LineSequence.calcHash(LineSequence.this.input, s, e);
            }

            public int getOffset() {
                return this.start;
            }

            public byte[] data() {
                byte[] rv = new byte[this.end - this.start];
                System.arraycopy(LineSequence.this.input, this.start, rv, 0, rv.length);
                return rv;
            }

            public boolean equals(Object obj) {
                if (obj == null || obj.getClass() != ByteChain.class) {
                    return false;
                }
                ByteChain other = (ByteChain)obj;
                if (other.hash != this.hash || other.end - other.start != this.end - this.start) {
                    return false;
                }
                return other.match(LineSequence.this.input, this.start);
            }

            private boolean match(byte[] oi, int from) {
                int i = this.start;
                int j = from;
                while (i < this.end) {
                    if (LineSequence.this.input[i] != oi[j]) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
                return true;
            }

            public int hashCode() {
                return this.hash;
            }

            public String toString() {
                return String.format("[@%d\"%s\"]", this.start, new String(this.data()));
            }
        }
    }

    static class MatchDumpInspector<T extends ChunkSequence<?>>
    implements MatchInspector<T> {
        private int matchCount;

        MatchDumpInspector() {
        }

        @Override
        public void begin(T s1, T s2) {
            this.matchCount = 0;
        }

        @Override
        public void match(int startSeq1, int startSeq2, int matchLength) {
            ++this.matchCount;
            System.out.printf("match #%d: from line #%d  and line #%d of length %d\n", this.matchCount, startSeq1, startSeq2, matchLength);
        }

        @Override
        public void end() {
            if (this.matchCount == 0) {
                System.out.println("NO MATCHES FOUND!");
            }
        }
    }

    public static interface MatchInspector<T extends ChunkSequence<?>> {
        public void begin(T var1, T var2);

        public void match(int var1, int var2, int var3);

        public void end();
    }
}

