/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.repo.HgInvalidStateException;

public class DigestHelper {
    private MessageDigest sha1;
    private byte[] digest;

    private MessageDigest getSHA1() {
        if (this.sha1 == null) {
            try {
                this.sha1 = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException ex) {
                HgInvalidStateException t = new HgInvalidStateException("Need SHA-1 algorithm for nodeid calculation");
                t.initCause(ex);
                throw t;
            }
        }
        return this.sha1;
    }

    public DigestHelper sha1(Nodeid nodeid1, Nodeid nodeid2, byte[] data) {
        return this.sha1(nodeid1.toByteArray(), nodeid2.toByteArray(), data);
    }

    public DigestHelper sha1(byte[] nodeidParent1, byte[] nodeidParent2, byte[] data) {
        MessageDigest alg = this.getSHA1();
        if ((nodeidParent1[0] & 0xFF) < (nodeidParent2[0] & 0xFF)) {
            alg.update(nodeidParent1);
            alg.update(nodeidParent2);
        } else {
            alg.update(nodeidParent2);
            alg.update(nodeidParent1);
        }
        this.digest = alg.digest(data);
        assert (this.digest.length == 20);
        return this;
    }

    public String asHexString() {
        if (this.digest == null) {
            throw new IllegalStateException("Shall init with sha1() call first");
        }
        return DigestHelper.toHexString(this.digest, 0, this.digest.length);
    }

    public byte[] asBinary() {
        if (this.digest == null) {
            throw new IllegalStateException("Shall init with sha1() call first");
        }
        return this.digest;
    }

    public DigestHelper sha1(InputStream is) throws IOException {
        int c;
        MessageDigest alg = this.getSHA1();
        byte[] buf = new byte[1024];
        while ((c = is.read(buf)) != -1) {
            alg.update(buf, 0, c);
        }
        this.digest = alg.digest();
        return this;
    }

    public DigestHelper sha1(CharSequence ... seq) {
        MessageDigest alg = this.getSHA1();
        CharSequence[] charSequenceArray = seq;
        int n = seq.length;
        int n2 = 0;
        while (n2 < n) {
            CharSequence s = charSequenceArray[n2];
            byte[] b = s.toString().getBytes();
            alg.update(b);
            ++n2;
        }
        this.digest = alg.digest();
        return this;
    }

    public static String toHexString(byte[] data, int offset, int count) {
        char[] result = new char[count << 1];
        int end = offset + count;
        int i = offset;
        int j = 0;
        while (i < end) {
            result[j++] = "0123456789abcdef".charAt(data[i] >>> 4 & 0xF);
            result[j++] = "0123456789abcdef".charAt(data[i] & 0xF);
            ++i;
        }
        return new String(result);
    }

    public static boolean ascii2bin(byte[] ascii, int offset, int len, byte[] binary) {
        assert (len % 2 == 0);
        assert (binary.length >= len >>> 1);
        boolean zeroBytes = true;
        int i = 0;
        int j = offset;
        while (i < len >>> 1) {
            int lowNibble;
            int b;
            int hiNibble = (b = ascii[j++] & 0xCF) > 64 ? b - 55 : b;
            b = ascii[j++] & 0xCF;
            int n = lowNibble = b > 64 ? b - 55 : b;
            if (hiNibble >= 16 || lowNibble >= 16) {
                throw new IllegalArgumentException(String.format("Characters '%c%c' (%1$d and %2$d) at index %d are not valid hex digits", ascii[j - 2], ascii[j - 1], j - 2));
            }
            b = (hiNibble << 4 | lowNibble) & 0xFF;
            binary[i] = (byte)b;
            zeroBytes = zeroBytes && b == 0;
            ++i;
        }
        return zeroBytes;
    }
}

