/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.DirstateReader;
import org.tmatesoft.hg.internal.EncodingHelper;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.internal.Transaction;
import org.tmatesoft.hg.repo.HgDirstate;
import org.tmatesoft.hg.repo.HgInvalidControlFileException;
import org.tmatesoft.hg.repo.HgInvalidStateException;
import org.tmatesoft.hg.repo.HgManifest;
import org.tmatesoft.hg.repo.HgRepositoryFiles;
import org.tmatesoft.hg.util.Path;

public class DirstateBuilder {
    private Map<Path, HgDirstate.Record> normal = new TreeMap<Path, HgDirstate.Record>();
    private Map<Path, HgDirstate.Record> added = new TreeMap<Path, HgDirstate.Record>();
    private Map<Path, HgDirstate.Record> removed = new TreeMap<Path, HgDirstate.Record>();
    private Map<Path, HgDirstate.Record> merged = new TreeMap<Path, HgDirstate.Record>();
    private Nodeid parent1;
    private Nodeid parent2;
    private final Internals hgRepo;
    private final EncodingHelper encodingHelper;

    public DirstateBuilder(Internals internalRepo) {
        this.hgRepo = internalRepo;
        this.encodingHelper = internalRepo.buildFileNameEncodingHelper();
    }

    public void parents(Nodeid p1, Nodeid p2) {
        this.parent1 = p1 == null ? Nodeid.NULL : p1;
        this.parent2 = p2 == null ? Nodeid.NULL : p2;
    }

    public void recordNormal(Path fname, int fmode, int mtime, int bytesWritten) {
        this.forget(fname);
        this.normal.put(fname, new HgDirstate.Record(fmode, bytesWritten, mtime, fname, null));
    }

    public void recordUncertain(Path fname) {
        this.forget(fname);
        this.normal.put(fname, new HgDirstate.Record(0, -1, -1, fname, null));
    }

    public void recordAdded(Path fname, HgManifest.Flags flags, int size) {
        this.forget(fname);
        this.added.put(fname, new HgDirstate.Record(0, -1, -1, fname, null));
    }

    public void recordRemoved(Path fname) {
        HgDirstate.Record r = this.forget(fname);
        HgDirstate.Record n = r == null ? new HgDirstate.Record(0, -1, -1, fname, null) : new HgDirstate.Record(r.mode(), r.size(), r.modificationTime(), fname, r.copySource());
        this.removed.put(fname, n);
    }

    private HgDirstate.Record forget(Path fname) {
        HgDirstate.Record r = this.normal.remove(fname);
        if (r != null) {
            return r;
        }
        r = this.added.remove(fname);
        if (r != null) {
            return r;
        }
        r = this.removed.remove(fname);
        if (r != null) {
            return r;
        }
        return this.merged.remove(fname);
    }

    public void serialize(WritableByteChannel dest) throws IOException {
        assert (this.parent1 != null) : "Parent(s) of the working directory shall be set first";
        ByteBuffer bb = ByteBuffer.allocate(256);
        bb.put(this.parent1.toByteArray());
        bb.put(this.parent2.toByteArray());
        bb.flip();
        int written = dest.write(bb);
        if (written != bb.limit()) {
            throw new IOException("Incomplete write");
        }
        bb.clear();
        Map[] all = new Map[]{this.normal, this.added, this.removed, this.merged};
        ByteBuffer recordTypes = ByteBuffer.allocate(4);
        recordTypes.put((byte)110).put((byte)97).put((byte)114).put((byte)109).flip();
        Map[] mapArray = all;
        int n = all.length;
        int n2 = 0;
        while (n2 < n) {
            Map m = mapArray[n2];
            byte recordType = recordTypes.get();
            for (HgDirstate.Record r : m.values()) {
                byte[] fname = this.encodingHelper.toDirstate(r.name());
                byte[] copyOrigin = r.copySource() == null ? null : this.encodingHelper.toDirstate(r.copySource());
                int length = fname.length + (copyOrigin == null ? 0 : 1 + copyOrigin.length);
                bb = DirstateBuilder.ensureCapacity(bb, 17 + length);
                bb.put(recordType);
                bb.putInt(r.mode());
                bb.putInt(r.size());
                bb.putInt(r.modificationTime());
                bb.putInt(length);
                bb.put(fname);
                if (copyOrigin != null) {
                    bb.put((byte)0);
                    bb.put(copyOrigin);
                }
                bb.flip();
                written = dest.write(bb);
                if (written != bb.limit()) {
                    throw new IOException("Incomplete write");
                }
                bb.clear();
            }
            ++n2;
        }
    }

    public void serialize(Transaction tr) throws HgIOException {
        File dirstateFile = tr.prepare(this.hgRepo.getRepositoryFile(HgRepositoryFiles.Dirstate), this.hgRepo.getRepositoryFile(HgRepositoryFiles.UndoDirstate));
        try {
            FileChannel dirstate = new FileOutputStream(dirstateFile).getChannel();
            this.serialize(dirstate);
            dirstate.close();
            tr.done(dirstateFile);
        }
        catch (IOException ex) {
            tr.failure(dirstateFile, ex);
            throw new HgIOException("Can't write down new directory state", ex, dirstateFile);
        }
    }

    public void fillFrom(DirstateReader dirstate) throws HgInvalidControlFileException {
        dirstate.readInto(new HgDirstate.Inspector(){

            @Override
            public boolean next(HgDirstate.EntryKind kind, HgDirstate.Record entry) {
                switch (kind) {
                    case Normal: {
                        DirstateBuilder.this.normal.put(entry.name(), entry);
                        break;
                    }
                    case Added: {
                        DirstateBuilder.this.added.put(entry.name(), entry);
                        break;
                    }
                    case Removed: {
                        DirstateBuilder.this.removed.put(entry.name(), entry);
                        break;
                    }
                    case Merged: {
                        DirstateBuilder.this.merged.put(entry.name(), entry);
                        break;
                    }
                    default: {
                        throw new HgInvalidStateException(String.format("Unexpected entry in the dirstate: %s", new Object[]{kind}));
                    }
                }
                return true;
            }
        });
        this.parents(dirstate.parents().first(), dirstate.parents().second());
    }

    private static ByteBuffer ensureCapacity(ByteBuffer buf, int cap) {
        if (buf.capacity() >= cap) {
            return buf;
        }
        return ByteBuffer.allocate(cap);
    }
}

