/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.DataAccess;
import org.tmatesoft.hg.internal.EncodingHelper;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.repo.HgDirstate;
import org.tmatesoft.hg.repo.HgInvalidControlFileException;
import org.tmatesoft.hg.repo.HgRepositoryFiles;
import org.tmatesoft.hg.util.LogFacility;
import org.tmatesoft.hg.util.Pair;
import org.tmatesoft.hg.util.Path;

public final class DirstateReader {
    private final Internals repo;
    private final Path.Source pathPool;
    private Pair<Nodeid, Nodeid> parents;

    public DirstateReader(Internals hgRepo, Path.Source pathSource) {
        this.repo = hgRepo;
        this.pathPool = pathSource;
    }

    public void readInto(HgDirstate.Inspector target) throws HgInvalidControlFileException {
        EncodingHelper encodingHelper = this.repo.buildFileNameEncodingHelper();
        this.parents = new Pair<Nodeid, Nodeid>(Nodeid.NULL, Nodeid.NULL);
        File dirstateFile = DirstateReader.getDirstateFile(this.repo);
        if (dirstateFile == null || !dirstateFile.exists()) {
            return;
        }
        DataAccess da = this.repo.getDataAccess().createReader(dirstateFile, false);
        try {
            if (da.isEmpty()) {
                return;
            }
            try {
                this.parents = DirstateReader.internalReadParents(da);
                while (!da.isEmpty()) {
                    byte state = da.readByte();
                    int fmode = da.readInt();
                    int size = da.readInt();
                    int time = da.readInt();
                    int nameLen = da.readInt();
                    String fn1 = null;
                    String fn2 = null;
                    byte[] name = new byte[nameLen];
                    da.readBytes(name, 0, nameLen);
                    int i = 0;
                    while (i < nameLen) {
                        if (name[i] == 0) {
                            fn1 = encodingHelper.fromDirstate(name, 0, i);
                            fn2 = encodingHelper.fromDirstate(name, i + 1, nameLen - i - 1);
                            break;
                        }
                        ++i;
                    }
                    if (fn1 == null) {
                        fn1 = encodingHelper.fromDirstate(name, 0, nameLen);
                    }
                    HgDirstate.Record r = new HgDirstate.Record(fmode, size, time, this.pathPool.path(fn1), fn2 == null ? null : this.pathPool.path(fn2));
                    if (state == 110) {
                        target.next(HgDirstate.EntryKind.Normal, r);
                        continue;
                    }
                    if (state == 97) {
                        target.next(HgDirstate.EntryKind.Added, r);
                        continue;
                    }
                    if (state == 114) {
                        target.next(HgDirstate.EntryKind.Removed, r);
                        continue;
                    }
                    if (state == 109) {
                        target.next(HgDirstate.EntryKind.Merged, r);
                        continue;
                    }
                    this.repo.getLog().dump(this.getClass(), LogFacility.Severity.Warn, "Dirstate record for file %s (size: %d, tstamp:%d) has unknown state '%c'", r.name(), r.size(), r.modificationTime(), state);
                }
            }
            catch (IOException ex) {
                throw new HgInvalidControlFileException("Dirstate read failed", ex, dirstateFile);
            }
        }
        finally {
            da.done();
        }
    }

    private static Pair<Nodeid, Nodeid> internalReadParents(DataAccess da) throws IOException {
        byte[] parents = new byte[40];
        da.readBytes(parents, 0, 40);
        Nodeid n1 = Nodeid.fromBinary(parents, 0);
        Nodeid n2 = Nodeid.fromBinary(parents, 20);
        parents = null;
        return new Pair<Nodeid, Nodeid>(n1, n2);
    }

    public Pair<Nodeid, Nodeid> parents() {
        assert (this.parents != null);
        return this.parents;
    }

    private static File getDirstateFile(Internals repo) {
        return repo.getFileFromRepoDir(HgRepositoryFiles.Dirstate.getName());
    }

    public static Pair<Nodeid, Nodeid> readParents(Internals internalRepo) throws HgInvalidControlFileException {
        File dirstateFile = DirstateReader.getDirstateFile(internalRepo);
        if (dirstateFile == null || !dirstateFile.exists()) {
            return new Pair<Nodeid, Nodeid>(Nodeid.NULL, Nodeid.NULL);
        }
        DataAccess da = internalRepo.getDataAccess().createReader(dirstateFile, false);
        try {
            if (da.isEmpty()) {
                Pair<Nodeid, Nodeid> pair = new Pair<Nodeid, Nodeid>(Nodeid.NULL, Nodeid.NULL);
                return pair;
            }
            Pair<Nodeid, Nodeid> pair = DirstateReader.internalReadParents(da);
            return pair;
        }
        catch (IOException ex) {
            throw new HgInvalidControlFileException("Error reading working copy parents from dirstate", ex, dirstateFile);
        }
        finally {
            da.done();
        }
    }

    public static String readBranch(Internals internalRepo) throws HgInvalidControlFileException {
        File branchFile = internalRepo.getRepositoryFile(HgRepositoryFiles.Branch);
        String branch = "default";
        if (branchFile.exists()) {
            try {
                BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(branchFile), EncodingHelper.getUTF8()));
                String b = r.readLine();
                if (b != null) {
                    b = b.trim().intern();
                }
                branch = b == null || b.length() == 0 ? "default" : b;
                r.close();
            }
            catch (FileNotFoundException ex) {
                internalRepo.getLog().dump(HgDirstate.class, LogFacility.Severity.Debug, ex, null);
            }
            catch (IOException ex) {
                throw new HgInvalidControlFileException("Error reading file with branch information", ex, branchFile);
            }
        }
        return branch;
    }
}

