/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.tmatesoft.hg.core.SessionContext;
import org.tmatesoft.hg.repo.HgInvalidStateException;
import org.tmatesoft.hg.util.LogFacility;

public class EncodingHelper {
    private final SessionContext sessionContext;
    private final CharsetEncoder encoder;
    private final CharsetDecoder decoder;
    private final CharsetEncoder utfEncoder;
    private final CharsetDecoder utfDecoder;

    EncodingHelper(Charset fsEncoding, SessionContext.Source ctx) {
        this.sessionContext = ctx.getSessionContext();
        this.decoder = fsEncoding.newDecoder();
        this.encoder = fsEncoding.newEncoder();
        Charset utf8 = EncodingHelper.getUTF8();
        if (fsEncoding.equals(utf8)) {
            this.utfDecoder = this.decoder;
            this.utfEncoder = this.encoder;
        } else {
            this.utfDecoder = utf8.newDecoder();
            this.utfEncoder = utf8.newEncoder();
        }
    }

    public String fromManifest(byte[] data, int start, int length) {
        return this.decodeWithSystemDefaultFallback(data, start, length);
    }

    public byte[] toManifest(CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        return this.toArray(this.encodeWithSystemDefaultFallback(s));
    }

    public String fromDirstate(byte[] data, int start, int length) {
        return this.decodeWithSystemDefaultFallback(data, start, length);
    }

    public byte[] toDirstate(CharSequence fname) {
        if (fname == null) {
            throw new IllegalArgumentException();
        }
        return this.toArray(this.encodeWithSystemDefaultFallback(fname));
    }

    public ByteBuffer toFNCache(CharSequence fname) {
        return this.encodeWithSystemDefaultFallback(fname);
    }

    public byte[] toBundle(CharSequence fname) {
        return this.toArray(this.encodeWithSystemDefaultFallback(fname));
    }

    public String fromBundle(byte[] data, int start, int length) {
        return this.decodeWithSystemDefaultFallback(data, start, length);
    }

    public String userFromChangeset(byte[] data, int start, int length) {
        return this.decodeUnicodeWithFallback(data, start, length);
    }

    public String commentFromChangeset(byte[] data, int start, int length) {
        return this.decodeUnicodeWithFallback(data, start, length);
    }

    public String fileFromChangeset(byte[] data, int start, int length) {
        return this.decodeWithSystemDefaultFallback(data, start, length);
    }

    public byte[] userToChangeset(CharSequence user) {
        return this.toArray(this.encodeUnicode(user));
    }

    public byte[] commentToChangeset(CharSequence comment) {
        return this.toArray(this.encodeUnicode(comment));
    }

    public byte[] fileToChangeset(CharSequence file) {
        return this.toArray(this.encodeWithSystemDefaultFallback(file));
    }

    private String decodeWithSystemDefaultFallback(byte[] data, int start, int length) {
        try {
            return this.decoder.decode(ByteBuffer.wrap(data, start, length)).toString();
        }
        catch (CharacterCodingException ex) {
            this.sessionContext.getLog().dump(this.getClass(), LogFacility.Severity.Error, ex, String.format("Use of charset %s failed, resort to system default", this.charset().name()));
            return new String(data, start, length);
        }
    }

    private ByteBuffer encodeWithSystemDefaultFallback(CharSequence s) {
        try {
            return this.encoder.encode(CharBuffer.wrap(s));
        }
        catch (CharacterCodingException ex) {
            this.sessionContext.getLog().dump(this.getClass(), LogFacility.Severity.Error, ex, String.format("Use of charset %s failed, resort to system default", this.charset().name()));
            return ByteBuffer.wrap(s.toString().getBytes());
        }
    }

    private byte[] toArray(ByteBuffer bb) {
        byte[] rv;
        if (bb.hasArray() && bb.arrayOffset() == 0 && (rv = bb.array()).length == bb.remaining()) {
            return rv;
        }
        rv = new byte[bb.remaining()];
        bb.get(rv, 0, rv.length);
        return rv;
    }

    private String decodeUnicodeWithFallback(byte[] data, int start, int length) {
        try {
            return this.utfDecoder.decode(ByteBuffer.wrap(data, start, length)).toString();
        }
        catch (CharacterCodingException ex) {
            try {
                return new String(data, start, length, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new HgInvalidStateException(ex.getMessage());
            }
        }
    }

    private ByteBuffer encodeUnicode(CharSequence s) {
        try {
            return this.utfEncoder.encode(CharBuffer.wrap(s));
        }
        catch (CharacterCodingException characterCodingException) {
            byte[] rv;
            try {
                rv = s.toString().getBytes(EncodingHelper.getUTF8().name());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new HgInvalidStateException("Unexpected error trying to get UTF-8 encoding");
            }
            return ByteBuffer.wrap(rv);
        }
    }

    private Charset charset() {
        return this.encoder.charset();
    }

    public static Charset getUTF8() {
        return Charset.forName("UTF-8");
    }
}

