/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.File;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.util.Path;

public class ExceptionInfo<T> {
    protected final T owner;
    protected Integer revNumber = null;
    protected Nodeid revision;
    protected Path filename;
    protected File localFile;
    private int rangeLeftBoundary = Integer.MIN_VALUE;
    private int rangeRightBoundary = Integer.MIN_VALUE;

    public ExceptionInfo(T owner) {
        this.owner = owner;
    }

    public int getRevisionIndex() {
        return this.revNumber == null ? Integer.MIN_VALUE : this.revNumber;
    }

    public T setRevisionIndex(int rev) {
        this.revNumber = rev;
        return this.owner;
    }

    public boolean isRevisionIndexSet() {
        return this.revNumber != null;
    }

    public Nodeid getRevision() {
        return this.revision;
    }

    public T setRevision(Nodeid r) {
        this.revision = r;
        return this.owner;
    }

    public boolean isRevisionSet() {
        return this.revision != null;
    }

    public Path getFileName() {
        return this.filename;
    }

    public T setFileName(Path name) {
        this.filename = name;
        return this.owner;
    }

    public T setFile(File file) {
        this.localFile = file;
        return this.owner;
    }

    public File getFile() {
        return this.localFile;
    }

    public T setRevisionIndexBoundary(int revisionIndex, int rangeLeft, int rangeRight) {
        this.setRevisionIndex(revisionIndex);
        this.rangeLeftBoundary = rangeLeft;
        this.rangeRightBoundary = rangeRight;
        return this.owner;
    }

    public StringBuilder appendDetails(StringBuilder sb) {
        if (this.filename != null) {
            sb.append("path:'");
            sb.append(this.filename);
            sb.append('\'');
            sb.append(';');
            sb.append(' ');
        }
        if (this.isRevisionIndexSet() || this.isRevisionSet()) {
            if (this.isRevisionIndexSet()) {
                if (this.rangeLeftBoundary != Integer.MIN_VALUE || this.rangeRightBoundary != Integer.MIN_VALUE) {
                    String sr;
                    switch (this.getRevisionIndex()) {
                        case -2147483648: {
                            sr = "UNKNOWN";
                            break;
                        }
                        case -3: {
                            sr = "TIP";
                            break;
                        }
                        case -2: {
                            sr = "WORKING-COPY";
                            break;
                        }
                        case -1: {
                            sr = "NO REVISION";
                            break;
                        }
                        default: {
                            sr = String.valueOf(this.getRevisionIndex());
                        }
                    }
                    sb.append(String.format("%s is not from [%d..%d]", sr, this.rangeLeftBoundary, this.rangeRightBoundary));
                } else {
                    sb.append("rev:");
                    sb.append(this.getRevisionIndex());
                    if (this.isRevisionSet()) {
                        sb.append(':');
                    }
                }
            }
            if (this.isRevisionSet()) {
                sb.append(this.getRevision().shortNotation());
            }
        }
        if (this.localFile != null) {
            sb.append(';');
            sb.append(' ');
            sb.append(" file:");
            sb.append(this.localFile.getPath());
            sb.append(',');
            if (this.localFile.exists()) {
                sb.append("EXISTS");
            } else {
                sb.append("DOESN'T EXIST");
            }
        }
        return sb;
    }
}

