/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.internal.EncodingHelper;
import org.tmatesoft.hg.internal.FNCachePathHelper;
import org.tmatesoft.hg.internal.FileUtils;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.internal.RevlogStream;
import org.tmatesoft.hg.internal.Transaction;
import org.tmatesoft.hg.repo.HgRepositoryFiles;
import org.tmatesoft.hg.util.Path;

public class FNCacheFile {
    private final Internals repo;
    private final List<Path> addedDotI;
    private final List<Path> addedDotD;
    private final FNCachePathHelper pathHelper;

    public FNCacheFile(Internals internalRepo) {
        this.repo = internalRepo;
        this.pathHelper = new FNCachePathHelper();
        this.addedDotI = new ArrayList<Path>(5);
        this.addedDotD = new ArrayList<Path>(5);
    }

    public void write(Transaction tr) throws HgIOException {
        if (this.addedDotI.isEmpty() && this.addedDotD.isEmpty()) {
            return;
        }
        File f = this.repo.getRepositoryFile(HgRepositoryFiles.FNCache);
        f.getParentFile().mkdirs();
        EncodingHelper fnEncoder = this.repo.buildFileNameEncodingHelper();
        ArrayList<CharBuffer> added = new ArrayList<CharBuffer>();
        for (Path p : this.addedDotI) {
            added.add(CharBuffer.wrap(this.pathHelper.rewrite(p)));
        }
        for (Path p : this.addedDotD) {
            CharSequence cs = this.pathHelper.rewrite(p);
            CharBuffer cb = CharBuffer.allocate(cs.length());
            cb.append(cs);
            cb.put(cs.length() - 1, 'd');
            cb.flip();
            added.add(cb);
        }
        FileOutputStream fos = null;
        f = tr.prepare(f);
        try {
            try {
                fos = new FileOutputStream(f, true);
                FileChannel fncacheFile = fos.getChannel();
                ByteBuffer lf = ByteBuffer.wrap(new byte[]{10});
                for (CharBuffer b : added) {
                    fncacheFile.write(fnEncoder.toFNCache(b));
                    fncacheFile.write(lf);
                    lf.rewind();
                }
                fncacheFile.force(true);
                tr.done(f);
            }
            catch (IOException ex) {
                tr.failure(f, ex);
                throw new HgIOException("Failed to write fncache", ex, f);
            }
        }
        finally {
            new FileUtils(this.repo.getLog(), this).closeQuietly(fos, f);
        }
    }

    public void addIndex(Path p) {
        this.addedDotI.add(p);
    }

    public void addData(Path p) {
        this.addedDotD.add(p);
    }

    public static class Mediator {
        private final Internals repo;
        private FNCacheFile fncache;
        private final Transaction tr;

        public Mediator(Internals internalRepo, Transaction transaction) {
            this.repo = internalRepo;
            this.tr = transaction;
        }

        public void registerNew(Path f, RevlogStream rs) {
            if (this.fncache != null || this.repo.fncacheInUse()) {
                if (this.fncache == null) {
                    this.fncache = new FNCacheFile(this.repo);
                }
                this.fncache.addIndex(f);
                if (!rs.isInlineData()) {
                    this.fncache.addData(f);
                }
            }
        }

        public void complete() throws HgIOException {
            if (this.fncache != null) {
                this.fncache.write(this.tr);
            }
        }
    }
}

