/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.core.SessionContext;
import org.tmatesoft.hg.internal.DataSerializer;
import org.tmatesoft.hg.internal.FileUtils;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.util.Path;

public class FileContentSupplier
implements DataSerializer.DataSource {
    private final File file;
    private final SessionContext ctx;

    public FileContentSupplier(HgRepository repo, Path file) {
        this((SessionContext.Source)repo, new File(repo.getWorkingDir(), file.toString()));
    }

    public FileContentSupplier(SessionContext.Source ctxSource, File f) {
        this.ctx = ctxSource.getSessionContext();
        this.file = f;
    }

    @Override
    public void serialize(DataSerializer out) throws HgIOException {
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(this.file);
                FileChannel fc = fis.getChannel();
                ByteBuffer buffer = ByteBuffer.allocate((int)Math.min(102400L, fc.size()));
                while (fc.read(buffer) != -1) {
                    buffer.flip();
                    out.write(buffer.array(), 0, buffer.limit());
                    buffer.clear();
                }
            }
            catch (IOException ex) {
                throw new HgIOException("Failed to get content of the file", ex, this.file);
            }
        }
        finally {
            new FileUtils(this.ctx.getLog(), this).closeQuietly(fis);
        }
    }

    @Override
    public int serializeLength() {
        return Internals.ltoi(this.file.length());
    }
}

